/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.lower;

import androidx.compose.compiler.plugins.kotlin.lower.CaptureCollector;
import androidx.compose.compiler.plugins.kotlin.lower.DeclarationContext;
import androidx.compose.compiler.plugins.kotlin.lower.FunctionContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\"\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010\u0007H\u0016J\u0010\u0010%\u001a\u00020#2\u0006\u0010&\u001a\u00020\fH\u0016J\u0010\u0010'\u001a\u00020#2\u0006\u0010&\u001a\u00020\fH\u0016J\u0012\u0010(\u001a\u00020#2\b\u0010$\u001a\u0004\u0018\u00010)H\u0016J\u0012\u0010(\u001a\u00020\u00122\b\u0010$\u001a\u0004\u0018\u00010\u0007H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0016\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0013\u0010\u001f\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006*"}, d2={"Landroidx/compose/compiler/plugins/kotlin/lower/ClassContext;", "Landroidx/compose/compiler/plugins/kotlin/lower/DeclarationContext;", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "(Lorg/jetbrains/kotlin/ir/declarations/IrClass;)V", "captures", "", "Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "getCaptures", "()Ljava/util/Set;", "collectors", "", "Landroidx/compose/compiler/plugins/kotlin/lower/CaptureCollector;", "getCollectors", "()Ljava/util/List;", "setCollectors", "(Ljava/util/List;)V", "composable", "", "getComposable", "()Z", "getDeclaration", "()Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "functionContext", "Landroidx/compose/compiler/plugins/kotlin/lower/FunctionContext;", "getFunctionContext", "()Landroidx/compose/compiler/plugins/kotlin/lower/FunctionContext;", "symbol", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "getSymbol", "()Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "thisParam", "getThisParam", "()Lorg/jetbrains/kotlin/ir/declarations/IrValueDeclaration;", "declareLocal", "", "local", "popCollector", "collector", "pushCollector", "recordCapture", "Lorg/jetbrains/kotlin/ir/declarations/IrSymbolOwner;", "compiler-hosted"})
final class ClassContext
extends DeclarationContext {
    @NotNull
    private final IrClass declaration;
    private final boolean composable;
    @Nullable
    private final FunctionContext functionContext;
    @NotNull
    private final Set<IrValueDeclaration> captures;
    @Nullable
    private final IrValueDeclaration thisParam;
    @NotNull
    private List<CaptureCollector> collectors;

    public ClassContext(@NotNull IrClass declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        this.declaration = declaration;
        this.captures = new LinkedHashSet();
        IrValueParameter irValueParameter = this.getDeclaration().getThisReceiver();
        Intrinsics.checkNotNull((Object)irValueParameter);
        this.thisParam = (IrValueDeclaration)irValueParameter;
        this.collectors = new ArrayList();
    }

    @NotNull
    public IrClass getDeclaration() {
        return this.declaration;
    }

    @Override
    public boolean getComposable() {
        return this.composable;
    }

    @NotNull
    public IrClassSymbol getSymbol() {
        return this.getDeclaration().getSymbol();
    }

    @Override
    @Nullable
    public FunctionContext getFunctionContext() {
        return this.functionContext;
    }

    @Override
    @NotNull
    public Set<IrValueDeclaration> getCaptures() {
        return this.captures;
    }

    @Nullable
    public final IrValueDeclaration getThisParam() {
        return this.thisParam;
    }

    @NotNull
    public final List<CaptureCollector> getCollectors() {
        return this.collectors;
    }

    public final void setCollectors(@NotNull List<CaptureCollector> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.collectors = list;
    }

    @Override
    public void declareLocal(@Nullable IrValueDeclaration local) {
    }

    @Override
    public boolean recordCapture(@Nullable IrValueDeclaration local) {
        boolean isClassParam;
        boolean isThis = Intrinsics.areEqual((Object)local, (Object)this.thisParam);
        IrValueDeclaration irValueDeclaration = local;
        Object object = irValueDeclaration != null ? irValueDeclaration.getParent() : null;
        IrConstructor irConstructor = object instanceof IrConstructor ? (IrConstructor)object : null;
        boolean isCtorParam = (irConstructor != null ? irConstructor.getParent() : null) == this.getDeclaration();
        boolean bl = isClassParam = isThis || isCtorParam;
        if (local != null && !((Collection)this.collectors).isEmpty() && isClassParam) {
            for (CaptureCollector collector : this.collectors) {
                collector.recordCapture(local);
            }
        }
        if (local != null && AdditionalIrUtilsKt.isLocal((IrDeclaration)((IrDeclaration)this.getDeclaration())) && !isClassParam) {
            this.getCaptures().add(local);
        }
        return isClassParam;
    }

    @Override
    public void recordCapture(@Nullable IrSymbolOwner local) {
    }

    @Override
    public void pushCollector(@NotNull CaptureCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.collectors.add(collector);
    }

    @Override
    public void popCollector(@NotNull CaptureCollector collector) {
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        if (!Intrinsics.areEqual((Object)CollectionsKt.lastOrNull(this.collectors), (Object)collector)) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        this.collectors.remove(this.collectors.size() - 1);
    }
}

