/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin.analysis;

import androidx.compose.compiler.plugins.kotlin.ComposeFqNames;
import androidx.compose.compiler.plugins.kotlin.analysis.KnownStableConstructs;
import androidx.compose.compiler.plugins.kotlin.analysis.Stability;
import androidx.compose.compiler.plugins.kotlin.lower.AbstractComposeLoweringKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.backend.jvm.ir.JvmIrTypeUtilsKt;
import org.jetbrains.kotlin.ir.IrStatement;
import org.jetbrains.kotlin.ir.declarations.IrAnnotationContainer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationOrigin;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationParent;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrClassifierSymbol;
import org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol;
import org.jetbrains.kotlin.ir.types.IrDynamicType;
import org.jetbrains.kotlin.ir.types.IrErrorType;
import org.jetbrains.kotlin.ir.types.IrSimpleType;
import org.jetbrains.kotlin.ir.types.IrStarProjection;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypeAbbreviation;
import org.jetbrains.kotlin.ir.types.IrTypeArgument;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypeProjection;
import org.jetbrains.kotlin.ir.types.IrTypeUtilsKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.AdditionalIrUtilsKt;
import org.jetbrains.kotlin.ir.util.InlineClassesKt;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000n\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u0010\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\f2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00132\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\t2\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002\u001a\u001e\u0010\u0016\u001a\u00020\u0017*\u00020\u00052\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00170\u0019\u001a\f\u0010\u001a\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u001c\u001a\n\u0010\u001d\u001a\u00020\u0001*\u00020\u0005\u001a\f\u0010\u001e\u001a\u00020\u0001*\u00020\u0003H\u0002\u001a\f\u0010\u001f\u001a\u00020\u0001*\u00020 H\u0002\u001a\n\u0010!\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010\"\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010#\u001a\u00020\u0001*\u00020\u0005\u001a\n\u0010$\u001a\u00020\u0005*\u00020\u0005\u001a\u0013\u0010%\u001a\u0004\u0018\u00010&*\u00020\u001cH\u0002\u00a2\u0006\u0002\u0010'\u001a\u0018\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007*\u00020)H\u0002\u00a8\u0006*"}, d2={"canInferStability", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "stabilityOf", "Landroidx/compose/compiler/plugins/kotlin/analysis/Stability;", "substitutions", "", "Lorg/jetbrains/kotlin/ir/symbols/IrTypeParameterSymbol;", "Lorg/jetbrains/kotlin/ir/types/IrTypeArgument;", "currentlyAnalyzing", "", "Lorg/jetbrains/kotlin/ir/symbols/IrClassifierSymbol;", "expr", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "baseStability", "Lorg/jetbrains/kotlin/ir/expressions/IrExpression;", "classifier", "irType", "Lorg/jetbrains/kotlin/ir/types/IrType;", "type", "argument", "forEach", "", "callback", "Lkotlin/Function1;", "hasStableMarkedDescendant", "hasStableMarker", "Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;", "isExpressible", "isProtobufType", "isStableMarker", "Lorg/jetbrains/kotlin/ir/expressions/IrConstructorCall;", "isUncertain", "knownStable", "knownUnstable", "normalize", "stabilityParamBitmask", "", "(Lorg/jetbrains/kotlin/ir/declarations/IrAnnotationContainer;)Ljava/lang/Integer;", "substitutionMap", "Lorg/jetbrains/kotlin/ir/types/IrSimpleType;", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nStability.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,452:1\n1743#2,3:453\n1722#2,3:456\n1743#2,3:459\n1722#2,3:462\n1851#2,2:465\n1743#2,3:467\n1743#2,3:470\n533#2,6:473\n1569#2,11:479\n1860#2,2:490\n1862#2:493\n1580#2:494\n1549#2:495\n1620#2,3:496\n766#2:499\n857#2,2:500\n1603#2,9:502\n1851#2:511\n1852#2:513\n1612#2:514\n1722#2,3:516\n1#3:492\n1#3:512\n1#3:515\n*S KotlinDebug\n*F\n+ 1 Stability.kt\nandroidx/compose/compiler/plugins/kotlin/analysis/StabilityKt\n*L\n129#1:453,3\n137#1:456,3\n145#1:459,3\n153#1:462,3\n197#1:465,2\n204#1:467,3\n211#1:470,3\n220#1:473,6\n266#1:479,11\n266#1:490,2\n266#1:493\n266#1:494\n398#1:495\n398#1:496,3\n400#1:499\n400#1:500,2\n413#1:502,9\n413#1:511\n413#1:513\n413#1:514\n443#1:516,3\n266#1:492\n413#1:512\n*E\n"})
public final class StabilityKt {
    public static final boolean knownUnstable(@NotNull Stability $this$knownUnstable) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$knownUnstable, (String)"<this>");
            Stability stability = $this$knownUnstable;
            if (stability instanceof Stability.Certain) {
                bl = !((Stability.Certain)$this$knownUnstable).getStable();
            } else if (stability instanceof Stability.Runtime) {
                bl = false;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = false;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$any$iv = ((Stability.Combined)$this$knownUnstable).getElements();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (!StabilityKt.knownUnstable(it)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean knownStable(@NotNull Stability $this$knownStable) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$knownStable, (String)"<this>");
            Stability stability = $this$knownStable;
            if (stability instanceof Stability.Certain) {
                bl = ((Stability.Certain)$this$knownStable).getStable();
            } else if (stability instanceof Stability.Runtime) {
                bl = false;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = false;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$all$iv = ((Stability.Combined)$this$knownStable).getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (StabilityKt.knownStable(it)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean isUncertain(@NotNull Stability $this$isUncertain) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$isUncertain, (String)"<this>");
            Stability stability = $this$isUncertain;
            if (stability instanceof Stability.Certain) {
                bl = false;
            } else if (stability instanceof Stability.Runtime) {
                bl = true;
            } else if (stability instanceof Stability.Unknown) {
                bl = true;
            } else if (stability instanceof Stability.Parameter) {
                bl = true;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$any$iv = ((Stability.Combined)$this$isUncertain).getElements();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (!StabilityKt.isUncertain(it)) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final boolean isExpressible(@NotNull Stability $this$isExpressible) {
        boolean bl;
        block13: {
            Intrinsics.checkNotNullParameter((Object)$this$isExpressible, (String)"<this>");
            Stability stability = $this$isExpressible;
            if (stability instanceof Stability.Certain) {
                bl = true;
            } else if (stability instanceof Stability.Runtime) {
                bl = true;
            } else if (stability instanceof Stability.Unknown) {
                bl = false;
            } else if (stability instanceof Stability.Parameter) {
                bl = true;
            } else if (stability instanceof Stability.Combined) {
                Iterable $this$all$iv = ((Stability.Combined)$this$isExpressible).getElements();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        Stability it = (Stability)element$iv;
                        boolean bl2 = false;
                        if (StabilityKt.isExpressible(it)) continue;
                        bl = false;
                        break block13;
                    }
                    bl = true;
                }
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    @NotNull
    public static final Stability normalize(@NotNull Stability $this$normalize) {
        Intrinsics.checkNotNullParameter((Object)$this$normalize, (String)"<this>");
        Stability stability = $this$normalize;
        if (((stability instanceof Stability.Certain ? true : stability instanceof Stability.Parameter) ? true : stability instanceof Stability.Runtime) ? true : stability instanceof Stability.Unknown) {
            return $this$normalize;
        }
        if (stability instanceof Stability.Combined) {
            // empty if block
        }
        Set parameters2 = new LinkedHashSet();
        List parts = new ArrayList();
        Object[] objectArray = new Stability[]{$this$normalize};
        List stack = CollectionsKt.mutableListOf((Object[])objectArray);
        while (!((Collection)stack).isEmpty()) {
            Stability stability2 = (Stability)stack.remove(stack.size() - 1);
            if (stability2 instanceof Stability.Combined) {
                stack.addAll((Collection)((Stability.Combined)stability2).getElements());
                continue;
            }
            if (stability2 instanceof Stability.Certain) {
                if (((Stability.Certain)stability2).getStable()) continue;
                return Stability.Companion.getUnstable();
            }
            if (stability2 instanceof Stability.Parameter) {
                if (!parameters2.contains(((Stability.Parameter)stability2).getParameter().getSymbol())) continue;
                parameters2.add(((Stability.Parameter)stability2).getParameter().getSymbol());
                parts.add(stability2);
                continue;
            }
            if (stability2 instanceof Stability.Runtime) {
                parts.add(stability2);
                continue;
            }
            if (!(stability2 instanceof Stability.Unknown)) continue;
        }
        return new Stability.Combined(parts);
    }

    public static final void forEach(@NotNull Stability $this$forEach, @NotNull Function1<? super Stability, Unit> callback) {
        Intrinsics.checkNotNullParameter((Object)$this$forEach, (String)"<this>");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if ($this$forEach instanceof Stability.Combined) {
            Iterable $this$forEach$iv = ((Stability.Combined)$this$forEach).getElements();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Stability it = (Stability)element$iv;
                boolean bl = false;
                StabilityKt.forEach(it, callback);
            }
        } else {
            callback.invoke((Object)$this$forEach);
        }
    }

    public static final boolean hasStableMarker(@NotNull IrAnnotationContainer $this$hasStableMarker) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$hasStableMarker, (String)"<this>");
            Iterable $this$any$iv = $this$hasStableMarker.getAnnotations();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    IrConstructorCall it = (IrConstructorCall)element$iv;
                    boolean bl2 = false;
                    if (!StabilityKt.isStableMarker(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final boolean isStableMarker(IrConstructorCall $this$isStableMarker) {
        IrClassSymbol irClassSymbol = AbstractComposeLoweringKt.getAnnotationClass($this$isStableMarker);
        return irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null ? IrUtilsKt.hasAnnotation((IrAnnotationContainer)((IrAnnotationContainer)irClassSymbol), (FqName)ComposeFqNames.INSTANCE.getStableMarker()) : false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean hasStableMarkedDescendant(IrClass $this$hasStableMarkedDescendant) {
        boolean bl;
        if (StabilityKt.hasStableMarker((IrAnnotationContainer)$this$hasStableMarkedDescendant)) {
            return true;
        }
        Iterable $this$any$iv = $this$hasStableMarkedDescendant.getSuperTypes();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            IrType it = (IrType)element$iv;
            boolean bl2 = false;
            if (!IrTypePredicatesKt.isAny((IrType)it)) {
                boolean bl3;
                IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)it);
                if (irClassSymbol != null && (irClassSymbol = (IrClass)irClassSymbol.getOwner()) != null) {
                    if (StabilityKt.hasStableMarkedDescendant((IrClass)irClassSymbol)) {
                        return true;
                    }
                    bl3 = false;
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private static final boolean isProtobufType(IrClass $this$isProtobufType) {
        FqName fqName;
        IrClass irClass;
        IrClassSymbol irClassSymbol;
        Object v0;
        block2: {
            if (!IrUtilsKt.isFinalClass((IrClass)$this$isProtobufType)) {
                return false;
            }
            List $this$lastOrNull$iv = $this$isProtobufType.getSuperTypes();
            boolean $i$f$lastOrNull = false;
            ListIterator iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                Object element$iv = iterator$iv.previous();
                IrType it = (IrType)element$iv;
                boolean bl = false;
                if (!(!org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isInterface((IrType)it))) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        IrType irType = v0;
        String directParentClassName = irType != null && (irClassSymbol = IrTypesKt.getClassOrNull((IrType)irType)) != null && (irClass = (IrClass)irClassSymbol.getOwner()) != null && (fqName = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)irClass))) != null ? fqName.toString() : null;
        return Intrinsics.areEqual(directParentClassName, (Object)"com.google.protobuf.GeneratedMessageLite") || Intrinsics.areEqual(directParentClassName, (Object)"com.google.protobuf.GeneratedMessage");
    }

    private static final Integer stabilityParamBitmask(IrAnnotationContainer $this$stabilityParamBitmask) {
        IrConstructorCall irConstructorCall = AdditionalIrUtilsKt.findAnnotation((List)$this$stabilityParamBitmask.getAnnotations(), (FqName)ComposeFqNames.INSTANCE.getStabilityInferred());
        IrExpression irExpression = irConstructorCall != null ? irConstructorCall.getValueArgument(0) : null;
        IrConst irConst = irExpression instanceof IrConst ? (IrConst)irExpression : null;
        Object object = irConst != null ? irConst.getValue() : null;
        return object instanceof Integer ? (Integer)object : null;
    }

    @NotNull
    public static final Stability stabilityOf(@NotNull IrType irType) {
        Intrinsics.checkNotNullParameter((Object)irType, (String)"irType");
        return StabilityKt.stabilityOf(irType, (Map<IrTypeParameterSymbol, ? extends IrTypeArgument>)MapsKt.emptyMap(), (Set<? extends IrClassifierSymbol>)SetsKt.emptySet());
    }

    /*
     * WARNING - void declaration
     */
    private static final Stability stabilityOf(IrClass declaration, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<? extends IrClassifierSymbol> currentlyAnalyzing) {
        IrClassSymbol symbol = declaration.getSymbol();
        if (currentlyAnalyzing.contains(symbol)) {
            return Stability.Companion.getUnstable();
        }
        if (StabilityKt.hasStableMarkedDescendant(declaration)) {
            return Stability.Companion.getStable();
        }
        if (IrUtilsKt.isEnumClass((IrClass)declaration) || IrUtilsKt.isEnumEntry((IrClass)declaration)) {
            return Stability.Companion.getStable();
        }
        if (IrTypePredicatesKt.isPrimitiveType$default((IrType)((IrType)IrUtilsKt.getDefaultType((IrClass)declaration)), (boolean)false, (int)1, null)) {
            return Stability.Companion.getStable();
        }
        if (StabilityKt.isProtobufType(declaration)) {
            return Stability.Companion.getStable();
        }
        if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.IR_BUILTINS_STUB.INSTANCE)) {
            throw new IllegalStateException(("Builtins Stub: " + declaration.getName()).toString());
        }
        Set analyzing = SetsKt.plus(currentlyAnalyzing, (Object)symbol);
        if (StabilityKt.canInferStability(declaration)) {
            Stability stability;
            Object object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
            if (object == null || (object = object.toString()) == null) {
                object = "";
            }
            Object fqName = object;
            Stability stability2 = null;
            int mask = 0;
            if (KnownStableConstructs.INSTANCE.getStableTypes().containsKey(fqName)) {
                Integer n = KnownStableConstructs.INSTANCE.getStableTypes().get(fqName);
                mask = n != null ? n : 0;
                stability2 = Stability.Companion.getStable();
            } else {
                Integer n = StabilityKt.stabilityParamBitmask((IrAnnotationContainer)declaration);
                if (n == null) {
                    return Stability.Companion.getUnstable();
                }
                mask = n;
                stability2 = new Stability.Runtime(declaration);
            }
            if (mask == 0) {
                stability = stability2;
            } else {
                void $this$mapIndexedNotNullTo$iv$iv;
                void $this$mapIndexedNotNull$iv;
                Iterable iterable = declaration.getTypeParameters();
                Stability stability3 = stability2;
                boolean $i$f$mapIndexedNotNull = false;
                void var11_14 = $this$mapIndexedNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapIndexedNotNullTo = false;
                void $this$forEachIndexed$iv$iv$iv = $this$mapIndexedNotNullTo$iv$iv;
                boolean $i$f$forEachIndexed = false;
                int index$iv$iv$iv = 0;
                for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
                    Stability it$iv$iv;
                    void irTypeParameter;
                    IrTypeArgument sub;
                    void element$iv$iv;
                    int n;
                    if ((n = index$iv$iv$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    Object t = item$iv$iv$iv;
                    int index$iv$iv = n;
                    boolean bl = false;
                    IrTypeParameter irTypeParameter2 = (IrTypeParameter)element$iv$iv;
                    int index = index$iv$iv;
                    boolean bl2 = false;
                    if (((mask & 1 << index) != 0 ? ((sub = substitutions.get(irTypeParameter.getSymbol())) != null ? StabilityKt.stabilityOf(sub, substitutions, (Set<? extends IrClassifierSymbol>)analyzing) : (Stability)new Stability.Parameter((IrTypeParameter)irTypeParameter)) : null) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                List list = (List)destination$iv$iv;
                stability = stability3.plus(new Stability.Combined(list));
            }
            return stability;
        }
        if (Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_JAVA_DECLARATION_STUB.INSTANCE)) {
            return Stability.Companion.getUnstable();
        }
        if (IrUtilsKt.isInterface((IrClass)declaration)) {
            return new Stability.Unknown(declaration);
        }
        Stability stability = null;
        stability = Stability.Companion.getStable();
        for (IrDeclaration member : declaration.getDeclarations()) {
            IrDeclaration irDeclaration = member;
            if (irDeclaration instanceof IrProperty) {
                if (((IrProperty)member).getBackingField() != null) {
                    IrField it;
                    boolean bl = false;
                    if (((IrProperty)member).isVar() && !((IrProperty)member).isDelegated()) {
                        return Stability.Companion.getUnstable();
                    }
                    stability = stability.plus(StabilityKt.stabilityOf(it.getType(), substitutions, (Set<? extends IrClassifierSymbol>)analyzing));
                }
                continue;
            }
            if (!(irDeclaration instanceof IrField)) continue;
            stability = stability.plus(StabilityKt.stabilityOf(((IrField)member).getType(), substitutions, (Set<? extends IrClassifierSymbol>)analyzing));
        }
        return stability;
    }

    private static final boolean canInferStability(IrClass declaration) {
        Object object = IrUtilsKt.getFqNameWhenAvailable((IrDeclarationWithName)((IrDeclarationWithName)declaration));
        if (object == null || (object = object.toString()) == null) {
            object = "";
        }
        Object fqName = object;
        return KnownStableConstructs.INSTANCE.getStableTypes().containsKey(fqName) || Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)IrDeclarationOrigin.IR_EXTERNAL_DECLARATION_STUB.INSTANCE);
    }

    private static final Stability stabilityOf(IrClassifierSymbol classifier, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<? extends IrClassifierSymbol> currentlyAnalyzing) {
        Stability stability;
        IrSymbolOwner owner = classifier.getOwner();
        if (owner instanceof IrClass) {
            stability = StabilityKt.stabilityOf((IrClass)owner, substitutions, currentlyAnalyzing);
        } else if (owner instanceof IrTypeParameter) {
            stability = Stability.Companion.getUnstable();
        } else {
            throw new IllegalStateException(("Unexpected IrClassifier: " + owner).toString());
        }
        return stability;
    }

    private static final Stability stabilityOf(IrTypeArgument argument, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<? extends IrClassifierSymbol> currentlyAnalyzing) {
        Stability stability;
        IrTypeArgument irTypeArgument = argument;
        if (irTypeArgument instanceof IrStarProjection) {
            stability = Stability.Companion.getUnstable();
        } else if (irTypeArgument instanceof IrTypeProjection) {
            stability = StabilityKt.stabilityOf(((IrTypeProjection)argument).getType(), substitutions, currentlyAnalyzing);
        } else {
            throw new IllegalStateException(("Unexpected IrTypeArgument: " + argument).toString());
        }
        return stability;
    }

    private static final Stability stabilityOf(IrType type, Map<IrTypeParameterSymbol, ? extends IrTypeArgument> substitutions, Set<? extends IrClassifierSymbol> currentlyAnalyzing) {
        Stability stability;
        if (type instanceof IrErrorType) {
            stability = Stability.Companion.getUnstable();
        } else if (type instanceof IrDynamicType) {
            stability = Stability.Companion.getUnstable();
        } else if (IrTypePredicatesKt.isUnit((IrType)type) || IrTypePredicatesKt.isPrimitiveType$default((IrType)type, (boolean)false, (int)1, null) || org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isFunctionOrKFunction((IrType)type) || IrTypePredicatesKt.isString((IrType)type)) {
            stability = Stability.Companion.getStable();
        } else if (org.jetbrains.kotlin.ir.util.IrTypeUtilsKt.isTypeParameter((IrType)type)) {
            IrClassifierSymbol irClassifierSymbol = IrTypesKt.getClassifierOrNull((IrType)type);
            Intrinsics.checkNotNull((Object)irClassifierSymbol, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.symbols.IrTypeParameterSymbol");
            IrTypeArgument arg = substitutions.get((IrTypeParameterSymbol)irClassifierSymbol);
            if (arg != null) {
                stability = StabilityKt.stabilityOf(arg, substitutions, currentlyAnalyzing);
            } else {
                IrSymbolOwner irSymbolOwner = IrTypesKt.getClassifierOrFail((IrType)type).getOwner();
                Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrTypeParameter");
                stability = new Stability.Parameter((IrTypeParameter)irSymbolOwner);
            }
        } else if (IrTypeUtilsKt.isNullable((IrType)type)) {
            stability = StabilityKt.stabilityOf(IrTypesKt.makeNotNull((IrType)type), substitutions, currentlyAnalyzing);
        } else if (JvmIrTypeUtilsKt.isInlineClassType((IrType)type)) {
            IrClass irClass = IrTypesKt.getClass((IrType)type);
            if (irClass == null) {
                throw new IllegalStateException(("Failed to resolve the class definition of inline type " + type).toString());
            }
            IrClass inlineClassDeclaration = irClass;
            stability = StabilityKt.hasStableMarker((IrAnnotationContainer)inlineClassDeclaration) ? Stability.Companion.getStable() : StabilityKt.stabilityOf((IrType)InlineClassesKt.getInlineClassUnderlyingType((IrClass)inlineClassDeclaration), substitutions, currentlyAnalyzing);
        } else if (type instanceof IrSimpleType) {
            stability = StabilityKt.stabilityOf(((IrSimpleType)type).getClassifier(), (Map<IrTypeParameterSymbol, ? extends IrTypeArgument>)MapsKt.plus(substitutions, StabilityKt.substitutionMap((IrSimpleType)type)), currentlyAnalyzing);
        } else if (type instanceof IrTypeAbbreviation) {
            IrType aliased = ((IrTypeAlias)((IrTypeAbbreviation)type).getTypeAlias().getOwner()).getExpandedType();
            stability = StabilityKt.stabilityOf(aliased, substitutions, currentlyAnalyzing);
        } else {
            throw new IllegalStateException(("Unexpected IrType: " + type).toString());
        }
        return stability;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map<IrTypeParameterSymbol, IrTypeArgument> substitutionMap(IrSimpleType $this$substitutionMap) {
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv;
        IrClassSymbol irClassSymbol = IrTypesKt.getClassOrNull((IrType)((IrType)$this$substitutionMap));
        if (irClassSymbol == null) {
            return MapsKt.emptyMap();
        }
        IrClassSymbol cls = irClassSymbol;
        Iterable $this$map$iv = ((IrClass)cls.getOwner()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IrTypeParameter irTypeParameter = (IrTypeParameter)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        List params = (List)destination$iv$iv;
        List args = $this$substitutionMap.getArguments();
        Iterable $this$filter$iv = CollectionsKt.zip((Iterable)params, (Iterable)args);
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            IrTypeParameterSymbol param = (IrTypeParameterSymbol)pair.component1();
            IrTypeArgument arg = (IrTypeArgument)pair.component2();
            IrSimpleType irSimpleType = arg instanceof IrSimpleType ? (IrSimpleType)arg : null;
            if (!(!Intrinsics.areEqual((Object)param, (Object)(irSimpleType != null ? irSimpleType.getClassifier() : null)))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        return MapsKt.toMap((Iterable)((List)destination$iv$iv2));
    }

    /*
     * WARNING - void declaration
     */
    private static final Stability stabilityOf(IrCall expr, Stability baseStability) {
        Stability stability;
        IrSimpleFunction function = (IrSimpleFunction)expr.getSymbol().getOwner();
        FqName fqName = AdditionalIrUtilsKt.getKotlinFqName((IrDeclarationParent)((IrDeclarationParent)function));
        Integer mask = KnownStableConstructs.INSTANCE.getStableFunctions().get(fqName.asString());
        if (mask == null) {
            stability = baseStability;
        } else if (mask == 0) {
            stability = Stability.Companion.getStable();
        } else {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = (Iterable)RangesKt.until((int)0, (int)expr.getTypeArgumentsCount());
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Stability it$iv$iv;
                IrType sub;
                int element$iv$iv$iv;
                int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
                boolean bl = false;
                int index = element$iv$iv;
                boolean bl2 = false;
                if (((mask & 1 << index) != 0 ? ((sub = expr.getTypeArgument(index)) != null ? StabilityKt.stabilityOf(sub) : Stability.Companion.getUnstable()) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list = (List)destination$iv$iv;
            stability = new Stability.Combined(list);
        }
        return stability;
    }

    @NotNull
    public static final Stability stabilityOf(@NotNull IrExpression expr) {
        Stability stability;
        block10: {
            IrExpression irExpression;
            Stability stability2;
            block12: {
                block13: {
                    block14: {
                        block11: {
                            block9: {
                                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                                stability2 = StabilityKt.stabilityOf(expr.getType());
                                if (StabilityKt.knownStable(stability2)) {
                                    return stability2;
                                }
                                irExpression = expr;
                                if (!(irExpression instanceof IrConst)) break block9;
                                stability = Stability.Companion.getStable();
                                break block10;
                            }
                            if (!(irExpression instanceof IrCall)) break block11;
                            stability = StabilityKt.stabilityOf((IrCall)expr, stability2);
                            break block10;
                        }
                        if (!(irExpression instanceof IrGetValue)) break block12;
                        IrValueDeclaration owner = ((IrGetValue)expr).getSymbol().getOwner();
                        if (!(owner instanceof IrVariable) || ((IrVariable)owner).isVar()) break block13;
                        stability = ((IrVariable)owner).getInitializer();
                        if (stability == null) break block14;
                        Stability it = stability;
                        boolean bl = false;
                        Stability stability3 = StabilityKt.stabilityOf((IrExpression)it);
                        stability = stability3;
                        if (stability3 != null) break block10;
                    }
                    stability = stability2;
                    break block10;
                }
                stability = stability2;
                break block10;
            }
            if (irExpression instanceof IrComposite) {
                boolean bl;
                block8: {
                    Iterable $this$all$iv = ((IrComposite)expr).getStatements();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            IrStatement it = (IrStatement)element$iv;
                            boolean bl2 = false;
                            if (it instanceof IrExpression && StabilityKt.knownStable(StabilityKt.stabilityOf((IrExpression)it))) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                stability = bl ? Stability.Companion.getStable() : stability2;
            } else {
                stability = stability2;
            }
        }
        return stability;
    }
}

