/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.EmptyModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.IrValidatorKt;
import androidx.compose.compiler.plugins.kotlin.ModuleMetrics;
import androidx.compose.compiler.plugins.kotlin.ModuleMetricsImpl;
import androidx.compose.compiler.plugins.kotlin.VersionChecker;
import androidx.compose.compiler.plugins.kotlin.lower.ClassStabilityTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableFunInterfaceLowering;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableFunctionBodyTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableSymbolRemapper;
import androidx.compose.compiler.plugins.kotlin.lower.ComposableTargetAnnotationsTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.ComposerIntrinsicTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.ComposerLambdaMemoization;
import androidx.compose.compiler.plugins.kotlin.lower.ComposerParamTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.CopyDefaultValuesFromExpectLowering;
import androidx.compose.compiler.plugins.kotlin.lower.DurableFunctionKeyTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.DurableKeyVisitor;
import androidx.compose.compiler.plugins.kotlin.lower.KlibAssignableParamTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.LiveLiteralTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.WrapJsComposableLambdaLowering;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.CreateDecoysTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.RecordDecoySignaturesTransformer;
import androidx.compose.compiler.plugins.kotlin.lower.decoys.SubstituteDecoyCallsTransformer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.extensions.IrGenerationExtension;
import org.jetbrains.kotlin.backend.common.extensions.IrPluginContext;
import org.jetbrains.kotlin.backend.common.serialization.DeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.GlobalDeclarationTable;
import org.jetbrains.kotlin.backend.common.serialization.signature.IdSignatureSerializer;
import org.jetbrains.kotlin.backend.common.serialization.signature.PublicIdSignatureComputer;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsGlobalDeclarationTable;
import org.jetbrains.kotlin.ir.backend.js.lower.serialization.ir.JsManglerIr;
import org.jetbrains.kotlin.ir.builders.TranslationPluginContext;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.DeepCopySymbolRemapper;
import org.jetbrains.kotlin.ir.util.KotlinMangler;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.js.JsPlatformKt;
import org.jetbrains.kotlin.platform.jvm.JvmPlatformKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001Bc\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\n\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\rJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u000e\u0010\b\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeIrGenerationExtension;", "Lorg/jetbrains/kotlin/backend/common/extensions/IrGenerationExtension;", "liveLiteralsEnabled", "", "liveLiteralsV2Enabled", "generateFunctionKeyMetaClasses", "sourceInformationEnabled", "intrinsicRememberEnabled", "decoysEnabled", "metricsDestination", "", "reportsDestination", "validateIr", "(ZZZZZZLjava/lang/String;Ljava/lang/String;Z)V", "metrics", "Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "getMetrics", "()Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;", "setMetrics", "(Landroidx/compose/compiler/plugins/kotlin/ModuleMetrics;)V", "generate", "", "moduleFragment", "Lorg/jetbrains/kotlin/ir/declarations/IrModuleFragment;", "pluginContext", "Lorg/jetbrains/kotlin/backend/common/extensions/IrPluginContext;", "compiler-hosted"})
public final class ComposeIrGenerationExtension
implements IrGenerationExtension {
    private final boolean liveLiteralsEnabled;
    private final boolean liveLiteralsV2Enabled;
    private final boolean generateFunctionKeyMetaClasses;
    private final boolean sourceInformationEnabled;
    private final boolean intrinsicRememberEnabled;
    private final boolean decoysEnabled;
    @Nullable
    private final String metricsDestination;
    @Nullable
    private final String reportsDestination;
    private final boolean validateIr;
    @NotNull
    private ModuleMetrics metrics;

    public ComposeIrGenerationExtension(boolean liveLiteralsEnabled, boolean liveLiteralsV2Enabled, boolean generateFunctionKeyMetaClasses, boolean sourceInformationEnabled, boolean intrinsicRememberEnabled, boolean decoysEnabled, @Nullable String metricsDestination, @Nullable String reportsDestination, boolean validateIr) {
        this.liveLiteralsEnabled = liveLiteralsEnabled;
        this.liveLiteralsV2Enabled = liveLiteralsV2Enabled;
        this.generateFunctionKeyMetaClasses = generateFunctionKeyMetaClasses;
        this.sourceInformationEnabled = sourceInformationEnabled;
        this.intrinsicRememberEnabled = intrinsicRememberEnabled;
        this.decoysEnabled = decoysEnabled;
        this.metricsDestination = metricsDestination;
        this.reportsDestination = reportsDestination;
        this.validateIr = validateIr;
        this.metrics = EmptyModuleMetrics.INSTANCE;
    }

    public /* synthetic */ ComposeIrGenerationExtension(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, String string, String string2, boolean bl7, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        if ((n & 8) != 0) {
            bl4 = true;
        }
        if ((n & 0x10) != 0) {
            bl5 = true;
        }
        if ((n & 0x20) != 0) {
            bl6 = false;
        }
        if ((n & 0x40) != 0) {
            string = null;
        }
        if ((n & 0x80) != 0) {
            string2 = null;
        }
        if ((n & 0x100) != 0) {
            bl7 = false;
        }
        this(bl, bl2, bl3, bl4, bl5, bl6, string, string2, bl7);
    }

    @NotNull
    public final ModuleMetrics getMetrics() {
        return this.metrics;
    }

    public final void setMetrics(@NotNull ModuleMetrics moduleMetrics) {
        Intrinsics.checkNotNullParameter((Object)moduleMetrics, (String)"<set-?>");
        this.metrics = moduleMetrics;
    }

    public void generate(@NotNull IrModuleFragment moduleFragment, @NotNull IrPluginContext pluginContext) {
        IdSignatureSerializer idSignatureBuilder;
        IdSignatureSerializer idSignatureSerializer;
        Intrinsics.checkNotNullParameter((Object)moduleFragment, (String)"moduleFragment");
        Intrinsics.checkNotNullParameter((Object)pluginContext, (String)"pluginContext");
        boolean isKlibTarget = !JvmPlatformKt.isJvm((TargetPlatform)pluginContext.getPlatform());
        new VersionChecker(pluginContext).check();
        if (this.validateIr) {
            IrValidatorKt.validateIr(moduleFragment, pluginContext.getIrBuiltIns());
        }
        ComposableSymbolRemapper symbolRemapper = new ComposableSymbolRemapper();
        if (this.metricsDestination != null || this.reportsDestination != null) {
            String string = moduleFragment.getName().asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"moduleFragment.name.asString()");
            this.metrics = new ModuleMetricsImpl(string);
        }
        new ClassStabilityTransformer(pluginContext, symbolRemapper, this.metrics).lower(moduleFragment);
        new LiveLiteralTransformer(this.liveLiteralsEnabled || this.liveLiteralsV2Enabled, this.liveLiteralsV2Enabled, new DurableKeyVisitor(null, 1, null), pluginContext, symbolRemapper, this.metrics).lower(moduleFragment);
        new ComposableFunInterfaceLowering(pluginContext).lower(moduleFragment);
        DurableFunctionKeyTransformer functionKeyTransformer = new DurableFunctionKeyTransformer(pluginContext, symbolRemapper, this.metrics);
        functionKeyTransformer.lower(moduleFragment);
        new ComposerLambdaMemoization(pluginContext, symbolRemapper, this.metrics).lower(moduleFragment);
        new CopyDefaultValuesFromExpectLowering().lower(moduleFragment);
        JsManglerIr mangler = JsPlatformKt.isJs((TargetPlatform)pluginContext.getPlatform()) ? JsManglerIr.INSTANCE : null;
        if (JsPlatformKt.isJs((TargetPlatform)pluginContext.getPlatform())) {
            JsManglerIr jsManglerIr = mangler;
            Intrinsics.checkNotNull((Object)jsManglerIr);
            idSignatureSerializer = new IdSignatureSerializer(new PublicIdSignatureComputer((KotlinMangler.IrMangler)jsManglerIr), new DeclarationTable((GlobalDeclarationTable)new JsGlobalDeclarationTable(pluginContext.getIrBuiltIns(), null, 2, null)));
        } else {
            idSignatureSerializer = idSignatureBuilder = null;
        }
        if (this.decoysEnabled) {
            if (!(idSignatureBuilder != null)) {
                boolean $i$a$-require-ComposeIrGenerationExtension$generate$32 = false;
                String $i$a$-require-ComposeIrGenerationExtension$generate$32 = "decoys are not supported for " + pluginContext.getPlatform();
                throw new IllegalArgumentException($i$a$-require-ComposeIrGenerationExtension$generate$32.toString());
            }
            new CreateDecoysTransformer(pluginContext, (DeepCopySymbolRemapper)symbolRemapper, idSignatureBuilder, this.metrics).lower(moduleFragment);
            new SubstituteDecoyCallsTransformer(pluginContext, (DeepCopySymbolRemapper)symbolRemapper, idSignatureBuilder, this.metrics).lower(moduleFragment);
        }
        new ComposerParamTransformer(pluginContext, symbolRemapper, this.decoysEnabled, this.metrics).lower(moduleFragment);
        new ComposableTargetAnnotationsTransformer(pluginContext, symbolRemapper, this.metrics).lower(moduleFragment);
        new ComposerIntrinsicTransformer(pluginContext, this.decoysEnabled).lower(moduleFragment);
        new ComposableFunctionBodyTransformer(pluginContext, symbolRemapper, this.metrics, this.sourceInformationEnabled, this.intrinsicRememberEnabled).lower(moduleFragment);
        if (this.decoysEnabled) {
            if (!(idSignatureBuilder != null)) {
                boolean bl = false;
                String string = "decoys are not supported for " + pluginContext.getPlatform();
                throw new IllegalArgumentException(string.toString());
            }
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper;
            JsManglerIr jsManglerIr = mangler;
            Intrinsics.checkNotNull((Object)jsManglerIr);
            new RecordDecoySignaturesTransformer(pluginContext, deepCopySymbolRemapper, idSignatureBuilder, this.metrics, (KotlinMangler.IrMangler)jsManglerIr).lower(moduleFragment);
        }
        if (isKlibTarget) {
            new KlibAssignableParamTransformer(pluginContext, symbolRemapper, this.metrics).lower(moduleFragment);
        }
        if (JsPlatformKt.isJs((TargetPlatform)pluginContext.getPlatform())) {
            DeepCopySymbolRemapper deepCopySymbolRemapper = symbolRemapper;
            IdSignatureSerializer idSignatureSerializer2 = idSignatureBuilder;
            Intrinsics.checkNotNull((Object)idSignatureSerializer2);
            new WrapJsComposableLambdaLowering(pluginContext, deepCopySymbolRemapper, this.metrics, idSignatureSerializer2, this.decoysEnabled).lower(moduleFragment);
        }
        if (this.generateFunctionKeyMetaClasses) {
            functionKeyTransformer.realizeKeyMetaAnnotations(moduleFragment);
        } else {
            functionKeyTransformer.removeKeyMetaClasses(moduleFragment);
        }
        if (this.metricsDestination != null) {
            this.metrics.saveMetricsTo(this.metricsDestination);
        }
        if (this.reportsDestination != null) {
            this.metrics.saveReportsTo(this.reportsDestination);
        }
        if (this.validateIr) {
            IrValidatorKt.validateIr(moduleFragment, pluginContext.getIrBuiltIns());
        }
    }

    @Nullable
    public IrDeclaration resolveSymbol(@NotNull IrSymbol symbol, @NotNull TranslationPluginContext context) {
        return IrGenerationExtension.DefaultImpls.resolveSymbol((IrGenerationExtension)this, (IrSymbol)symbol, (TranslationPluginContext)context);
    }

    public ComposeIrGenerationExtension() {
        this(false, false, false, false, false, false, null, null, false, 511, null);
    }
}

