/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposeConfiguration;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.compiler.plugin.AbstractCliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOption;
import org.jetbrains.kotlin.compiler.plugin.CliOptionProcessingException;
import org.jetbrains.kotlin.compiler.plugin.CommandLineProcessor;
import org.jetbrains.kotlin.config.CompilerConfiguration;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeCommandLineProcessor;", "Lorg/jetbrains/kotlin/compiler/plugin/CommandLineProcessor;", "()V", "pluginId", "", "getPluginId", "()Ljava/lang/String;", "pluginOptions", "", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getPluginOptions", "()Ljava/util/List;", "processOption", "", "option", "Lorg/jetbrains/kotlin/compiler/plugin/AbstractCliOption;", "value", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "Companion", "compiler-hosted"})
public final class ComposeCommandLineProcessor
implements CommandLineProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String pluginId = PLUGIN_ID;
    @NotNull
    private final List<CliOption> pluginOptions;
    @NotNull
    private static final String PLUGIN_ID = "androidx.compose.compiler.plugins.kotlin";
    @NotNull
    private static final CliOption LIVE_LITERALS_ENABLED_OPTION = new CliOption("liveLiterals", "<true|false>", "Enable Live Literals code generation", false, false);
    @NotNull
    private static final CliOption LIVE_LITERALS_V2_ENABLED_OPTION = new CliOption("liveLiteralsEnabled", "<true|false>", "Enable Live Literals code generation (with per-file enabled flags)", false, false);
    @NotNull
    private static final CliOption GENERATE_FUNCTION_KEY_META_CLASSES_OPTION = new CliOption("generateFunctionKeyMetaClasses", "<true|false>", "Generate function key meta classes with annotations indicating the functions and their group keys. Generally used for tooling.", false, false);
    @NotNull
    private static final CliOption SOURCE_INFORMATION_ENABLED_OPTION = new CliOption("sourceInformation", "<true|false>", "Include source information in generated code", false, false);
    @NotNull
    private static final CliOption METRICS_DESTINATION_OPTION = new CliOption("metricsDestination", "<path>", "Save compose build metrics to this folder", false, false);
    @NotNull
    private static final CliOption REPORTS_DESTINATION_OPTION = new CliOption("reportsDestination", "<path>", "Save compose build reports to this folder", false, false);
    @NotNull
    private static final CliOption INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION = new CliOption("intrinsicRemember", "<true|false>", "Include source information in generated code", false, false);
    @NotNull
    private static final CliOption SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION = new CliOption("suppressKotlinVersionCompatibilityCheck", "<true|false>", "Suppress Kotlin version compatibility check", false, false);
    @NotNull
    private static final CliOption DECOYS_ENABLED_OPTION = new CliOption("generateDecoys", "<true|false>", "Generate decoy methods in IR transform", false, false);

    public ComposeCommandLineProcessor() {
        Object[] objectArray = new CliOption[]{LIVE_LITERALS_ENABLED_OPTION, LIVE_LITERALS_V2_ENABLED_OPTION, GENERATE_FUNCTION_KEY_META_CLASSES_OPTION, SOURCE_INFORMATION_ENABLED_OPTION, METRICS_DESTINATION_OPTION, REPORTS_DESTINATION_OPTION, INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION, SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION, DECOYS_ENABLED_OPTION};
        this.pluginOptions = CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    public String getPluginId() {
        return this.pluginId;
    }

    @NotNull
    public List<CliOption> getPluginOptions() {
        return this.pluginOptions;
    }

    public void processOption(@NotNull AbstractCliOption option, @NotNull String value, @NotNull CompilerConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        AbstractCliOption abstractCliOption = option;
        if (Intrinsics.areEqual((Object)abstractCliOption, (Object)LIVE_LITERALS_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)LIVE_LITERALS_V2_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getLIVE_LITERALS_V2_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)GENERATE_FUNCTION_KEY_META_CLASSES_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getGENERATE_FUNCTION_KEY_META_CLASSES_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)SOURCE_INFORMATION_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getSOURCE_INFORMATION_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)METRICS_DESTINATION_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getMETRICS_DESTINATION_KEY(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)REPORTS_DESTINATION_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getREPORTS_DESTINATION_KEY(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getSUPPRESS_KOTLIN_VERSION_COMPATIBILITY_CHECK(), (Object)value);
        } else if (Intrinsics.areEqual((Object)abstractCliOption, (Object)DECOYS_ENABLED_OPTION)) {
            configuration.put(ComposeConfiguration.INSTANCE.getDECOYS_ENABLED_KEY(), (Object)Intrinsics.areEqual((Object)value, (Object)"true"));
        } else {
            throw new CliOptionProcessingException("Unknown option: " + option.getOptionName(), null, 2, null);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0011\u0010\u000b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\u0012X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006\u00a8\u0006\u001b"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposeCommandLineProcessor$Companion;", "", "()V", "DECOYS_ENABLED_OPTION", "Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "getDECOYS_ENABLED_OPTION", "()Lorg/jetbrains/kotlin/compiler/plugin/CliOption;", "GENERATE_FUNCTION_KEY_META_CLASSES_OPTION", "getGENERATE_FUNCTION_KEY_META_CLASSES_OPTION", "INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION", "getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION", "LIVE_LITERALS_ENABLED_OPTION", "getLIVE_LITERALS_ENABLED_OPTION", "LIVE_LITERALS_V2_ENABLED_OPTION", "getLIVE_LITERALS_V2_ENABLED_OPTION", "METRICS_DESTINATION_OPTION", "getMETRICS_DESTINATION_OPTION", "PLUGIN_ID", "", "getPLUGIN_ID", "()Ljava/lang/String;", "REPORTS_DESTINATION_OPTION", "getREPORTS_DESTINATION_OPTION", "SOURCE_INFORMATION_ENABLED_OPTION", "getSOURCE_INFORMATION_ENABLED_OPTION", "SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION", "getSUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION", "compiler-hosted"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPLUGIN_ID() {
            return PLUGIN_ID;
        }

        @NotNull
        public final CliOption getLIVE_LITERALS_ENABLED_OPTION() {
            return LIVE_LITERALS_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getLIVE_LITERALS_V2_ENABLED_OPTION() {
            return LIVE_LITERALS_V2_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getGENERATE_FUNCTION_KEY_META_CLASSES_OPTION() {
            return GENERATE_FUNCTION_KEY_META_CLASSES_OPTION;
        }

        @NotNull
        public final CliOption getSOURCE_INFORMATION_ENABLED_OPTION() {
            return SOURCE_INFORMATION_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getMETRICS_DESTINATION_OPTION() {
            return METRICS_DESTINATION_OPTION;
        }

        @NotNull
        public final CliOption getREPORTS_DESTINATION_OPTION() {
            return REPORTS_DESTINATION_OPTION;
        }

        @NotNull
        public final CliOption getINTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION() {
            return INTRINSIC_REMEMBER_OPTIMIZATION_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getSUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION() {
            return SUPPRESS_KOTLIN_VERSION_CHECK_ENABLED_OPTION;
        }

        @NotNull
        public final CliOption getDECOYS_ENABLED_OPTION() {
            return DECOYS_ENABLED_OPTION;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

