/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.compiler.plugins.kotlin;

import androidx.compose.compiler.plugins.kotlin.ComposableTargetCheckerKt;
import androidx.compose.compiler.plugins.kotlin.ComposeErrors;
import androidx.compose.compiler.plugins.kotlin.ComposeFqNamesKt;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.container.DslKt;
import org.jetbrains.kotlin.container.StorageComponentContainer;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.Modality;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.extensions.StorageComponentContainerContributor;
import org.jetbrains.kotlin.idea.MainFunctionDetector;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00102\u0006\u0010\b\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00142\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u0015\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016\u00a8\u0006!"}, d2={"Landroidx/compose/compiler/plugins/kotlin/ComposableDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "Lorg/jetbrains/kotlin/extensions/StorageComponentContainerContributor;", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkFunction", "Lorg/jetbrains/kotlin/psi/KtFunction;", "Lorg/jetbrains/kotlin/descriptors/FunctionDescriptor;", "checkProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lorg/jetbrains/kotlin/descriptors/PropertyDescriptor;", "checkPropertyAccessor", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "Lorg/jetbrains/kotlin/descriptors/PropertyAccessorDescriptor;", "checkType", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "element", "Lcom/intellij/psi/PsiElement;", "registerModuleComponents", "container", "Lorg/jetbrains/kotlin/container/StorageComponentContainer;", "platform", "Lorg/jetbrains/kotlin/platform/TargetPlatform;", "moduleDescriptor", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "compiler-hosted"})
@SourceDebugExtension(value={"SMAP\nComposableDeclarationChecker.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposableDeclarationChecker.kt\nandroidx/compose/compiler/plugins/kotlin/ComposableDeclarationChecker\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,225:1\n1851#2,2:226\n1851#2,2:228\n*S KotlinDebug\n*F\n+ 1 ComposableDeclarationChecker.kt\nandroidx/compose/compiler/plugins/kotlin/ComposableDeclarationChecker\n*L\n94#1:226,2\n116#1:228,2\n*E\n"})
public final class ComposableDeclarationChecker
implements DeclarationChecker,
StorageComponentContainerContributor {
    public void registerModuleComponents(@NotNull StorageComponentContainer container, @NotNull TargetPlatform platform, @NotNull ModuleDescriptor moduleDescriptor) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        Intrinsics.checkNotNullParameter((Object)platform, (String)"platform");
        Intrinsics.checkNotNullParameter((Object)moduleDescriptor, (String)"moduleDescriptor");
        DslKt.useInstance((StorageComponentContainer)container, (Object)this);
    }

    public void check(@NotNull KtDeclaration declaration, @NotNull DeclarationDescriptor descriptor, @NotNull DeclarationCheckerContext context) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (declaration instanceof KtProperty && descriptor instanceof PropertyDescriptor) {
            this.checkProperty((KtProperty)declaration, (PropertyDescriptor)descriptor, context);
        } else if (declaration instanceof KtPropertyAccessor && descriptor instanceof PropertyAccessorDescriptor) {
            this.checkPropertyAccessor((KtPropertyAccessor)declaration, (PropertyAccessorDescriptor)descriptor, context);
        } else if (declaration instanceof KtFunction && descriptor instanceof FunctionDescriptor) {
            this.checkFunction((KtFunction)declaration, (FunctionDescriptor)descriptor, context);
        }
    }

    private final void checkFunction(KtFunction declaration, FunctionDescriptor descriptor, DeclarationCheckerContext context) {
        boolean hasComposableAnnotation = ComposeFqNamesKt.hasComposableAnnotation((Annotated)descriptor);
        Collection collection = descriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"descriptor.overriddenDescriptors");
        if (!collection.isEmpty()) {
            Collection collection2 = descriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"descriptor.overriddenDescriptors");
            FunctionDescriptor override = (FunctionDescriptor)CollectionsKt.first((Iterable)collection2);
            Intrinsics.checkNotNullExpressionValue((Object)override, (String)"override");
            if (ComposeFqNamesKt.hasComposableAnnotation((Annotated)override) != hasComposableAnnotation) {
                Object[] objectArray = new FunctionDescriptor[]{descriptor, override};
                context.getTrace().report((Diagnostic)ComposeErrors.CONFLICTING_OVERLOADS.on((PsiElement)declaration, (Object)CollectionsKt.listOf((Object[])objectArray)));
            } else if (!ComposableTargetCheckerKt.toScheme((CallableDescriptor)descriptor, null).canOverride(ComposableTargetCheckerKt.toScheme((CallableDescriptor)override, null))) {
                context.getTrace().report((Diagnostic)ComposeErrors.COMPOSE_APPLIER_DECLARATION_MISMATCH.on((PsiElement)declaration));
            }
            List list = descriptor.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.valueParameters");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ValueParameterDescriptor valueParameter = (ValueParameterDescriptor)element$iv;
                boolean bl = false;
                if ((ValueParameterDescriptor)CollectionsKt.firstOrNull((Iterable)valueParameter.getOverriddenDescriptors()) != null) {
                    ValueParameterDescriptor overriddenParam;
                    boolean bl2 = false;
                    KotlinType kotlinType = overriddenParam.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"overriddenParam.type");
                    boolean overrideIsComposable = ComposeFqNamesKt.hasComposableAnnotation(kotlinType);
                    KotlinType kotlinType2 = valueParameter.getType();
                    Intrinsics.checkNotNullExpressionValue((Object)kotlinType2, (String)"valueParameter.type");
                    boolean paramIsComposable = ComposeFqNamesKt.hasComposableAnnotation(kotlinType2);
                    if (paramIsComposable == overrideIsComposable) continue;
                    Object[] objectArray = new ValueParameterDescriptor[]{valueParameter, overriddenParam};
                    context.getTrace().report((Diagnostic)ComposeErrors.CONFLICTING_OVERLOADS.on((PsiElement)declaration, (Object)CollectionsKt.listOf((Object[])objectArray)));
                }
            }
        }
        if (descriptor.isSuspend() && hasComposableAnnotation) {
            BindingTrace bindingTrace = context.getTrace();
            PsiElement psiElement = declaration.getNameIdentifier();
            if (psiElement == null) {
                psiElement = (PsiElement)declaration;
            }
            bindingTrace.report((Diagnostic)ComposeErrors.COMPOSABLE_SUSPEND_FUN.on(psiElement));
        }
        if (hasComposableAnnotation && descriptor.getModality() == Modality.ABSTRACT) {
            List list = declaration.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"declaration.valueParameters");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                KtParameter it = (KtParameter)element$iv;
                boolean bl = false;
                KtExpression defaultValue = it.getDefaultValue();
                if (defaultValue == null) continue;
                context.getTrace().report((Diagnostic)ComposeErrors.ABSTRACT_COMPOSABLE_DEFAULT_PARAMETER_VALUE.on((PsiElement)defaultValue));
            }
        }
        List list = descriptor.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"descriptor.valueParameters");
        List params = list;
        List list2 = declaration.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"declaration.valueParameters");
        List ktparams = list2;
        if (params.size() == ktparams.size()) {
            for (Object object : CollectionsKt.zip((Iterable)params, (Iterable)ktparams)) {
                ValueParameterDescriptor param = (ValueParameterDescriptor)object.component1();
                KtParameter ktparam = (KtParameter)object.component2();
                KtTypeReference typeRef = ktparam.getTypeReference();
                if (typeRef == null) continue;
                KotlinType kotlinType = param.getType();
                Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"param.type");
                this.checkType(kotlinType, (PsiElement)typeRef, context);
            }
        }
        if (hasComposableAnnotation && Intrinsics.areEqual((Object)descriptor.getName().asString(), (Object)"main")) {
            BindingContext bindingContext = context.getTrace().getBindingContext();
            Intrinsics.checkNotNullExpressionValue((Object)bindingContext, (String)"context.trace.bindingContext");
            if (MainFunctionDetector.isMain$default((MainFunctionDetector)new MainFunctionDetector(bindingContext, context.getLanguageVersionSettings()), (DeclarationDescriptor)((DeclarationDescriptor)descriptor), (boolean)false, (boolean)false, (boolean)false, (int)14, null)) {
                BindingTrace bindingTrace = context.getTrace();
                PsiElement psiElement = declaration.getNameIdentifier();
                if (psiElement == null) {
                    psiElement = (PsiElement)declaration;
                }
                bindingTrace.report((Diagnostic)ComposeErrors.COMPOSABLE_FUN_MAIN.on(psiElement));
            }
        }
    }

    private final void checkType(KotlinType type, PsiElement element, DeclarationCheckerContext context) {
        if (ComposeFqNamesKt.hasComposableAnnotation(type) && FunctionTypesKt.isSuspendFunctionType((KotlinType)type)) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_SUSPEND_FUN.on(element));
        }
    }

    /*
     * Unable to fully structure code
     */
    private final void checkProperty(KtProperty declaration, PropertyDescriptor descriptor, DeclarationCheckerContext context) {
        block6: {
            var5_4 = descriptor.getGetter();
            hasComposableAnnotation = var5_4 != null ? ComposeFqNamesKt.hasComposableAnnotation((Annotated)var5_4) : false;
            v0 = descriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"descriptor.overriddenDescriptors");
            if (!(v0.isEmpty() == false)) break block6;
            v1 = descriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"descriptor.overriddenDescriptors");
            override = (PropertyDescriptor)CollectionsKt.first((Iterable)v1);
            Intrinsics.checkNotNullExpressionValue((Object)override, (String)"override");
            if (ComposeFqNamesKt.hasComposableAnnotation((Annotated)override)) ** GOTO lbl-1000
            v2 = override.getGetter();
            v3 = v2 != null ? ComposeFqNamesKt.hasComposableAnnotation((Annotated)v2) : false;
            if (v3) lbl-1000:
            // 2 sources

            {
                v4 = true;
            } else {
                v4 = overrideIsComposable = false;
            }
            if (overrideIsComposable != hasComposableAnnotation) {
                var7_8 = new PropertyDescriptor[]{descriptor, override};
                context.getTrace().report((Diagnostic)ComposeErrors.CONFLICTING_OVERLOADS.on((PsiElement)declaration, (Object)CollectionsKt.listOf((Object[])var7_8)));
            }
        }
        if (!hasComposableAnnotation) {
            return;
        }
        initializer = declaration.getInitializer();
        name = declaration.getNameIdentifier();
        if (initializer != null && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_PROPERTY_BACKING_FIELD.on(name));
        }
        if (descriptor.isVar() && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_VAR.on(name));
        }
    }

    private final void checkPropertyAccessor(KtPropertyAccessor declaration, PropertyAccessorDescriptor descriptor, DeclarationCheckerContext context) {
        PropertyDescriptor propertyDescriptor = descriptor.getCorrespondingProperty();
        Intrinsics.checkNotNullExpressionValue((Object)propertyDescriptor, (String)"descriptor.correspondingProperty");
        PropertyDescriptor propertyDescriptor2 = propertyDescriptor;
        PsiElement psiElement = declaration.getParent();
        KtProperty ktProperty = psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
        if (ktProperty == null) {
            return;
        }
        KtProperty propertyPsi = ktProperty;
        PsiElement name = propertyPsi.getNameIdentifier();
        KtExpression initializer = propertyPsi.getInitializer();
        boolean hasComposableAnnotation = ComposeFqNamesKt.hasComposableAnnotation((Annotated)descriptor);
        Collection collection = descriptor.getOverriddenDescriptors();
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"descriptor.overriddenDescriptors");
        if (!collection.isEmpty()) {
            Collection collection2 = descriptor.getOverriddenDescriptors();
            Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"descriptor.overriddenDescriptors");
            PropertyAccessorDescriptor override = (PropertyAccessorDescriptor)CollectionsKt.first((Iterable)collection2);
            Intrinsics.checkNotNullExpressionValue((Object)override, (String)"override");
            boolean overrideComposable = ComposeFqNamesKt.hasComposableAnnotation((Annotated)override);
            if (overrideComposable != hasComposableAnnotation) {
                Object[] objectArray = new PropertyAccessorDescriptor[]{descriptor, override};
                context.getTrace().report((Diagnostic)ComposeErrors.CONFLICTING_OVERLOADS.on((PsiElement)declaration, (Object)CollectionsKt.listOf((Object[])objectArray)));
            }
        }
        if (!hasComposableAnnotation) {
            return;
        }
        if (initializer != null && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_PROPERTY_BACKING_FIELD.on(name));
        }
        if (propertyDescriptor2.isVar() && name != null) {
            context.getTrace().report((Diagnostic)ComposeErrors.COMPOSABLE_VAR.on(name));
        }
    }
}

