/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.other.automotiveMediaService.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"musicServiceJava", "", "mediaBrowserServiceName", "sharedPackageName", "useAndroidX", "", "intellij.android.wizardTemplate.impl"})
public final class MusicServiceJavaKt {
    @NotNull
    public static final String musicServiceJava(@NotNull String mediaBrowserServiceName, @NotNull String sharedPackageName, boolean useAndroidX) {
        Intrinsics.checkNotNullParameter((Object)mediaBrowserServiceName, (String)"mediaBrowserServiceName");
        Intrinsics.checkNotNullParameter((Object)sharedPackageName, (String)"sharedPackageName");
        return "\npackage " + sharedPackageName + ";\n\nimport android.os.Bundle;\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.annotation.NonNull", useAndroidX) + ";\nimport android.support.v4.media.MediaBrowserCompat.MediaItem;\nimport " + TemplateHelpersKt.getMaterialComponentName("android.support.v4.media.MediaBrowserServiceCompat", useAndroidX) + ";\nimport android.support.v4.media.session.MediaSessionCompat;\n\nimport java.util.ArrayList;\nimport java.util.List;\n\n/**\n * This class provides a MediaBrowser through a service. It exposes the media library to a browsing\n * client, through the onGetRoot and onLoadChildren methods. It also creates a MediaSession and\n * exposes it through its MediaSession.Token, which allows the client to create a MediaController\n * that connects to and send control commands to the MediaSession remotely. This is useful for\n * user interfaces that need to interact with your media session, like Android Auto. You can\n * (should) also use the same service from your app's UI, which gives a seamless playback\n * experience to the user.\n *\n * To implement a MediaBrowserService, you need to:\n *\n * <ul>\n *\n * <li> Extend {@link MediaBrowserServiceCompat}, implementing the media browsing\n *      related methods {@link MediaBrowserServiceCompat#onGetRoot} and\n *      {@link MediaBrowserServiceCompat#onLoadChildren};\n * <li> In onCreate, start a new {@link MediaSessionCompat} and notify its parent\n *      with the session\"s token {@link MediaBrowserServiceCompat#setSessionToken};\n *\n * <li> Set a callback on the {@link MediaSessionCompat#setCallback(MediaSessionCompat.Callback)}.\n *      The callback will receive all the user\"s actions, like play, pause, etc;\n *\n * <li> Handle all the actual music playing using any method your app prefers (for example,\n *      {@link android.media.MediaPlayer})\n *\n * <li> Update playbackState, \"now playing\" metadata and queue, using MediaSession proper methods\n *      {@link MediaSessionCompat#setPlaybackState(android.support.v4.media.session.PlaybackStateCompat)}\n *      {@link MediaSessionCompat#setMetadata(android.support.v4.media.MediaMetadataCompat)} and\n *      {@link MediaSessionCompat#setQueue(java.util.List)})\n *\n * <li> Declare and export the service in AndroidManifest with an intent receiver for the action\n *      android.media.browse.MediaBrowserService\n *\n * </ul>\n *\n * To make your app compatible with Android Auto, you also need to:\n *\n * <ul>\n *\n * <li> Declare a meta-data tag in AndroidManifest.xml linking to a xml resource\n *      with a &lt;automotiveApp&gt; root element. For a media app, this must include\n *      an &lt;uses name=\"media\"/&gt; element as a child.\n *      For example, in AndroidManifest.xml:\n *          &lt;meta-data android:name=\"com.google.android.gms.car.application\"\n *              android:resource=\"@xml/automotive_app_desc\"/&gt;\n *      And in res/values/automotive_app_desc.xml:\n *          &lt;automotiveApp&gt;\n *              &lt;uses name=\"media\"/&gt;\n *          &lt;/automotiveApp&gt;\n *\n * </ul>\n *\n */\npublic class " + mediaBrowserServiceName + " extends MediaBrowserServiceCompat {\n\n    private MediaSessionCompat mSession;\n\n    @Override\n    public void onCreate() {\n        super.onCreate();\n\n        mSession = new MediaSessionCompat(this, \"" + mediaBrowserServiceName + "\");\n        setSessionToken(mSession.getSessionToken());\n        mSession.setCallback(new MediaSessionCallback());\n        mSession.setFlags(MediaSessionCompat.FLAG_HANDLES_MEDIA_BUTTONS |\n                MediaSessionCompat.FLAG_HANDLES_TRANSPORT_CONTROLS);\n    }\n\n    @Override\n    public void onDestroy() {\n        mSession.release();\n    }\n\n    @Override\n    public BrowserRoot onGetRoot(@NonNull String clientPackageName,\n                                 int clientUid,\n                                 Bundle rootHints) {\n        return new BrowserRoot(\"root\", null);\n    }\n\n    @Override\n    public void onLoadChildren(@NonNull final String parentMediaId,\n                               @NonNull final Result<List<MediaItem>> result) {\n        result.sendResult(new ArrayList<MediaItem>());\n    }\n\n    private final class MediaSessionCallback extends MediaSessionCompat.Callback {\n        @Override\n        public void onPlay() {\n        }\n\n        @Override\n        public void onSkipToQueueItem(long queueId) {\n        }\n\n        @Override\n        public void onSeekTo(long position) {\n        }\n\n        @Override\n        public void onPlayFromMediaId(String mediaId, Bundle extras) {\n        }\n\n        @Override\n        public void onPause() {\n        }\n\n        @Override\n        public void onStop() {\n        }\n\n        @Override\n        public void onSkipToNext() {\n        }\n\n        @Override\n        public void onSkipToPrevious() {\n        }\n\n        @Override\n        public void onCustomAction(String action, Bundle extras) {\n        }\n\n        @Override\n        public void onPlayFromSearch(final String query, final Bundle extras) {\n        }\n    }\n}\n";
    }
}

