/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googleWalletActivity.app_package;

import com.android.tools.idea.wizard.template.Language;
import com.android.tools.idea.wizard.template.impl.activities.common.ViewBindingUtilsKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\u001a0\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u00012\b\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"walletActivityJava", "", "activityClass", "layoutName", "packageName", "applicationPackage", "isViewBindingSupported", "", "intellij.android.wizardTemplate.impl"})
@SourceDebugExtension(value={"SMAP\nwalletActivityJava.kt\nKotlin\n*S Kotlin\n*F\n+ 1 walletActivityJava.kt\ncom/android/tools/idea/wizard/template/impl/activities/googleWalletActivity/app_package/WalletActivityJavaKt\n+ 2 helpers.kt\ncom/android/tools/idea/wizard/template/HelpersKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,216:1\n42#2,5:217\n1#3:222\n*S KotlinDebug\n*F\n+ 1 walletActivityJava.kt\ncom/android/tools/idea/wizard/template/impl/activities/googleWalletActivity/app_package/WalletActivityJavaKt\n*L\n86#1:217,5\n86#1:222\n*E\n"})
public final class WalletActivityJavaKt {
    @NotNull
    public static final String walletActivityJava(@NotNull String activityClass2, @NotNull String layoutName2, @NotNull String packageName, @Nullable String applicationPackage, boolean isViewBindingSupported) {
        String string;
        Intrinsics.checkNotNullParameter((Object)activityClass2, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)layoutName2, (String)"layoutName");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        String contentViewBlock = isViewBindingSupported ? "layout = " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + ".inflate(getLayoutInflater());\n     setContentView(layout.getRoot());\n  " : "setContentView(R.layout." + layoutName2 + ");";
        String addToWalletButtonBlock = isViewBindingSupported ? "addToWalletButton = layout.addToGoogleWalletButton.getRoot();" : "addToWalletButton = findViewById(R.id.addToGoogleWalletButton);";
        String string2 = packageName;
        String string3 = ViewBindingUtilsKt.importViewBindingClass(isViewBindingSupported, packageName, applicationPackage, layoutName2, Language.Java);
        String string4 = activityClass2;
        boolean trim$iv = true;
        boolean skipLine$iv = true;
        boolean $i$f$renderIf = false;
        if (isViewBindingSupported) {
            String string5 = string4;
            String string6 = string3;
            String string7 = string2;
            boolean bl = false;
            String string8 = "\n    /**\n     * The view binding associated with this Activity's layout.\n     */\n    private " + ViewBindingUtilsKt.layoutToViewBindingClass(layoutName2) + " layout;\n";
            string2 = string7;
            string3 = string6;
            string4 = string5;
            string = ((Object)StringsKt.trim((CharSequence)string8)).toString();
        } else {
            String string9;
            String it$iv = string9 = "[THIS LINE SHOULD NOT BE RENDERED!]";
            boolean bl = false;
            string = string9;
            if (string == null) {
                string = "";
            }
        }
        return "\npackage " + string2 + ";\n\nimport androidx.annotation.Nullable;\nimport androidx.appcompat.app.AppCompatActivity;\n\nimport android.app.Activity;\nimport android.content.Intent;\nimport android.os.Bundle;\nimport android.view.View;\nimport android.widget.Toast;\n\nimport com.google.android.gms.pay.Pay;\nimport com.google.android.gms.pay.PayApiAvailabilityStatus;\nimport com.google.android.gms.pay.PayClient;\n\nimport java.util.UUID;\n\n" + string3 + "\n\n/**\n * An Activity that allows the user to add a pass to the user's Google Wallet using the\n * Google Wallet Android SDK.\n *\n * If you are testing out the new Wallet functionality, you will need to create a\n * <a href=\"https://wallet-lab-tools.web.app/issuers\">Temporary Issuer Account</a> prior to running\n * this example. If you are using the temporary issuer account, you must enter the TODO fields\n * in the {@link WalletActivity#onAddToWalletClicked()} function.\n *\n * If you are using this template to create a custom pass, you will need to sign into the Google Pay\n * Business Console, Create a New Pass, and Alter the JSON in the validator to ensure the pass looks\n * and behaves as preferred. For further instruction, please follow\n * <a href=\"https://developers.google.com/wallet/generic/android/prerequisites\">the provided documentation</a>\n *\n * @see Pay#getClient(Activity)\n * @see PayClient#savePasses(String, Activity, int)\n * @see SamplePass\n */\npublic class " + string4 + " extends AppCompatActivity {\n\n    /**\n     * The request code we pass along to the Google Wallet API when attempting to add a pass.\n     */\n    private static final int ADD_TO_WALLET_REQUEST_CODE = 1000;\n\n" + string + "\n\n    /**\n     * The {@link PayClient} which we use to interact with the Google Wallet API.\n     *\n     * @see Pay#getClient(Activity)\n     */\n    private PayClient walletClient;\n\n    /**\n     * The button the user clicks on to add to wallet.\n     */\n    private View addToWalletButton;\n\n    @Override\n    protected void onCreate(Bundle savedInstanceState) {\n        super.onCreate(savedInstanceState);\n\n        walletClient = Pay.getClient(this);\n\n        " + contentViewBlock + "\n\n        " + addToWalletButtonBlock + "\n        addToWalletButton.setOnClickListener(view -> onAddToWalletClicked());\n\n        fetchCanUseGoogleWalletApi();\n    }\n    /**\n     * Adds the {@link SamplePass} to the user's Google Wallet.\n     *\n     * You can also alter this to allow for use of saving passes using a JWT by switching the method\n     * to {@link PayClient#savePassesJwt(String, Activity, int)}. In this case, you will no longer\n     * require the use of {@link SamplePass}.\n     *\n     * @see PayClient#savePasses(String, Activity, int)\n     */\n    private void onAddToWalletClicked() {\n        final SamplePass samplePass = new SamplePass(\n                \"\",  // TODO(you) \u2013 Enter issuer email address\n                \"\",    // TODO(you) \u2013 Enter issuer id\n                \"\",  // TODO(you) \u2013 Enter pass class\n                UUID.randomUUID().toString()\n        );\n\n        walletClient.savePasses(\n                samplePass.toJson(),\n                this,\n                ADD_TO_WALLET_REQUEST_CODE\n        );\n    }\n\n    /**\n     * A helper method that allows us to check if the Google Wallet API is available on the current\n     * device.\n     *\n     * Please note, some countries do not have Google Wallet available to them yet.\n     */\n    private void fetchCanUseGoogleWalletApi() {\n        walletClient\n                .getPayApiAvailabilityStatus(PayClient.RequestType.SAVE_PASSES)\n                .addOnSuccessListener(result -> {\n                    // Display the \"Add to Wallet\" button if the wallet API is available on this device.\n                    if (result == PayApiAvailabilityStatus.AVAILABLE) {\n                        addToWalletButton.setVisibility(View.VISIBLE);\n                    } else {\n                        addToWalletButton.setVisibility(View.GONE);\n                    }\n                })\n                .addOnFailureListener(exception -> {\n                    // Hide the button and optionally show an error message\n                    addToWalletButton.setVisibility(View.GONE);\n\n                    Toast.makeText(\n                            this,\n                            R.string.google_wallet_status_unavailable,\n                            Toast.LENGTH_SHORT\n                    ).show();\n                });\n    }\n\n    /**\n     * Handle the result from {@link PayClient#savePasses(String, Activity, int)}, where we check to\n     * see if our attempt to add the pass to the user's Google Wallet was successful, or not.\n     *\n     * It is up to the implementer to appropriately handle error cases.\n     */\n    @Override\n    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {\n        super.onActivityResult(requestCode, resultCode, data);\n\n        if (requestCode == ADD_TO_WALLET_REQUEST_CODE) {\n            if (resultCode == RESULT_OK) {\n                Toast.makeText(\n                        this,\n                        R.string.add_google_wallet_success,\n                        Toast.LENGTH_SHORT\n                ).show();\n            } else if (resultCode == RESULT_CANCELED) {\n                Toast.makeText(\n                        this,\n                        R.string.add_google_wallet_cancelled,\n                        Toast.LENGTH_SHORT\n                ).show();\n            } else if (resultCode == PayClient.SavePassesResult.SAVE_ERROR) {\n                // Handle the error message and optionally display it to the user.\n                final String errorMessage = data.getStringExtra(PayClient.EXTRA_API_ERROR_MESSAGE);\n                Toast.makeText(\n                        this,\n                        errorMessage != null\n                                ? errorMessage\n                                : getString(R.string.add_google_wallet_unknown_error),\n                        Toast.LENGTH_SHORT\n                ).show();\n            } else {\n                Toast.makeText(\n                        this,\n                        R.string.add_google_wallet_unknown_error,\n                        Toast.LENGTH_SHORT\n                ).show();\n            }\n        }\n    }\n}\n";
    }
}

