/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"paymentsUtilKotlin", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class PaymentsUtilKtKt {
    @NotNull
    public static final String paymentsUtilKotlin(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + packageName + ".util\n\nimport android.content.Context\nimport com.google.android.gms.wallet.PaymentsClient\nimport com.google.android.gms.wallet.Wallet\nimport org.json.JSONArray\nimport org.json.JSONException\nimport org.json.JSONObject\nimport java.math.BigDecimal\nimport java.math.RoundingMode\n\nimport " + packageName + ".Constants\n\n/**\n * Contains helper static methods for dealing with the Payments API.\n *\n * Many of the parameters used in the code are optional and are set here merely to call out their\n * existence. Please consult the documentation to learn more and feel free to remove ones not\n * relevant to your implementation.\n */\nobject PaymentsUtil {\n    val CENTS = BigDecimal(100)\n\n    /**\n     * Create a Google Pay API base request object with properties used in all requests.\n     *\n     * @return Google Pay API base request object.\n     * @throws JSONException\n     */\n    private val baseRequest = JSONObject().apply {\n        put(\"apiVersion\", 2)\n        put(\"apiVersionMinor\", 0)\n    }\n\n    /**\n     * Gateway Integration: Identify your gateway and your app's gateway merchant identifier.\n     *\n     *\n     * The Google Pay API response will return an encrypted payment method capable of being charged\n     * by a supported gateway after payer authorization.\n     *\n     *\n     * TODO: Check with your gateway on the parameters to pass and modify them in Constants.java.\n     *\n     * @return Payment data tokenization for the CARD payment method.\n     * @throws JSONException\n     * See [PaymentMethodTokenizationSpecification](https://developers.google.com/pay/api/android/reference/object.PaymentMethodTokenizationSpecification)\n     */\n    private fun gatewayTokenizationSpecification(): JSONObject {\n        return JSONObject().apply {\n            put(\"type\", \"PAYMENT_GATEWAY\")\n            put(\"parameters\", JSONObject(Constants.PAYMENT_GATEWAY_TOKENIZATION_PARAMETERS))\n        }\n    }\n\n    /**\n     * Card networks supported by your app and your gateway.\n     *\n     *\n     * TODO: Confirm card networks supported by your app and gateway & update in Constants.java.\n     *\n     * @return Allowed card networks\n     * See [CardParameters](https://developers.google.com/pay/api/android/reference/object.CardParameters)\n     */\n    private val allowedCardNetworks = JSONArray(Constants.SUPPORTED_NETWORKS)\n\n    /**\n     * Card authentication methods supported by your app and your gateway.\n     *\n     *\n     * TODO: Confirm your processor supports Android device tokens on your supported card networks\n     * and make updates in Constants.java.\n     *\n     * @return Allowed card authentication methods.\n     * See [CardParameters](https://developers.google.com/pay/api/android/reference/object.CardParameters)\n     */\n    private val allowedCardAuthMethods = JSONArray(Constants.SUPPORTED_METHODS)\n\n    /**\n     * Describe your app's support for the CARD payment method.\n     *\n     *\n     * The provided properties are applicable to both an IsReadyToPayRequest and a\n     * PaymentDataRequest.\n     *\n     * @return A CARD PaymentMethod object describing accepted cards.\n     * @throws JSONException\n     * See [PaymentMethod](https://developers.google.com/pay/api/android/reference/object.PaymentMethod)\n     */\n    // Optionally, you can add billing address/phone number associated with a CARD payment method.\n    private fun baseCardPaymentMethod(): JSONObject {\n        return JSONObject().apply {\n\n            val parameters = JSONObject().apply {\n                put(\"allowedAuthMethods\", allowedCardAuthMethods)\n                put(\"allowedCardNetworks\", allowedCardNetworks)\n                put(\"billingAddressRequired\", true)\n                put(\"billingAddressParameters\", JSONObject().apply {\n                    put(\"format\", \"FULL\")\n                })\n            }\n\n            put(\"type\", \"CARD\")\n            put(\"parameters\", parameters)\n        }\n    }\n\n    /**\n     * Describe the expected returned payment data for the CARD payment method\n     *\n     * @return A CARD PaymentMethod describing accepted cards and optional fields.\n     * @throws JSONException\n     * See [PaymentMethod](https://developers.google.com/pay/api/android/reference/object.PaymentMethod)\n     */\n    private fun cardPaymentMethod(): JSONObject {\n        val cardPaymentMethod = baseCardPaymentMethod()\n        cardPaymentMethod.put(\"tokenizationSpecification\", gatewayTokenizationSpecification())\n\n        return cardPaymentMethod\n    }\n\n    /**\n     * An object describing accepted forms of payment by your app, used to determine a viewer's\n     * readiness to pay.\n     *\n     * @return API version and payment methods supported by the app.\n     * See [IsReadyToPayRequest](https://developers.google.com/pay/api/android/reference/object.IsReadyToPayRequest)\n     */\n    fun isReadyToPayRequest(): JSONObject? {\n        return try {\n            baseRequest.apply {\n                put(\"allowedPaymentMethods\", JSONArray().put(baseCardPaymentMethod()))\n            }\n\n        } catch (e: JSONException) {\n            null\n        }\n    }\n\n    /**\n     * Information about the merchant requesting payment information\n     *\n     * @return Information about the merchant.\n     * @throws JSONException\n     * See [MerchantInfo](https://developers.google.com/pay/api/android/reference/object.MerchantInfo)\n     */\n    private val merchantInfo: JSONObject =\n            JSONObject().put(\"merchantName\", \"Example Merchant\")\n\n    /**\n     * Creates an instance of [PaymentsClient] for use in an [Context] using the\n     * environment and theme set in [Constants].\n     *\n     * @param context is the caller context.\n     */\n    fun createPaymentsClient(context: Context): PaymentsClient {\n        val walletOptions = Wallet.WalletOptions.Builder()\n                .setEnvironment(Constants.PAYMENTS_ENVIRONMENT)\n                .build()\n\n        return Wallet.getPaymentsClient(context, walletOptions)\n    }\n\n    /**\n     * Provide Google Pay API with a payment amount, currency, and amount status.\n     *\n     * @return information about the requested payment.\n     * @throws JSONException\n     * See [TransactionInfo](https://developers.google.com/pay/api/android/reference/object.TransactionInfo)\n     */\n    @Throws(JSONException::class)\n    private fun getTransactionInfo(price: String): JSONObject {\n        return JSONObject().apply {\n            put(\"totalPrice\", price)\n            put(\"totalPriceStatus\", \"FINAL\")\n            put(\"countryCode\", Constants.COUNTRY_CODE)\n            put(\"currencyCode\", Constants.CURRENCY_CODE)\n        }\n    }\n\n    /**\n     * An object describing information requested in a Google Pay payment sheet\n     *\n     * @return Payment data expected by your app.\n     * See [PaymentDataRequest](https://developers.google.com/pay/api/android/reference/object.PaymentDataRequest)\n     */\n    fun getPaymentDataRequest(priceCemts: Long): JSONObject {\n        return baseRequest.apply {\n            put(\"allowedPaymentMethods\", JSONArray().put(cardPaymentMethod()))\n            put(\"transactionInfo\", getTransactionInfo(priceCemts.centsToString()))\n            put(\"merchantInfo\", merchantInfo)\n\n            // An optional shipping address requirement is a top-level property of the\n            // PaymentDataRequest JSON object.\n            val shippingAddressParameters = JSONObject().apply {\n                put(\"phoneNumberRequired\", false)\n                put(\"allowedCountryCodes\", JSONArray(listOf(\"US\", \"GB\")))\n            }\n            put(\"shippingAddressParameters\", shippingAddressParameters)\n            put(\"shippingAddressRequired\", true)\n        }\n    }\n}\n\n/**\n * Converts cents to a string format accepted by [PaymentsUtil.getPaymentDataRequest].\n */\nfun Long.centsToString() = BigDecimal(this)\n        .divide(PaymentsUtil.CENTS)\n        .setScale(2, RoundingMode.HALF_EVEN)\n        .toString()\n";
    }
}

