/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.googlePayActivity.app_package;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"paymentsUtilJava", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class PaymentsUtilJavaKt {
    @NotNull
    public static final String paymentsUtilJava(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + packageName + ".util;\n\nimport android.content.Context;\n\nimport com.google.android.gms.wallet.PaymentsClient;\nimport com.google.android.gms.wallet.Wallet;\n\nimport java.math.BigDecimal;\nimport java.math.RoundingMode;\n\nimport org.json.JSONArray;\nimport org.json.JSONException;\nimport org.json.JSONObject;\n\nimport " + packageName + ".Constants;\n\n/**\n * Contains helper static methods for dealing with the Payments API.\n *\n * <p>Many of the parameters used in the code are optional and are set here merely to call out their\n * existence. Please consult the documentation to learn more and feel free to remove ones not\n * relevant to your implementation.\n */\npublic class PaymentsUtil {\n\n  public static final BigDecimal CENTS_IN_A_UNIT = new BigDecimal(100);\n\n  /**\n   * Create a Google Pay API base request object with properties used in all requests.\n   *\n   * @return Google Pay API base request object.\n   * @throws JSONException if the object is malformed.\n   */\n  private static JSONObject getBaseRequest() throws JSONException {\n    return new JSONObject().put(\"apiVersion\", 2).put(\"apiVersionMinor\", 0);\n  }\n\n  /**\n   * Creates an instance of {@link PaymentsClient} for use in an {@link Context} using the\n   * environment and theme set in {@link Constants}.\n   *\n   * @param context is the caller's context.\n   */\n  public static PaymentsClient createPaymentsClient(Context context) {\n    Wallet.WalletOptions walletOptions =\n        new Wallet.WalletOptions.Builder().setEnvironment(Constants.PAYMENTS_ENVIRONMENT).build();\n    return Wallet.getPaymentsClient(context, walletOptions);\n  }\n\n  /**\n   * Gateway Integration: Identify your gateway and your app's gateway merchant identifier.\n   *\n   * <p>The Google Pay API response will return an encrypted payment method capable of being charged\n   * by a supported gateway after payer authorization.\n   *\n   * <p>TODO: Check with your gateway on the parameters to pass and modify them in Constants.java.\n   *\n   * @return Payment data tokenization for the CARD payment method.\n   * @throws JSONException if the object is malformed.\n   * @see <a href=\n   * \"https://developers.google.com/pay/api/android/reference/object#PaymentMethodTokenizationSpecification\">PaymentMethodTokenizationSpecification</a>\n   */\n  private static JSONObject getGatewayTokenizationSpecification() throws JSONException {\n    return new JSONObject() {{\n      put(\"type\", \"PAYMENT_GATEWAY\");\n      put(\"parameters\", new JSONObject() {{\n        put(\"gateway\", \"example\");\n        put(\"gatewayMerchantId\", \"exampleGatewayMerchantId\");\n      }});\n    }};\n  }\n\n  /**\n   * {@code DIRECT} Integration: Decrypt a response directly on your servers. This configuration has\n   * additional data security requirements from Google and additional PCI DSS compliance complexity.\n   *\n   * <p>Please refer to the documentation for more information about {@code DIRECT} integration. The\n   * type of integration you use depends on your payment processor.\n   *\n   * @return Payment data tokenization for the CARD payment method.\n   * @throws JSONException if the object is malformed.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#PaymentMethodTokenizationSpecification\">PaymentMethodTokenizationSpecification</a>\n   */\n  private static JSONObject getDirectTokenizationSpecification()\n      throws JSONException, RuntimeException {\n    JSONObject tokenizationSpecification = new JSONObject();\n\n    tokenizationSpecification.put(\"type\", \"DIRECT\");\n    JSONObject parameters = new JSONObject(Constants.DIRECT_TOKENIZATION_PARAMETERS);\n    tokenizationSpecification.put(\"parameters\", parameters);\n\n    return tokenizationSpecification;\n  }\n\n  /**\n   * Card networks supported by your app and your gateway.\n   *\n   * <p>TODO: Confirm card networks supported by your app and gateway & update in Constants.java.\n   *\n   * @return Allowed card networks\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#CardParameters\">CardParameters</a>\n   */\n  private static JSONArray getAllowedCardNetworks() {\n    return new JSONArray(Constants.SUPPORTED_NETWORKS);\n  }\n\n  /**\n   * Card authentication methods supported by your app and your gateway.\n   *\n   * <p>TODO: Confirm your processor supports Android device tokens on your supported card networks\n   * and make updates in Constants.java.\n   *\n   * @return Allowed card authentication methods.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#CardParameters\">CardParameters</a>\n   */\n  private static JSONArray getAllowedCardAuthMethods() {\n    return new JSONArray(Constants.SUPPORTED_METHODS);\n  }\n\n  /**\n   * Describe your app's support for the CARD payment method.\n   *\n   * <p>The provided properties are applicable to both an IsReadyToPayRequest and a\n   * PaymentDataRequest.\n   *\n   * @return A CARD PaymentMethod object describing accepted cards.\n   * @throws JSONException if the object is malformed.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#PaymentMethod\">PaymentMethod</a>\n   */\n  private static JSONObject getBaseCardPaymentMethod() throws JSONException {\n    JSONObject cardPaymentMethod = new JSONObject();\n    cardPaymentMethod.put(\"type\", \"CARD\");\n\n    JSONObject parameters = new JSONObject();\n    parameters.put(\"allowedAuthMethods\", getAllowedCardAuthMethods());\n    parameters.put(\"allowedCardNetworks\", getAllowedCardNetworks());\n    // Optionally, you can add billing address/phone number associated with a CARD payment method.\n    parameters.put(\"billingAddressRequired\", true);\n\n    JSONObject billingAddressParameters = new JSONObject();\n    billingAddressParameters.put(\"format\", \"FULL\");\n\n    parameters.put(\"billingAddressParameters\", billingAddressParameters);\n\n    cardPaymentMethod.put(\"parameters\", parameters);\n\n    return cardPaymentMethod;\n  }\n\n  /**\n   * Describe the expected returned payment data for the CARD payment method\n   *\n   * @return A CARD PaymentMethod describing accepted cards and optional fields.\n   * @throws JSONException if the object is malformed.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#PaymentMethod\">PaymentMethod</a>\n   */\n  private static JSONObject getCardPaymentMethod() throws JSONException {\n    JSONObject cardPaymentMethod = getBaseCardPaymentMethod();\n    cardPaymentMethod.put(\"tokenizationSpecification\", getGatewayTokenizationSpecification());\n\n    return cardPaymentMethod;\n  }\n\n  /**\n   * An object describing accepted forms of payment by your app, used to determine a viewer's\n   * readiness to pay.\n   *\n   * @return API version and payment methods supported by the app.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#IsReadyToPayRequest\">IsReadyToPayRequest</a>\n   */\n  public static JSONObject getIsReadyToPayRequest() {\n    try {\n      JSONObject isReadyToPayRequest = getBaseRequest();\n      isReadyToPayRequest.put(\n          \"allowedPaymentMethods\", new JSONArray().put(getBaseCardPaymentMethod()));\n\n      return isReadyToPayRequest;\n\n    } catch (JSONException e) {\n      return null;\n    }\n  }\n\n  /**\n   * Provide Google Pay API with a payment amount, currency, and amount status.\n   *\n   * @return information about the requested payment.\n   * @throws JSONException if the object is malformed.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#TransactionInfo\">TransactionInfo</a>\n   */\n  private static JSONObject getTransactionInfo(String price) throws JSONException {\n    JSONObject transactionInfo = new JSONObject();\n    transactionInfo.put(\"totalPrice\", price);\n    transactionInfo.put(\"totalPriceStatus\", \"FINAL\");\n    transactionInfo.put(\"countryCode\", Constants.COUNTRY_CODE);\n    transactionInfo.put(\"currencyCode\", Constants.CURRENCY_CODE);\n    transactionInfo.put(\"checkoutOption\", \"COMPLETE_IMMEDIATE_PURCHASE\");\n\n    return transactionInfo;\n  }\n\n  /**\n   * Information about the merchant requesting payment information\n   *\n   * @return Information about the merchant.\n   * @throws JSONException if the object is malformed.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#MerchantInfo\">MerchantInfo</a>\n   */\n  private static JSONObject getMerchantInfo() throws JSONException {\n    return new JSONObject().put(\"merchantName\", \"Example Merchant\");\n  }\n\n  /**\n   * An object describing information requested in a Google Pay payment sheet\n   *\n   * @return Payment data expected by your app.\n   * @see <a\n   * href=\"https://developers.google.com/pay/api/android/reference/object#PaymentDataRequest\">PaymentDataRequest</a>\n   */\n  public static JSONObject getPaymentDataRequest(long priceCents) {\n\n    final String price = PaymentsUtil.centsToString(priceCents);\n\n    try {\n      JSONObject paymentDataRequest = PaymentsUtil.getBaseRequest();\n      paymentDataRequest.put(\n          \"allowedPaymentMethods\", new JSONArray().put(PaymentsUtil.getCardPaymentMethod()));\n      paymentDataRequest.put(\"transactionInfo\", PaymentsUtil.getTransactionInfo(price));\n      paymentDataRequest.put(\"merchantInfo\", PaymentsUtil.getMerchantInfo());\n\n      /* An optional shipping address requirement is a top-level property of the PaymentDataRequest\n      JSON object. */\n      paymentDataRequest.put(\"shippingAddressRequired\", true);\n\n      JSONObject shippingAddressParameters = new JSONObject();\n      shippingAddressParameters.put(\"phoneNumberRequired\", false);\n\n      JSONArray allowedCountryCodes = new JSONArray(Constants.SHIPPING_SUPPORTED_COUNTRIES);\n\n      shippingAddressParameters.put(\"allowedCountryCodes\", allowedCountryCodes);\n      paymentDataRequest.put(\"shippingAddressParameters\", shippingAddressParameters);\n      return paymentDataRequest;\n\n    } catch (JSONException e) {\n      return null;\n    }\n  }\n\n  /**\n   * Converts cents to a string format accepted by {@link PaymentsUtil#getPaymentDataRequest}.\n   *\n   * @param cents value of the price in cents.\n   */\n  public static String centsToString(long cents) {\n    return new BigDecimal(cents)\n        .divide(CENTS_IN_A_UNIT, RoundingMode.HALF_EVEN)\n        .setScale(2, RoundingMode.HALF_EVEN)\n        .toString();\n  }\n}\n";
    }
}

