/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.cppGameActivity.src;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"textureAssetCpp", "", "textureAssetH", "intellij.android.wizardTemplate.impl"})
public final class TextureAssetCppKt {
    @NotNull
    public static final String textureAssetCpp() {
        return "\n#include <android/imagedecoder.h>\n#include \"TextureAsset.h\"\n#include \"AndroidOut.h\"\n#include \"Utility.h\"\n\nstd::shared_ptr<TextureAsset>\nTextureAsset::loadAsset(AAssetManager *assetManager, const std::string &assetPath) {\n    // Get the image from asset manager\n    auto pAndroidRobotPng = AAssetManager_open(\n            assetManager,\n            assetPath.c_str(),\n            AASSET_MODE_BUFFER);\n\n    // Make a decoder to turn it into a texture\n    AImageDecoder *pAndroidDecoder = nullptr;\n    auto result = AImageDecoder_createFromAAsset(pAndroidRobotPng, &pAndroidDecoder);\n    assert(result == ANDROID_IMAGE_DECODER_SUCCESS);\n\n    // make sure we get 8 bits per channel out. RGBA order.\n    AImageDecoder_setAndroidBitmapFormat(pAndroidDecoder, ANDROID_BITMAP_FORMAT_RGBA_8888);\n\n    // Get the image header, to help set everything up\n    const AImageDecoderHeaderInfo *pAndroidHeader = nullptr;\n    pAndroidHeader = AImageDecoder_getHeaderInfo(pAndroidDecoder);\n\n    // important metrics for sending to GL\n    auto width = AImageDecoderHeaderInfo_getWidth(pAndroidHeader);\n    auto height = AImageDecoderHeaderInfo_getHeight(pAndroidHeader);\n    auto stride = AImageDecoder_getMinimumStride(pAndroidDecoder);\n\n    // Get the bitmap data of the image\n    auto upAndroidImageData = std::make_unique<std::vector<uint8_t>>(height * stride);\n    auto decodeResult = AImageDecoder_decodeImage(\n            pAndroidDecoder,\n            upAndroidImageData->data(),\n            stride,\n            upAndroidImageData->size());\n    assert(decodeResult == ANDROID_IMAGE_DECODER_SUCCESS);\n\n    // Get an opengl texture\n    GLuint textureId;\n    glGenTextures(1, &textureId);\n    glBindTexture(GL_TEXTURE_2D, textureId);\n\n    // Clamp to the edge, you'll get odd results alpha blending if you don't\n    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP_TO_EDGE);\n    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP_TO_EDGE);\n\n    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_LINEAR);\n    glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);\n\n    // Load the texture into VRAM\n    glTexImage2D(\n            GL_TEXTURE_2D, // target\n            0, // mip level\n            GL_RGBA, // internal format, often advisable to use BGR\n            width, // width of the texture\n            height, // height of the texture\n            0, // border (always 0)\n            GL_RGBA, // format\n            GL_UNSIGNED_BYTE, // type\n            upAndroidImageData->data() // Data to upload\n    );\n\n    // generate mip levels. Not really needed for 2D, but good to do\n    glGenerateMipmap(GL_TEXTURE_2D);\n\n    // cleanup helpers\n    AImageDecoder_delete(pAndroidDecoder);\n    AAsset_close(pAndroidRobotPng);\n\n    // Create a shared pointer so it can be cleaned up easily/automatically\n    return std::shared_ptr<TextureAsset>(new TextureAsset(textureId));\n}\n\nTextureAsset::~TextureAsset() {\n    // return texture resources\n    glDeleteTextures(1, &textureID_);\n    textureID_ = 0;\n}\n";
    }

    @NotNull
    public static final String textureAssetH() {
        return "\n#ifndef ANDROIDGLINVESTIGATIONS_TEXTUREASSET_H\n#define ANDROIDGLINVESTIGATIONS_TEXTUREASSET_H\n\n#include <memory>\n#include <android/asset_manager.h>\n#include <GLES3/gl3.h>\n#include <string>\n#include <vector>\n\nclass TextureAsset {\npublic:\n    /*!\n     * Loads a texture asset from the assets/ directory\n     * @param assetManager Asset manager to use\n     * @param assetPath The path to the asset\n     * @return a shared pointer to a texture asset, resources will be reclaimed when it's cleaned up\n     */\n    static std::shared_ptr<TextureAsset>\n    loadAsset(AAssetManager *assetManager, const std::string &assetPath);\n\n    ~TextureAsset();\n\n    /*!\n     * @return the texture id for use with OpenGL\n     */\n    constexpr GLuint getTextureID() const { return textureID_; }\n\nprivate:\n    inline TextureAsset(GLuint textureId) : textureID_(textureId) {}\n\n    GLuint textureID_;\n};\n\n\n#endif //ANDROIDGLINVESTIGATIONS_TEXTUREASSET_H\n";
    }
}

