/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.composeWearActivity.src.app_package.tile;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"tileServiceKt", "", "tileServiceClass", "defaultPreview", "packageName", "intellij.android.wizardTemplate.impl"})
public final class TileServiceKt {
    @NotNull
    public static final String tileServiceKt(@NotNull String tileServiceClass, @NotNull String defaultPreview2, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)tileServiceClass, (String)"tileServiceClass");
        Intrinsics.checkNotNullParameter((Object)defaultPreview2, (String)"defaultPreview");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".tile\n\nimport android.content.Context\nimport androidx.compose.runtime.Composable\nimport androidx.compose.ui.platform.LocalContext\nimport androidx.compose.ui.tooling.preview.Devices\nimport androidx.compose.ui.tooling.preview.Preview\nimport androidx.wear.tiles.LayoutElementBuilders\nimport androidx.wear.tiles.RequestBuilders\nimport androidx.wear.tiles.ResourceBuilders\nimport androidx.wear.tiles.TileBuilders\nimport androidx.wear.tiles.TimelineBuilders\nimport androidx.wear.tiles.material.Text\nimport androidx.wear.tiles.material.Typography\nimport androidx.wear.tiles.material.layouts.PrimaryLayout\nimport com.google.android.horologist.compose.tools.LayoutRootPreview\nimport com.google.android.horologist.compose.tools.buildDeviceParameters\nimport com.google.android.horologist.tiles.CoroutinesTileService\n\nprivate const val RESOURCES_VERSION = \"0\"\n\n/**\n * Skeleton for a tile with no images.\n */\nclass " + tileServiceClass + " : CoroutinesTileService() {\n\n    override suspend fun resourcesRequest(\n        requestParams: RequestBuilders.ResourcesRequest\n    ): ResourceBuilders.Resources {\n        return ResourceBuilders.Resources.Builder().setVersion(RESOURCES_VERSION).build()\n    }\n\n    override suspend fun tileRequest(\n        requestParams: RequestBuilders.TileRequest\n    ): TileBuilders.Tile {\n        val singleTileTimeline = TimelineBuilders.Timeline.Builder().addTimelineEntry(\n            TimelineBuilders.TimelineEntry.Builder().setLayout(\n                LayoutElementBuilders.Layout.Builder().setRoot(tileLayout(this)).build()\n            ).build()\n        ).build()\n\n        return TileBuilders.Tile.Builder().setResourcesVersion(RESOURCES_VERSION)\n            .setTimeline(singleTileTimeline).build()\n    }\n}\n\nprivate fun tileLayout(context: Context): LayoutElementBuilders.LayoutElement {\n    return PrimaryLayout.Builder(buildDeviceParameters(context.resources))\n        .setContent(\n            Text.Builder(context, \"Hello World!\")\n                .setTypography(Typography.TYPOGRAPHY_CAPTION1)\n                .build()\n        ).build()\n}\n\n@Preview(\n    device = Devices.WEAR_OS_SMALL_ROUND,\n    showSystemUi = true,\n    backgroundColor = 0xff000000,\n    showBackground = true\n)\n@Composable\nfun " + defaultPreview2 + "() {\n    LayoutRootPreview(root = tileLayout(LocalContext.current))\n}\n";
    }
}

