/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.metrics;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.AnonymizerUtil;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.google.targetsdkversionassistant.metrics.FilterId;
import com.google.targetsdkversionassistant.metrics.Utils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TSdkUAEvent;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0004\u0018\u0000 '2\u00020\u0001:\u0001'B\u0015\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB#\b\u0017\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\rB)\b\u0007\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\u0010\u000eJ!\u0010\u0013\u001a\u00020\f2\u0017\u0010\u0014\u001a\u0013\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\u0016H\u0002J\"\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u001bJ6\u0010\u001e\u001a\u00020\f\"\u0004\b\u0000\u0010\u001f2\u0006\u0010 \u001a\u00020!2\u0012\u0010\"\u001a\u000e\u0012\u0004\u0012\u0002H\u001f\u0012\u0004\u0012\u00020!0\n2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u001f0$J(\u0010%\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u0018\u001a\u00020\u00192\u0012\u0010&\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0\u0003R\u001b\u0010\u000f\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0002\u0010\u0010R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcom/google/targetsdkversionassistant/metrics/Tracker;", "", "getPackageId", "Lkotlin/Function0;", "", "(Lkotlin/jvm/functions/Function0;)V", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "studioLog", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/AndroidStudioEvent$Builder;", "", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function1;)V", "packageId", "()Ljava/lang/String;", "packageId$delegate", "Lkotlin/Lazy;", "log", "setUp", "Lcom/google/wireless/android/sdk/stats/TSdkUAEvent$Builder;", "Lkotlin/ExtensionFunctionType;", "logFilterRunResult", "id", "Lcom/google/targetsdkversionassistant/metrics/FilterId;", "timedResult", "Lcom/google/targetsdkversionassistant/metrics/Utils$TimedResult;", "", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "logState", "Step", "encoderVersion", "", "encode", "remainingSteps", "", "runFilterWithTracking", "run", "Companion", "targetsdkversion-upgrade-assistant"})
public final class Tracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<AndroidStudioEvent.Builder, Unit> studioLog;
    @NotNull
    private final Lazy packageId$delegate;

    @VisibleForTesting
    public Tracker(@NotNull Function0<String> getPackageId, @NotNull Function1<? super AndroidStudioEvent.Builder, Unit> studioLog) {
        Intrinsics.checkNotNullParameter(getPackageId, (String)"getPackageId");
        Intrinsics.checkNotNullParameter(studioLog, (String)"studioLog");
        this.studioLog = studioLog;
        this.packageId$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, getPackageId);
    }

    private final String getPackageId() {
        Lazy lazy = this.packageId$delegate;
        return (String)lazy.getValue();
    }

    public Tracker(@NotNull Function0<String> getPackageId) {
        Intrinsics.checkNotNullParameter(getPackageId, (String)"getPackageId");
        this(getPackageId, (Function1<? super AndroidStudioEvent.Builder, Unit>)((Function1)new Function1<AndroidStudioEvent.Builder, Unit>((Object)UsageTracker.INSTANCE){

            public final void invoke(@NotNull AndroidStudioEvent.Builder p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                UsageTracker.log((AndroidStudioEvent.Builder)p0);
            }
        }));
    }

    public Tracker(final @NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this((Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return Companion.projectId(project);
            }
        }));
    }

    @TestOnly
    public Tracker(final @NotNull Project project, @NotNull Function1<? super AndroidStudioEvent.Builder, Unit> studioLog) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(studioLog, (String)"studioLog");
        this((Function0<String>)((Function0)new Function0<String>(){

            @NotNull
            public final String invoke() {
                return Companion.projectId(project);
            }
        }), studioLog);
    }

    public final <Step> void logState(int encoderVersion, @NotNull Function1<? super Step, Integer> encode, @NotNull Collection<? extends Step> remainingSteps) {
        Intrinsics.checkNotNullParameter(encode, (String)"encode");
        Intrinsics.checkNotNullParameter(remainingSteps, (String)"remainingSteps");
        this.log((Function1<? super TSdkUAEvent.Builder, Unit>)((Function1)new Function1<TSdkUAEvent.Builder, Unit>(encoderVersion, encode, remainingSteps){
            final /* synthetic */ int $encoderVersion;
            final /* synthetic */ Function1<Step, Integer> $encode;
            final /* synthetic */ Collection<Step> $remainingSteps;
            {
                this.$encoderVersion = $encoderVersion;
                this.$encode = $encode;
                this.$remainingSteps = $remainingSteps;
                super(1);
            }

            public final void invoke(@NotNull TSdkUAEvent.Builder $this$log) {
                Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
                $this$log.setStateUpdate((TSdkUAEvent.StateUpdate)Utils.INSTANCE.getStateUpdate().invoke((Object)new Function1<TSdkUAEvent.StateUpdate.Builder, Unit>(this.$encoderVersion, this.$encode, this.$remainingSteps){
                    final /* synthetic */ int $encoderVersion;
                    final /* synthetic */ Function1<Step, Integer> $encode;
                    final /* synthetic */ Collection<Step> $remainingSteps;
                    {
                        this.$encoderVersion = $encoderVersion;
                        this.$encode = $encode;
                        this.$remainingSteps = $remainingSteps;
                        super(1);
                    }

                    public final void invoke(TSdkUAEvent.StateUpdate.Builder $this$invoke) {
                        $this$invoke.setTimestampMs(System.currentTimeMillis());
                        $this$invoke.setMappingVersion(this.$encoderVersion);
                        $this$invoke.setActiveSteps(Utils.INSTANCE.encodeSet(this.$encode, this.$remainingSteps));
                    }
                }));
            }
        }));
    }

    public final void logFilterRunResult(@NotNull FilterId id, @NotNull Utils.TimedResult<List<LocationProvider>> timedResult) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(timedResult, (String)"timedResult");
        this.log((Function1<? super TSdkUAEvent.Builder, Unit>)((Function1)new Function1<TSdkUAEvent.Builder, Unit>(id, timedResult){
            final /* synthetic */ FilterId $id;
            final /* synthetic */ Utils.TimedResult<List<LocationProvider>> $timedResult;
            {
                this.$id = $id;
                this.$timedResult = $timedResult;
                super(1);
            }

            public final void invoke(@NotNull TSdkUAEvent.Builder $this$log) {
                Intrinsics.checkNotNullParameter((Object)$this$log, (String)"$this$log");
                $this$log.setFilterRun((TSdkUAEvent.FilterRun)Utils.INSTANCE.getFilterRun().invoke((Object)new Function1<TSdkUAEvent.FilterRun.Builder, Unit>(this.$id, this.$timedResult){
                    final /* synthetic */ FilterId $id;
                    final /* synthetic */ Utils.TimedResult<List<LocationProvider>> $timedResult;
                    {
                        this.$id = $id;
                        this.$timedResult = $timedResult;
                        super(1);
                    }

                    public final void invoke(TSdkUAEvent.FilterRun.Builder $this$invoke) {
                        $this$invoke.setFilterId(this.$id.getId());
                        $this$invoke.setFilterVersion(this.$id.getVersion());
                        $this$invoke.setElapsedMs(this.$timedResult.getElapsedMs());
                        Utils.Result<List<LocationProvider>> r = this.$timedResult.getResult();
                        if (r instanceof Utils.Result.Value) {
                            $this$invoke.setCount(((List)((Utils.Result.Value)r).getUnboxed()).size());
                        } else if (r instanceof Utils.Result.Error) {
                            $this$invoke.setProblem(TSdkUAEvent.FilterRun.Problem.ERROR);
                        }
                    }
                }));
            }
        }));
    }

    @NotNull
    public final List<LocationProvider> runFilterWithTracking(@NotNull FilterId id, @NotNull Function0<? extends List<? extends LocationProvider>> run) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(run, (String)"run");
        Utils.TimedResult<List<LocationProvider>> timedResult = Utils.TimedResult.Companion.of(run);
        this.logFilterRunResult(id, timedResult);
        return timedResult.getResult().unpack();
    }

    private final void log(Function1<? super TSdkUAEvent.Builder, Unit> setUp) {
        AndroidStudioEvent.Builder builder = AndroidStudioEvent.newBuilder().setKind(AndroidStudioEvent.EventKind.TSDKUA_EVENT).setProjectId(AnonymizerUtil.anonymizeUtf8((String)this.getPackageId())).setTsdkUaEvent((TSdkUAEvent)Utils.INSTANCE.getTSdkUAEvent().invoke(setUp));
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"newBuilder()\n        .se\u2026Utils.tSdkUAEvent(setUp))");
        this.studioLog.invoke((Object)builder);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lcom/google/targetsdkversionassistant/metrics/Tracker$Companion;", "", "()V", "projectId", "", "p", "Lcom/intellij/openapi/project/Project;", "targetsdkversion-upgrade-assistant"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final String projectId(@NotNull Project p) {
            Intrinsics.checkNotNullParameter((Object)p, (String)"p");
            String string = (String)CollectionsKt.firstOrNull((Iterable)ProjectSystemUtil.getProjectSystem((Project)p).getKnownApplicationIds(p));
            if (string == null) {
                string = "unknown";
            }
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

