/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant.filter;

import com.google.targetsdkversionassistant.filter.Location;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditorNavigatable;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.base.psi.PsiLinesUtilsKt;
import org.jetbrains.kotlin.idea.core.script.ucache.KotlinScriptEntitiesKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\r\u001a\u00020\u000e2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00110\u0010H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR!\u0010\t\u001a\u0015\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\u00030\u00030\n\u00a2\u0006\u0002\b\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/google/targetsdkversionassistant/filter/PsiElementLocationProvider;", "Lcom/google/targetsdkversionassistant/filter/LocationProvider;", "psiElement", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "location", "Lcom/google/targetsdkversionassistant/filter/Location;", "getLocation", "()Lcom/google/targetsdkversionassistant/filter/Location;", "psiPointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "toHtml", "", "links", "", "Lcom/intellij/openapi/fileEditor/FileEditorNavigatable;", "targetsdkversion-upgrade-assistant"})
final class PsiElementLocationProvider
implements LocationProvider {
    @NotNull
    private final SmartPsiElementPointer<PsiElement> psiPointer;

    public PsiElementLocationProvider(@NotNull PsiElement psiElement) {
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        SmartPsiElementPointer smartPsiElementPointer = SmartPointerManager.createPointer((PsiElement)psiElement);
        Intrinsics.checkNotNullExpressionValue((Object)smartPsiElementPointer, (String)"createPointer(psiElement)");
        this.psiPointer = smartPsiElementPointer;
    }

    @Override
    @Nullable
    public Location getLocation() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Project project = this.psiPointer.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"psiPointer.project");
        Project project2 = project;
        VirtualFile file = this.psiPointer.getVirtualFile();
        PsiElement psiElement = this.psiPointer.getElement();
        if (psiElement == null) {
            return null;
        }
        PsiElement elem = psiElement;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        String relPath = KotlinScriptEntitiesKt.relativeName((VirtualFile)file, (Project)project2);
        int line = PsiLinesUtilsKt.getLineNumber$default((PsiElement)elem, (boolean)false, (int)1, null) + 1;
        int n = elem.getTextOffset();
        PsiFile psiFile = elem.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"elem.containingFile");
        Integer n2 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)psiFile, (int)line, (boolean)false);
        int col = n - (n2 != null ? n2.intValue() : elem.getTextOffset()) + 1;
        return new Location(relPath, line, col);
    }

    @Override
    @NotNull
    public String toHtml(@NotNull Map<String, FileEditorNavigatable> links) {
        Object object;
        String desc;
        VirtualFile file;
        Project project;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter(links, (String)"links");
                ApplicationManager.getApplication().assertReadAccessAllowed();
                Project project2 = this.psiPointer.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"psiPointer.project");
                project = project2;
                file = this.psiPointer.getVirtualFile();
                PsiElement psiElement = this.psiPointer.getElement();
                OpenFileDescriptor navigable = new OpenFileDescriptor(project, file, psiElement != null ? psiElement.getTextOffset() : 0);
                desc = String.valueOf(navigable.hashCode());
                links.put(desc, (FileEditorNavigatable)navigable);
                object = this.psiPointer.getElement();
                if (object == null) break block2;
                PsiElement it = object;
                boolean bl = false;
                int line = PsiLinesUtilsKt.getLineNumber$default((PsiElement)it, (boolean)false, (int)1, null);
                int n = it.getTextOffset();
                PsiFile psiFile = it.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"it.containingFile");
                Integer n2 = PsiLinesUtilsKt.getLineStartOffset((PsiFile)psiFile, (int)line, (boolean)false);
                int column = n - (n2 != null ? n2.intValue() : it.getTextOffset());
                String string = ":" + (line + 1) + ":" + (column + 1);
                object = string;
                if (string != null) break block3;
            }
            object = "";
        }
        Object location = object;
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
        return "<a href=\"" + desc + "\">" + KotlinScriptEntitiesKt.relativeName((VirtualFile)file, (Project)project) + (String)location + "</a>";
    }
}

