/*
 * Decompiled with CFR 0.152.
 */
package com.google.targetsdkversionassistant;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.assistant.AssistActionState;
import com.android.tools.idea.assistant.AssistActionStateManager;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.datamodel.DefaultActionState;
import com.android.tools.idea.assistant.view.StatefulButtonMessage;
import com.google.targetsdkversionassistant.VerifyActionMessage;
import com.google.targetsdkversionassistant.filter.FilterService;
import com.google.targetsdkversionassistant.filter.LocationProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.android.AndroidPluginDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0017J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0007H\u0017J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0013H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/google/targetsdkversionassistant/VerifyActionStateManager;", "Lcom/android/tools/idea/assistant/AssistActionStateManager;", "()V", "myRegisteredProjects", "", "Lcom/intellij/openapi/project/Project;", "getId", "", "getState", "Lcom/android/tools/idea/assistant/AssistActionState;", "project", "actionData", "Lcom/android/tools/idea/assistant/datamodel/ActionData;", "getStateDisplay", "Lcom/android/tools/idea/assistant/view/StatefulButtonMessage;", "message", "init", "", "problemCount", "", "nonLocatableProblemCount", "targetsdkversion-upgrade-assistant"})
@SourceDebugExtension(value={"SMAP\nVerifyActionStateManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VerifyActionStateManager.kt\ncom/google/targetsdkversionassistant/VerifyActionStateManager\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,133:1\n29#2,3:134\n29#2,3:137\n1770#3,4:140\n*S KotlinDebug\n*F\n+ 1 VerifyActionStateManager.kt\ncom/google/targetsdkversionassistant/VerifyActionStateManager\n*L\n67#1:134,3\n91#1:137,3\n107#1:140,4\n*E\n"})
public final class VerifyActionStateManager
extends AssistActionStateManager {
    @NotNull
    private final Set<Project> myRegisteredProjects = new LinkedHashSet();

    @NotNull
    public String getId() {
        return "VerifyAction";
    }

    public void init(@NotNull Project project, @NotNull ActionData actionData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        if (this.myRegisteredProjects.add(project)) {
            AndroidPluginDisposable parentDisposable = AndroidPluginDisposable.Companion.getProjectInstance(project);
            MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)parentDisposable);
            Topic topic = DumbService.DUMB_MODE;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"DUMB_MODE");
            messageBusConnection.subscribe(topic, (Object)new DumbService.DumbModeListener(this, project){
                final /* synthetic */ VerifyActionStateManager this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public void enteredDumbMode() {
                    this.this$0.refreshDependencyState(this.$project);
                }

                public void exitDumbMode() {
                    this.this$0.refreshDependencyState(this.$project);
                }
            });
            Disposer.register((Disposable)((Disposable)parentDisposable), (Disposable)new Disposable(this, project){
                final /* synthetic */ VerifyActionStateManager this$0;
                final /* synthetic */ Project $project;
                {
                    this.this$0 = $receiver;
                    this.$project = $project;
                }

                public final void dispose() {
                    VerifyActionStateManager.access$getMyRegisteredProjects$p(this.this$0).remove(this.$project);
                }
            });
        }
    }

    @UiThread
    @NotNull
    public AssistActionState getState(@NotNull Project project, @NotNull ActionData actionData) {
        AssistActionState assistActionState;
        FilterService.Result result;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        if (DumbService.getInstance((Project)project).isDumb()) {
            return (AssistActionState)DefaultActionState.IN_PROGRESS;
        }
        String string = actionData.getActionArgument();
        Intrinsics.checkNotNull((Object)string);
        String filter2 = string;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FilterService> serviceClass$iv = FilterService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        FilterService service = (FilterService)object;
        if (service.getFiltersInProgress().contains(filter2)) {
            return (AssistActionState)DefaultActionState.IN_PROGRESS;
        }
        FilterService.Result result2 = service.getFilterResults().get(filter2);
        Intrinsics.checkNotNull((Object)result2);
        FilterService.Result result3 = result = result2;
        if (Intrinsics.areEqual((Object)result3, (Object)FilterService.Init.INSTANCE)) {
            assistActionState = (AssistActionState)DefaultActionState.INCOMPLETE;
        } else if (Intrinsics.areEqual((Object)result3, (Object)FilterService.Irrelevant.INSTANCE)) {
            assistActionState = (AssistActionState)DefaultActionState.COMPLETE;
        } else if (result3 instanceof FilterService.HasProblems) {
            DefaultActionState defaultActionState;
            boolean bl = ((FilterService.HasProblems)result).getProblems().isEmpty();
            if (bl) {
                defaultActionState = DefaultActionState.PARTIALLY_COMPLETE;
            } else if (!bl) {
                defaultActionState = DefaultActionState.NOT_APPLICABLE;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            assistActionState = (AssistActionState)defaultActionState;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return assistActionState;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @UiThread
    @NotNull
    public StatefulButtonMessage getStateDisplay(@NotNull Project project, @NotNull ActionData actionData, @Nullable String message2) {
        StatefulButtonMessage statefulButtonMessage;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionData, (String)"actionData");
        String string = actionData.getActionArgument();
        Intrinsics.checkNotNull((Object)string);
        String filter2 = string;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<FilterService> serviceClass$iv = FilterService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        FilterService service = (FilterService)object;
        FilterService.Result result = service.getFilterResults().get(filter2);
        Intrinsics.checkNotNull((Object)result);
        FilterService.Result result2 = result;
        AssistActionState state = this.getState(project, actionData);
        FilterService.Result result3 = result2;
        if (Intrinsics.areEqual((Object)result3, (Object)FilterService.Init.INSTANCE)) {
            statefulButtonMessage = new StatefulButtonMessage("", state, null, 4, null);
            return statefulButtonMessage;
        } else if (Intrinsics.areEqual((Object)result3, (Object)FilterService.Irrelevant.INSTANCE)) {
            statefulButtonMessage = new StatefulButtonMessage("Step complete!", state, null, 4, null);
            return statefulButtonMessage;
        } else {
            if (!(result3 instanceof FilterService.HasProblems)) throw new NoWhenBranchMatchedException();
            List<LocationProvider> problems = ((FilterService.HasProblems)result2).getProblems();
            boolean bl = problems.isEmpty();
            if (bl) {
                statefulButtonMessage = new StatefulButtonMessage("Step complete!", state, null, 4, null);
                return statefulButtonMessage;
            } else {
                int n;
                void $this$count$iv;
                if (bl) throw new NoWhenBranchMatchedException();
                Iterable iterable = problems;
                int n2 = problems.size();
                VerifyActionStateManager verifyActionStateManager = this;
                boolean $i$f$count = false;
                if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                    n = 0;
                } else {
                    int count$iv = 0;
                    for (Object element$iv : $this$count$iv) {
                        LocationProvider it = (LocationProvider)element$iv;
                        boolean bl2 = false;
                        if (!(it.getLocation() == null) || ++count$iv >= 0) continue;
                        CollectionsKt.throwCountOverflow();
                    }
                    n = count$iv;
                }
                int n3 = n;
                List<LocationProvider> list = problems;
                AssistActionState assistActionState = state;
                String string2 = verifyActionStateManager.message(n2, n3);
                statefulButtonMessage = new VerifyActionMessage(string2, assistActionState, list);
            }
        }
        return statefulButtonMessage;
    }

    private final String message(int problemCount, int nonLocatableProblemCount) {
        StringBuilder stringBuilder;
        int linkProblemCount = problemCount - nonLocatableProblemCount;
        StringBuilder $this$message_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        if (nonLocatableProblemCount > 0) {
            $this$message_u24lambda_u241.append("Found " + nonLocatableProblemCount + " " + VerifyActionStateManager.message$problemString(problemCount) + " without a location.");
        }
        if (linkProblemCount > 0) {
            $this$message_u24lambda_u241.append("Review the " + linkProblemCount + " " + VerifyActionStateManager.message$problemString(linkProblemCount) + " that " + VerifyActionStateManager.message$wasString(linkProblemCount) + " found:");
        }
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    private static final String message$problemString(int count) {
        return count > 1 ? "problems" : "problem";
    }

    private static final String message$wasString(int count) {
        return count > 1 ? "were" : "was";
    }

    public static final /* synthetic */ Set access$getMyRegisteredProjects$p(VerifyActionStateManager $this) {
        return $this.myRegisteredProjects;
    }
}

