/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.ide.common.repository.GradleCoordinate;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import java.util.Collection;
import java.util.Set;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u001a\u001c\u0010\t\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\b\u001a\f\u0010\n\u001a\u00020\u0006*\u00020\u0003H\u0002\u001a\f\u0010\u000b\u001a\u00020\u0001*\u00020\u0001H\u0001\u00a8\u0006\f"}, d2={"getGroupPrefix", "", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "pickLibraryVariableName", "includeVersionInKey", "", "caseSensitiveReserved", "", "pickVersionVariableName", "isAndroidX", "toSafeKey", "android.sdktools.sdk-common"})
@SourceDebugExtension(value={"SMAP\nVersionCatalogNamingUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,220:1\n1743#2,3:221\n1060#3,2:224\n*S KotlinDebug\n*F\n+ 1 VersionCatalogNamingUtil.kt\ncom/android/ide/common/repository/VersionCatalogNamingUtilKt\n*L\n51#1:221,3\n104#1:224,2\n*E\n"})
public final class VersionCatalogNamingUtilKt {
    private static final boolean isAndroidX(GradleCoordinate $this$isAndroidX) {
        String string = $this$isAndroidX.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"groupId");
        return StringsKt.startsWith$default((String)string, (String)"androidx.", (boolean)false, (int)2, null);
    }

    @NotNull
    public static final String pickLibraryVariableName(@NotNull GradleCoordinate gc, boolean includeVersionInKey, @NotNull Set<String> caseSensitiveReserved) {
        String name;
        String versionSuffix;
        TreeSet reserved;
        block16: {
            block17: {
                boolean bl;
                block15: {
                    String string;
                    Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
                    Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
                    reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
                    reserved.addAll(caseSensitiveReserved);
                    if (includeVersionInKey) {
                        StringBuilder stringBuilder = new StringBuilder().append('-');
                        String string2 = gc.getRevision();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gc.revision");
                        string = stringBuilder.append(VersionCatalogNamingUtilKt.toSafeKey(StringsKt.replace$default((String)string2, (char)'.', (char)'_', (boolean)false, (int)4, null))).toString();
                    } else {
                        string = versionSuffix = "";
                    }
                    if (!VersionCatalogNamingUtilKt.isAndroidX(gc)) break block16;
                    if (reserved.isEmpty()) break block17;
                    Iterable $this$any$iv = reserved;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                            if (!StringsKt.startsWith$default((String)it, (String)"androidx-", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block15;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block16;
            }
            StringBuilder stringBuilder = new StringBuilder().append("androidx-");
            String string = gc.getArtifactId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.artifactId");
            String key = stringBuilder.append(VersionCatalogNamingUtilKt.toSafeKey(string)).append(versionSuffix).toString();
            if (!reserved.contains(key)) {
                return key;
            }
        }
        String string = gc.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.artifactId");
        String artifactId = VersionCatalogNamingUtilKt.toSafeKey(string);
        String artifactKey = artifactId + versionSuffix;
        if (!reserved.contains(artifactKey)) {
            return artifactKey;
        }
        String string3 = gc.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"gc.groupId");
        String groupSuffix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringAfterLast$default((String)string3, (char)'.', null, (int)2, null));
        String withGroupSuffix = groupSuffix + '-' + artifactId + versionSuffix;
        if (!StringsKt.startsWith$default((String)artifactId, (String)groupSuffix, (boolean)false, (int)2, null) && !reserved.contains(withGroupSuffix)) {
            return withGroupSuffix;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(gc);
        String withGroupPrefix = groupPrefix + '-' + artifactId + versionSuffix;
        if (!reserved.contains(withGroupPrefix)) {
            return withGroupPrefix;
        }
        String string4 = gc.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"gc.groupId");
        String groupId = VersionCatalogNamingUtilKt.toSafeKey(string4);
        String full = groupId + '-' + artifactId + versionSuffix;
        if (!reserved.contains(full)) {
            return full;
        }
        int id = 2;
        while (reserved.contains(name = full + (((CharSequence)versionSuffix).length() > 0 ? "-" : "") + id++)) {
        }
        return name;
    }

    @VisibleForTesting
    @NotNull
    public static final String toSafeKey(@NotNull String $this$toSafeKey) {
        boolean bl;
        int n;
        block3: {
            Intrinsics.checkNotNullParameter((Object)$this$toSafeKey, (String)"<this>");
            CharSequence $this$all$iv = $this$toSafeKey;
            boolean $i$f$all = false;
            for (n = 0; n < $this$all$iv.length(); ++n) {
                char element$iv;
                char it = element$iv = $this$all$iv.charAt(n);
                boolean bl2 = false;
                if (Character.isLetterOrDigit(it) || it == '-' || it == '_') continue;
                bl = false;
                break block3;
            }
            bl = true;
        }
        if (bl) {
            return $this$toSafeKey;
        }
        StringBuilder sb = new StringBuilder();
        n = $this$toSafeKey.length();
        for (int i = 0; i < n; ++i) {
            int c = $this$toSafeKey.charAt(i);
            sb.append((char)(Character.isLetterOrDigit((char)c) || c == 45 ? c : (c == 46 ? 45 : 95)));
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
        return string;
    }

    /*
     * Unable to fully structure code
     */
    private static final String getGroupPrefix(GradleCoordinate gc) {
        v0 = gc.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"gc.groupId");
        groupPrefix = VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)v0, (char)'.', null, (int)2, null));
        switch (groupPrefix.hashCode()) {
            case 98689: {
                if (!groupPrefix.equals("com")) {
                    break;
                }
                ** GOTO lbl15
            }
            case 110308: {
                if (!groupPrefix.equals("org")) {
                    break;
                }
                ** GOTO lbl15
            }
            case 3366: {
                if (!groupPrefix.equals("io")) break;
lbl15:
                // 3 sources

                v1 = gc.getGroupId();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"gc.groupId");
                return VersionCatalogNamingUtilKt.toSafeKey(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)v1, (char)'.', null, (int)2, null), (char)'.', null, (int)2, null));
            }
        }
        return VersionCatalogNamingUtilKt.toSafeKey(groupPrefix);
    }

    @NotNull
    public static final String pickVersionVariableName(@NotNull GradleCoordinate gc, @NotNull Set<String> caseSensitiveReserved) {
        String name;
        String withGroupIdPrefixVersion;
        String withVersion;
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        Intrinsics.checkNotNullParameter(caseSensitiveReserved, (String)"caseSensitiveReserved");
        String string = gc.getArtifactId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gc.artifactId");
        String artifact = VersionCatalogNamingUtilKt.toSafeKey(string);
        TreeSet reserved = new TreeSet(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
        reserved.addAll(caseSensitiveReserved);
        if (reserved.isEmpty()) {
            return artifact;
        }
        boolean haveCamelCase = false;
        boolean haveHyphen = false;
        for (String name2 : reserved) {
            int n = name2.length();
            for (int i = 0; i < n; ++i) {
                char c = name2.charAt(i);
                if (c == '-') {
                    haveHyphen = true;
                    continue;
                }
                if (i <= 0 || !Character.isUpperCase(c) || !Character.isLowerCase(name2.charAt(i - 1)) || !Character.isLowerCase(name2.charAt(0))) continue;
                haveCamelCase = true;
            }
        }
        String artifactCamel = StringsKt.contains$default((CharSequence)artifact, (char)'-', (boolean)false, (int)2, null) ? CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, artifact) : artifact;
        String artifactName = haveCamelCase ? artifactCamel : artifact;
        if (!((Collection)reserved).isEmpty()) {
            String withVersion2;
            Object e = reserved.first();
            Intrinsics.checkNotNullExpressionValue(e, (String)"reserved.first()");
            if (StringsKt.endsWith$default((String)((String)e), (String)"Version", (boolean)false, (int)2, null) && !reserved.contains(withVersion2 = artifactCamel + "Version")) {
                return withVersion2;
            }
        }
        if (!reserved.contains(artifactName)) {
            Intrinsics.checkNotNullExpressionValue((Object)artifactName, (String)"artifactName");
            return artifactName;
        }
        if (!haveHyphen && !reserved.contains(withVersion = artifactCamel + "Version")) {
            return withVersion;
        }
        String groupPrefix = VersionCatalogNamingUtilKt.getGroupPrefix(gc);
        String withGroupIdPrefix = groupPrefix + '-' + artifactName;
        if (!reserved.contains(withGroupIdPrefix)) {
            return withGroupIdPrefix;
        }
        if (!haveHyphen && !reserved.contains(withGroupIdPrefixVersion = groupPrefix + '-' + artifactCamel + "Version")) {
            return withGroupIdPrefixVersion;
        }
        String string2 = gc.getGroupId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"gc.groupId");
        String groupId = VersionCatalogNamingUtilKt.toSafeKey(string2);
        String withGroupId = groupId + '-' + artifactName;
        if (!reserved.contains(withGroupId)) {
            return withGroupId;
        }
        int id = 2;
        while (reserved.contains(name = withGroupId + id++)) {
        }
        return name;
    }
}

