/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.fonts;

import com.android.ide.common.fonts.FontDetail;
import com.android.ide.common.fonts.FontFamily;
import com.android.ide.common.fonts.FontProvider;
import com.android.ide.common.fonts.FontSource;
import com.android.ide.common.fonts.MutableFontDetail;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u00a2\u0006\u0002\u0010\rB=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e\u00a2\u0006\u0002\u0010\u0010B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0011J\u001c\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J\u0011\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010 \u001a\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\"H\u0096\u0002J\b\u0010#\u001a\u00020\u001eH\u0016J\b\u0010$\u001a\u00020\u0007H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006%"}, d2={"Lcom/android/ide/common/fonts/FontFamily;", "", "provider", "Lcom/android/ide/common/fonts/FontProvider;", "fontSource", "Lcom/android/ide/common/fonts/FontSource;", "name", "", "menu", "menuName", "fonts", "", "Lcom/android/ide/common/fonts/MutableFontDetail;", "(Lcom/android/ide/common/fonts/FontProvider;Lcom/android/ide/common/fonts/FontSource;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "Lcom/google/common/collect/ImmutableList;", "Lcom/android/ide/common/fonts/FontDetail;", "(Lcom/android/ide/common/fonts/FontProvider;Lcom/android/ide/common/fonts/FontSource;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/common/collect/ImmutableList;)V", "(Lcom/android/ide/common/fonts/FontProvider;Ljava/lang/String;)V", "getFontSource", "()Lcom/android/ide/common/fonts/FontSource;", "getFonts", "()Ljava/util/List;", "getMenu", "()Ljava/lang/String;", "getMenuName", "getName", "getProvider", "()Lcom/android/ide/common/fonts/FontProvider;", "build", "compareTo", "", "other", "equals", "", "", "hashCode", "toString", "android.sdktools.sdk-common"})
public final class FontFamily
implements Comparable<FontFamily> {
    @NotNull
    private final FontProvider provider;
    @NotNull
    private final FontSource fontSource;
    @NotNull
    private final String name;
    @NotNull
    private final String menu;
    @NotNull
    private final String menuName;
    @NotNull
    private final List<FontDetail> fonts;

    @NotNull
    public final FontProvider getProvider() {
        return this.provider;
    }

    @NotNull
    public final FontSource getFontSource() {
        return this.fontSource;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getMenu() {
        return this.menu;
    }

    @NotNull
    public final String getMenuName() {
        return this.menuName;
    }

    @NotNull
    public final List<FontDetail> getFonts() {
        return this.fonts;
    }

    public FontFamily(@NotNull FontProvider provider, @NotNull FontSource fontSource, @NotNull String name, @NotNull String menu, @NotNull String menuName, @NotNull List<MutableFontDetail> fonts) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)((Object)fontSource), (String)"fontSource");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)menuName, (String)"menuName");
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        this.provider = provider;
        this.fontSource = fontSource;
        this.name = name;
        this.menu = menu;
        this.menuName = ((CharSequence)menuName).length() > 0 ? menuName : name;
        this.fonts = (List)this.build(fonts);
    }

    public FontFamily(@NotNull FontProvider provider, @NotNull FontSource fontSource, @NotNull String name, @NotNull String menu, @NotNull String menuName, @NotNull ImmutableList<FontDetail> fonts) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)((Object)fontSource), (String)"fontSource");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)menu, (String)"menu");
        Intrinsics.checkNotNullParameter((Object)menuName, (String)"menuName");
        Intrinsics.checkNotNullParameter(fonts, (String)"fonts");
        this.provider = provider;
        this.fontSource = fontSource;
        this.name = name;
        this.menu = menu;
        this.menuName = ((CharSequence)menuName).length() > 0 ? menuName : name;
        this.fonts = (List)fonts;
    }

    public FontFamily(@NotNull FontProvider provider, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        List<MutableFontDetail> list = Collections.emptyList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"emptyList()");
        this(provider, FontSource.LOOKUP, name, "", "", list);
    }

    @Override
    public int compareTo(@NotNull FontFamily other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        PropertyReference1Impl propertyReference1Impl = compareTo.1.INSTANCE;
        Function function = new Function((Function1)propertyReference1Impl){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object p0) {
                return this.function.invoke(p0);
            }
        };
        propertyReference1Impl = compareTo.2.INSTANCE;
        return Comparator.comparing(function).thenComparing(new /* invalid duplicate definition of identical inner class */).compare(this, other);
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.provider, this.name};
        return Objects.hash(objectArray);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof FontFamily && Intrinsics.areEqual((Object)this.provider, (Object)((FontFamily)other).provider) && Intrinsics.areEqual((Object)this.name, (Object)((FontFamily)other).name);
    }

    private final ImmutableList<FontDetail> build(List<MutableFontDetail> fonts) {
        ImmutableList.Builder details = ImmutableList.builder();
        for (MutableFontDetail font : fonts) {
            if (((CharSequence)font.getFontUrl()).length() == 0) continue;
            details.add((Object)new FontDetail(this, font));
        }
        ImmutableList immutableList = details.build();
        Intrinsics.checkNotNullExpressionValue((Object)immutableList, (String)"details.build()");
        return immutableList;
    }

    @NotNull
    public String toString() {
        return this.name;
    }
}

