/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.util;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.ErrorReporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LineMapper<T extends CoverageData> {
    protected abstract T createNewLine(T var1, LineMapData var2);

    protected abstract T[] createArray(int var1);

    protected abstract T[] getLines(ClassData var1);

    public T[] mapLines(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        CoverageData[] oldLines = this.getLines(sourceClassData);
        if (linesMap == null) {
            return oldLines;
        }
        if (sourceClassData == targetClassData && oldLines == null) {
            return null;
        }
        try {
            CoverageData[] sourceLines = this.getSourceLinesArray(linesMap, sourceClassData, targetClassData);
            CoverageData[] targetLines = this.getLines(targetClassData);
            for (LineMapData mapData : linesMap) {
                CoverageData source;
                CoverageData targetLineData;
                if (mapData == null) continue;
                int sourceLineNumber = mapData.getSourceLineNumber();
                if (!sourceClassData.isIgnoredLine(sourceLineNumber) && ArrayUtil.safeLoad(sourceLines, sourceLineNumber) == null && (targetLineData = ArrayUtil.safeLoad(targetLines, mapData.getTargetMinLine())) != null) {
                    source = this.createNewLine(targetLineData, mapData);
                    ArrayUtil.safeStore(sourceLines, sourceLineNumber, source);
                }
                for (int targetLineNumber = mapData.getTargetMinLine(); targetLineNumber <= mapData.getTargetMaxLine(); ++targetLineNumber) {
                    source = ArrayUtil.safeLoad(sourceLines, sourceLineNumber);
                    CoverageData target = ArrayUtil.safeLoad(targetLines, targetLineNumber);
                    if (target == null) continue;
                    if (source != null) {
                        source.merge(target);
                    }
                    if (sourceClassData == targetClassData && targetLineNumber == sourceLineNumber) continue;
                    targetLines[targetLineNumber] = null;
                }
            }
            return sourceLines;
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Error creating line mappings for " + targetClassData.getName(), e);
            return oldLines;
        }
    }

    private T[] getSourceLinesArray(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        int maxMappedSourceLineNumber = LineMapper.maxSourceLineNumber(linesMap);
        CoverageData[] currentLines = this.getLines(sourceClassData);
        if (targetClassData == sourceClassData) {
            return currentLines;
        }
        if (currentLines == null) {
            return this.createArray(1 + maxMappedSourceLineNumber);
        }
        if (currentLines.length >= 1 + maxMappedSourceLineNumber) {
            return currentLines;
        }
        CoverageData[] sourceLines = this.createArray(1 + maxMappedSourceLineNumber);
        System.arraycopy(currentLines, 0, sourceLines, 0, currentLines.length);
        return sourceLines;
    }

    public static <T> void dropMappedLines(FileMapData[] mappings, T[] lines, String className) {
        for (FileMapData mapData : mappings) {
            boolean isThisClass = className.equals(mapData.getClassName());
            for (LineMapData lineMapData : mapData.getLines()) {
                int sourceLineNumber = lineMapData.getSourceLineNumber();
                for (int i = lineMapData.getTargetMinLine(); i <= lineMapData.getTargetMaxLine() && i < lines.length; ++i) {
                    if (isThisClass && i == sourceLineNumber) continue;
                    lines[i] = null;
                }
            }
        }
    }

    private static int maxSourceLineNumber(LineMapData[] linesMap) {
        int max = 0;
        for (LineMapData mapData : linesMap) {
            if (mapData == null) continue;
            max = Math.max(max, mapData.getSourceLineNumber());
        }
        return max;
    }
}

