/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.testTracking;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.ExtraFieldInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingClassDataInstrumenter;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

class TestTrackingArrayInstrumenter
extends TestTrackingClassDataInstrumenter {
    private static final String TRACE_MASK_FIELD_NAME = "__$traceMask$__";
    private static final String TRACE_MASK_FIELD_TYPE = "[Z";
    private static final String TRACE_MASK_LOCAL_VARIABLE_NAME = "__$traceMaskLocal$__";
    private final ExtraFieldInstrumenter myExtraTraceMaskFieldInstrumenter;

    public TestTrackingArrayInstrumenter(ProjectData projectData, ClassVisitor classVisitor, ClassReader cr, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, cr, className, shouldCalculateSource);
        this.myExtraTraceMaskFieldInstrumenter = new ExtraTraceMaskFieldTestTrackingInstrumenter(cr, className);
    }

    protected MethodVisitor createMethodTransformer(MethodVisitor mv, LineEnumerator enumerator, int access, String name, String desc) {
        if (enumerator.hasNoLines()) {
            if (this.myExtraClassDataFieldInstrumenter.isInterface() && "<clinit>".equals(name)) {
                MethodVisitor mv1 = this.myExtraClassDataFieldInstrumenter.createMethodVisitor(this, mv, mv, name);
                return this.myExtraTraceMaskFieldInstrumenter.createMethodVisitor(this, mv, mv1, name);
            }
            return mv;
        }
        LocalVariableInserter visitor = new LocalVariableInserter(mv, access, desc, TRACE_MASK_LOCAL_VARIABLE_NAME, TRACE_MASK_FIELD_TYPE){

            public void visitLineNumber(int line, Label start) {
                LineData lineData = TestTrackingArrayInstrumenter.this.getLineData(line);
                if (lineData != null) {
                    this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                    this.mv.visitInsn(89);
                    this.mv.visitInsn(3);
                    this.mv.visitInsn(51);
                    Label skip = new Label();
                    this.mv.visitJumpInsn(154, skip);
                    this.mv.visitFieldInsn(178, TestTrackingArrayInstrumenter.this.myExtraClassDataFieldInstrumenter.getInternalClassName(), "__$classData$__", "Ljava/lang/Object;");
                    this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "registerClassForTrace", "(Ljava/lang/Object;)Z", false);
                    this.mv.visitJumpInsn(153, skip);
                    this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                    this.mv.visitInsn(3);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(84);
                    this.mv.visitLabel(skip);
                    InstrumentationUtils.pushInt(this.mv, line);
                    this.mv.visitInsn(4);
                    this.mv.visitInsn(84);
                }
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitFieldInsn(178, TestTrackingArrayInstrumenter.this.myExtraTraceMaskFieldInstrumenter.getInternalClassName(), TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_NAME, TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_TYPE);
                this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
                super.visitCode();
            }
        };
        MethodVisitor mv1 = this.myExtraClassDataFieldInstrumenter.createMethodVisitor(this, mv, visitor, name);
        return this.myExtraTraceMaskFieldInstrumenter.createMethodVisitor(this, mv, mv1, name);
    }

    public void visitEnd() {
        this.myExtraTraceMaskFieldInstrumenter.generateMembers(this);
        super.visitEnd();
    }

    protected void initLineData() {
        this.myClassData.createTraceMask(this.myMaxLineNumber + 1);
        super.initLineData();
    }

    private class ExtraTraceMaskFieldTestTrackingInstrumenter
    extends ExtraFieldInstrumenter {
        public ExtraTraceMaskFieldTestTrackingInstrumenter(ClassReader cr, String className) {
            super(cr, null, className, TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_NAME, TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_TYPE, true);
        }

        public void initField(MethodVisitor mv) {
            mv.visitLdcInsn(TestTrackingArrayInstrumenter.this.getClassName());
            mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "getTraceMask", "(Ljava/lang/String;)[Z", false);
            mv.visitFieldInsn(179, TestTrackingArrayInstrumenter.this.myExtraTraceMaskFieldInstrumenter.getInternalClassName(), TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_NAME, TestTrackingArrayInstrumenter.TRACE_MASK_FIELD_TYPE);
        }
    }
}

