/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.visiting;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.MethodVisitingFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import java.util.HashSet;
import org.jetbrains.coverage.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class DeprecatedMethodFilter
extends MethodVisitingFilter {
    private static final String DEPRECATED_METHODS = "DEPRECATED_METHODS_SET";
    private String myName;
    private boolean mySetIgnoreByMe;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void initFilter(MethodVisitor methodVisitor, Instrumenter context, String name, String desc) {
        String originalName;
        HashSet deprecatedMethods;
        Object property;
        super.initFilter(methodVisitor, context, name, desc);
        this.myName = name;
        if (name.endsWith("$default") && (property = this.myContext.getProperty(DEPRECATED_METHODS)) != null && (deprecatedMethods = (HashSet)property).contains(originalName = name.substring(0, name.length() - "$default".length()))) {
            this.myContext.setIgnoreSection(true);
            this.mySetIgnoreByMe = true;
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        AnnotationVisitor av = super.visitAnnotation(descriptor, visible);
        if (!"Lkotlin/Deprecated;".equals(descriptor)) {
            return av;
        }
        return new AnnotationVisitor(589824, av){

            public void visitEnum(String name, String descriptor, String value) {
                super.visitEnum(name, descriptor, value);
                if (!"Lkotlin/DeprecationLevel;".equals(descriptor)) {
                    return;
                }
                if ("ERROR".equals(value) || "HIDDEN".equals(value)) {
                    DeprecatedMethodFilter.this.myContext.setIgnoreSection(true);
                    DeprecatedMethodFilter.this.mySetIgnoreByMe = true;
                    HashSet property = DeprecatedMethodFilter.this.myContext.getProperty(DeprecatedMethodFilter.DEPRECATED_METHODS);
                    if (property == null) {
                        property = new HashSet();
                        DeprecatedMethodFilter.this.myContext.addProperty(DeprecatedMethodFilter.DEPRECATED_METHODS, property);
                    }
                    HashSet deprecatedMethods = property;
                    deprecatedMethods.add(DeprecatedMethodFilter.this.myName);
                }
            }
        };
    }

    public void visitEnd() {
        super.visitEnd();
        if (this.mySetIgnoreByMe) {
            this.myContext.setIgnoreSection(false);
        }
    }
}

