/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.classSignature;

import com.intellij.rt.coverage.instrumentation.filters.classSignature.ClassSignatureFilter;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;

public class KotlinFunctionOrPropertyReferenceFilter
implements ClassSignatureFilter {
    public boolean shouldFilter(ClassReader cr) {
        String superClass = cr.getSuperName();
        int access = cr.getAccess();
        return (access & 0x1000) != 0 && (access & 0x10) != 0 && cr.getClassName().contains("$") && (KotlinFunctionOrPropertyReferenceFilter.isFunctionReferenceClass(superClass) || KotlinFunctionOrPropertyReferenceFilter.isPropertyReferenceClass(superClass));
    }

    private static boolean isFunctionReferenceClass(String superClass) {
        return superClass != null && superClass.startsWith("kotlin/jvm/internal/FunctionReference");
    }

    private static boolean isPropertyReferenceClass(String superClass) {
        return superClass != null && (superClass.startsWith("kotlin/jvm/internal/PropertyReference") || superClass.startsWith("kotlin/jvm/internal/MutablePropertyReference"));
    }
}

