/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.JumpsAndSwitches;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.InstructionsUtil;
import com.intellij.rt.coverage.instrumentation.CoverageClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.SourceLineCounter;
import com.intellij.rt.coverage.instrumentation.filters.visiting.KotlinInlineVisitingFilter;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LinesUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.ProjectDataLoader;
import com.intellij.rt.coverage.util.ReportSectionsUtil;
import com.intellij.rt.coverage.util.StringsPool;
import com.intellij.rt.coverage.util.classFinder.ClassEntry;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.jetbrains.coverage.gnu.trove.TIntObjectHashMap;
import org.jetbrains.coverage.gnu.trove.TIntObjectProcedure;
import org.jetbrains.coverage.gnu.trove.TObjectIntHashMap;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveHook
implements Runnable {
    private final File myDataFile;
    private File mySourceMapFile;
    private final boolean myAppendUnloaded;
    private final ClassFinder myClassFinder;
    private final boolean myMergeFile;
    public static final MethodVisitor EMPTY_METHOD_VISITOR = new MethodVisitor(589824){};
    public static final ClassVisitor EMPTY_CLASS_VISITOR = new ClassVisitor(589824){

        public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
            return EMPTY_METHOD_VISITOR;
        }
    };

    public SaveHook(File dataFile, boolean appendUnloaded, ClassFinder classFinder, boolean mergeFile) {
        this.myDataFile = dataFile;
        this.myAppendUnloaded = appendUnloaded;
        this.myClassFinder = classFinder;
        this.myMergeFile = mergeFile;
    }

    @Override
    public void run() {
        this.save(ProjectData.getProjectData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void save(ProjectData projectData) {
        projectData.stop();
        CoverageIOUtil.FileLock lock = null;
        try {
            projectData.applyLinesMask();
            projectData.applyBranchData();
            if (this.myAppendUnloaded) {
                boolean calculateSource;
                boolean bl = calculateSource = this.mySourceMapFile != null;
                if (OptionsUtil.UNLOADED_CLASSES_FULL_ANALYSIS) {
                    SaveHook.appendUnloadedFullAnalysis(projectData, this.myClassFinder, calculateSource, projectData.isSampling(), OptionsUtil.IGNORE_PRIVATE_CONSTRUCTOR_OF_UTIL_CLASS, false);
                } else {
                    SaveHook.appendUnloaded(projectData, this.myClassFinder, calculateSource, projectData.isSampling());
                }
            }
            projectData.checkLineMappings();
            this.dropIgnoredLines(projectData);
            this.checkLineSignatures(projectData);
            lock = CoverageIOUtil.FileLock.lock(this.myDataFile);
            if (this.myMergeFile) {
                ProjectData load = ProjectDataLoader.load(this.myDataFile);
                projectData.merge(load);
            }
            SaveHook.save(projectData, this.myDataFile, this.mySourceMapFile);
            CoverageIOUtil.FileLock.unlock(lock);
        }
        catch (OutOfMemoryError e) {
            ErrorReporter.reportError("Out of memory error occurred, try to increase memory available for the JVM, or make include / exclude patterns more specific", e);
        }
        catch (Throwable e2) {
            ErrorReporter.reportError("Unexpected error", e2);
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            CoverageIOUtil.FileLock.unlock(lock);
        }
        finally {
            CoverageIOUtil.FileLock.unlock(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save(ProjectData projectData, File dataFile, File sourceMapFile) {
        DataOutputStream os = null;
        try {
            os = CoverageIOUtil.openFile(dataFile);
            TObjectIntHashMap<String> dict = new TObjectIntHashMap<String>();
            HashMap<String, ClassData> classes = new HashMap<String, ClassData>(projectData.getClasses());
            CoverageIOUtil.writeINT(os, classes.size());
            SaveHook.saveDictionary(os, dict, classes);
            SaveHook.saveData(os, dict, classes);
            CoverageIOUtil.writeINT(os, 1);
            CoverageIOUtil.writeUTF(os, SaveHook.getExtraInfoString());
            ReportSectionsUtil.saveSections(projectData, os, dict);
            SaveHook.saveSourceMap(classes, sourceMapFile);
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing file " + dataFile.getPath(), e);
        }
        finally {
            CoverageIOUtil.close(os);
        }
    }

    private static String getExtraInfoString() {
        return "";
    }

    public static void saveSourceMap(Map<String, ClassData> classes, File sourceMapFile) {
        if (sourceMapFile == null) {
            return;
        }
        Map<String, String> readNames = Collections.emptyMap();
        try {
            if (sourceMapFile.exists()) {
                readNames = SaveHook.loadSourceMapFromFile(classes, sourceMapFile);
            }
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error loading source map from " + sourceMapFile.getPath(), e);
        }
        try {
            SaveHook.doSaveSourceMap(readNames, sourceMapFile, classes);
        }
        catch (IOException e) {
            ErrorReporter.reportError("Error writing source map " + sourceMapFile.getPath(), e);
        }
    }

    public static void loadAndApplySourceMap(ProjectData projectData, File sourceMapFile) throws IOException {
        Map<String, String> map = SaveHook.loadSourceMapFromFile(new HashMap<String, ClassData>(), sourceMapFile);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String className = entry.getKey();
            String source = entry.getValue();
            ClassData data = projectData.getClassData(className);
            if (data == null) continue;
            data.setSource(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> loadSourceMapFromFile(Map<String, ClassData> classes, File sourceMapFile) throws IOException {
        HashMap<String, String> hashMap;
        DataInputStream in = null;
        try {
            in = new DataInputStream(new FileInputStream(sourceMapFile));
            int classNumber = CoverageIOUtil.readINT(in);
            HashMap<String, String> readNames = new HashMap<String, String>(classNumber);
            for (int i = 0; i < classNumber; ++i) {
                ClassData data;
                String className = CoverageIOUtil.readUTFFast(in);
                String classSource = CoverageIOUtil.readUTFFast(in);
                if ("".equals(classSource) || (data = classes.get(className)) != null && data.getSource() != null && data.getSource().equals(classSource)) continue;
                readNames.put(className, classSource);
            }
            hashMap = readNames;
        }
        catch (Throwable throwable) {
            CoverageIOUtil.close(in);
            throw throwable;
        }
        CoverageIOUtil.close(in);
        return hashMap;
    }

    private static void saveData(DataOutputStream os, final TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        for (ClassData o : classes.values()) {
            o.save(os, new DictionaryLookup(){

                public int getDictionaryIndex(String className) {
                    return dict.containsKey(className) ? dict.get(className) : -1;
                }
            });
        }
    }

    private static void saveDictionary(DataOutputStream os, TObjectIntHashMap<String> dict, Map<String, ClassData> classes) throws IOException {
        int i = 0;
        for (String className : classes.keySet()) {
            dict.put(className, i++);
            CoverageIOUtil.writeUTF(os, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveSourceMap(Map<String, String> classNameToFile, File sourceMapFile, Map<String, ClassData> classes) throws IOException {
        HashMap<String, String> sources = new HashMap<String, String>(classNameToFile);
        for (ClassData classData : classes.values()) {
            if (sources.containsKey(classData.getName())) continue;
            sources.put(classData.getName(), classData.getSource());
        }
        DataOutputStream out = null;
        try {
            out = CoverageIOUtil.openFile(sourceMapFile);
            CoverageIOUtil.writeINT(out, sources.size());
            for (Map.Entry<String, String> entry : sources.entrySet()) {
                CoverageIOUtil.writeUTF(out, entry.getKey());
                String value = entry.getValue();
                CoverageIOUtil.writeUTF(out, value != null ? value : "");
            }
        }
        finally {
            CoverageIOUtil.close(out);
        }
    }

    public static void appendUnloaded(final ProjectData projectData, ClassFinder classFinder, final boolean calculateSource, final boolean isSampling) {
        classFinder.iterateMatchedClasses(new ClassEntry.Consumer(){

            public void consume(ClassEntry classEntry) {
                ClassData cd = projectData.getClassData(StringsPool.getFromPool(classEntry.getClassName()));
                if (cd != null && cd.getLines() != null) {
                    return;
                }
                try {
                    InputStream classInputStream = classEntry.getClassInputStream();
                    if (classInputStream == null) {
                        return;
                    }
                    ClassReader reader = new ClassReader(classInputStream);
                    if (calculateSource) {
                        cd = projectData.getOrCreateClassData(StringsPool.getFromPool(classEntry.getClassName()));
                    }
                    SourceLineCounter slc = new SourceLineCounter(cd, calculateSource ? projectData : null, !isSampling);
                    reader.accept(slc, 4);
                    if (slc.isEnum() || slc.getNSourceLines() > 0) {
                        final TIntObjectHashMap lines = new TIntObjectHashMap(4, 0.99f);
                        final int[] maxLine = new int[]{-1};
                        final ClassData classData = projectData.getOrCreateClassData(StringsPool.getFromPool(classEntry.getClassName()));
                        slc.getSourceLines().forEachEntry(new TIntObjectProcedure<String>(){

                            @Override
                            public boolean execute(int line, String methodSig) {
                                LineData ld = new LineData(line, StringsPool.getFromPool(methodSig));
                                lines.put(line, ld);
                                if (line > maxLine[0]) {
                                    maxLine[0] = line;
                                }
                                classData.registerMethodSignature(ld);
                                ld.setStatus((byte)0);
                                return true;
                            }
                        });
                        TIntObjectHashMap<JumpsAndSwitches> jumpsPerLine = slc.getJumpsPerLine();
                        if (jumpsPerLine != null) {
                            jumpsPerLine.forEachEntry(new TIntObjectProcedure<JumpsAndSwitches>(){

                                @Override
                                public boolean execute(int line, JumpsAndSwitches jumpData) {
                                    LineData lineData = (LineData)lines.get(line);
                                    if (lineData != null) {
                                        lineData.setJumpsAndSwitches(jumpData);
                                        lineData.fillArrays();
                                    }
                                    return true;
                                }
                            });
                        }
                        classData.setLines(LinesUtil.calcLineArray(maxLine[0], lines));
                    }
                }
                catch (Throwable e) {
                    ErrorReporter.reportError("Failed to process unloaded class: " + classEntry.getClassName() + ", error: " + e.getMessage(), e);
                }
            }
        });
    }

    public static void appendUnloadedFullAnalysis(ProjectData projectData, ClassFinder classFinder, boolean calculateSource, boolean isSampling, boolean ignorePrivateConstructorOfUtilClass) {
        SaveHook.appendUnloadedFullAnalysis(projectData, classFinder, calculateSource, isSampling, ignorePrivateConstructorOfUtilClass, true);
    }

    public static void appendUnloadedFullAnalysis(final ProjectData projectData, ClassFinder classFinder, final boolean calculateSource, final boolean isSampling, final boolean ignorePrivateConstructorOfUtilClass, final boolean checkLineMappings) {
        classFinder.iterateMatchedClasses(new ClassEntry.Consumer(){

            public void consume(ClassEntry classEntry) {
                ClassData cd = projectData.getClassData(StringsPool.getFromPool(classEntry.getClassName()));
                if (cd != null && cd.getLines() != null && cd.isFullyAnalysed()) {
                    return;
                }
                try {
                    InputStream is = classEntry.getClassInputStream();
                    if (is == null) {
                        return;
                    }
                    SaveHook.appendUnloadedClass(projectData, classEntry.getClassName(), new ClassReader(is), isSampling, calculateSource, ignorePrivateConstructorOfUtilClass, checkLineMappings);
                }
                catch (Throwable e) {
                    ErrorReporter.reportError("Failed to process unloaded class: " + classEntry.getClassName() + ", error: " + e.getMessage(), e);
                }
            }
        });
    }

    public static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, boolean isSampling, boolean calculateSource, boolean ignorePrivateConstructorOfUtilClass) {
        SaveHook.appendUnloadedClass(projectData, className, reader, isSampling, calculateSource, ignorePrivateConstructorOfUtilClass, true);
    }

    private static void appendUnloadedClass(ProjectData projectData, String className, ClassReader reader, boolean isSampling, boolean calculateSource, boolean ignorePrivateConstructorOfUtilClass, boolean checkLineMappings) {
        LineData[] lines;
        ClassVisitor visitor = CoverageClassfileTransformer.createInstrumenter(projectData, className, reader, EMPTY_CLASS_VISITOR, null, isSampling, calculateSource, ignorePrivateConstructorOfUtilClass);
        if (visitor == null) {
            return;
        }
        reader.accept(visitor, 4);
        ClassData classData = projectData.getClassData(className);
        if (classData == null || classData.getLines() == null) {
            return;
        }
        classData.dropIgnoredLines();
        for (LineData line : lines = (LineData[])classData.getLines()) {
            if (line == null) continue;
            classData.registerMethodSignature(line);
        }
        if (!checkLineMappings) {
            return;
        }
        Map<String, FileMapData[]> linesMap = projectData.getLinesMap();
        if (linesMap == null) {
            return;
        }
        FileMapData[] mappings = linesMap.remove(className);
        if (mappings == null) {
            return;
        }
        classData.dropMappedLines(mappings);
        InstructionsUtil.dropMappedLines(projectData, classData.getName(), mappings);
    }

    public void setSourceMapFile(File sourceMapFile) {
        this.mySourceMapFile = sourceMapFile;
    }

    private void checkLineSignatures(ProjectData projectData) {
        if (!KotlinInlineVisitingFilter.shouldCheckLineSignatures()) {
            return;
        }
        Map<String, FileMapData[]> linesMap = projectData.getLinesMap();
        if (linesMap == null) {
            return;
        }
        HashSet<String> classes = new HashSet<String>();
        for (Map.Entry<String, FileMapData[]> mapData : linesMap.entrySet()) {
            if (mapData.getValue() == null) continue;
            for (FileMapData data : mapData.getValue()) {
                if (data == null || mapData.getKey().equals(data.getClassName())) continue;
                classes.add(data.getClassName());
            }
        }
        for (String className : classes) {
            ClassData classData = projectData.getClassData(className);
            if (classData == null) continue;
            KotlinInlineVisitingFilter.checkLineSignatures(classData, this.myClassFinder);
        }
    }

    private void dropIgnoredLines(ProjectData projectData) {
        for (ClassData classData : projectData.getClassesCollection()) {
            classData.dropIgnoredLines();
        }
    }
}

