/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LocalVariableInserter;
import com.intellij.rt.coverage.util.LinesUtil;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class SamplingInstrumenter
extends Instrumenter {
    private static final String CLASS_DATA_LOCAL_VARIABLE_NAME = "__class__data__";

    public SamplingInstrumenter(ProjectData projectData, ClassVisitor classVisitor, String className, boolean shouldCalculateSource) {
        super(projectData, classVisitor, className, shouldCalculateSource);
    }

    protected MethodVisitor createMethodLineEnumerator(MethodVisitor mv, final String name, final String desc, int access, String signature, String[] exceptions) {
        return new LocalVariableInserter(mv, access, desc, CLASS_DATA_LOCAL_VARIABLE_NAME, "Ljava/lang/Object;"){

            public void visitLineNumber(int line, Label start) {
                SamplingInstrumenter.this.getOrCreateLineData(line, name, desc);
                this.mv.visitVarInsn(25, this.getOrCreateLocalVariableIndex());
                InstrumentationUtils.pushInt(this.mv, line);
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "touchLine", "(Ljava/lang/Object;I)V", false);
                super.visitLineNumber(line, start);
            }

            public void visitCode() {
                this.mv.visitLdcInsn(SamplingInstrumenter.this.getClassName());
                this.mv.visitMethodInsn(184, "com/intellij/rt/coverage/data/ProjectData", "loadClassData", "(Ljava/lang/String;)Ljava/lang/Object;", false);
                this.mv.visitVarInsn(58, this.getOrCreateLocalVariableIndex());
                super.visitCode();
            }
        };
    }

    protected void initLineData() {
        LineData[] lines = LinesUtil.calcLineArray(this.myMaxLineNumber, this.myLines);
        this.myClassData.initLineMask(lines);
        this.myClassData.setLines(lines);
    }
}

