/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation;

import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.instrumentation.AbstractIntellijClassfileTransformer;
import com.intellij.rt.coverage.instrumentation.CondySamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.CondyTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.InstrumentationUtils;
import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.NewSamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.NewTracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.SamplingInstrumenter;
import com.intellij.rt.coverage.instrumentation.TracingInstrumenter;
import com.intellij.rt.coverage.instrumentation.filters.FilterUtils;
import com.intellij.rt.coverage.instrumentation.filters.classFilter.PrivateConstructorOfUtilClassFilter;
import com.intellij.rt.coverage.instrumentation.filters.classSignature.ClassSignatureFilter;
import com.intellij.rt.coverage.instrumentation.testTracking.TestTrackingMode;
import com.intellij.rt.coverage.util.ClassNameUtil;
import com.intellij.rt.coverage.util.OptionsUtil;
import com.intellij.rt.coverage.util.classFinder.ClassFinder;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.coverage.org.objectweb.asm.ClassReader;
import org.jetbrains.coverage.org.objectweb.asm.ClassVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoverageClassfileTransformer
extends AbstractIntellijClassfileTransformer {
    private static final List<ClassSignatureFilter> ourFilters = FilterUtils.createClassSignatureFilters();
    private final ProjectData data;
    private final boolean shouldCalculateSource;
    private final List<Pattern> excludePatterns;
    private final List<Pattern> includePatterns;
    private final ClassFinder cf;
    private final TestTrackingMode testTrackingMode;

    public CoverageClassfileTransformer(ProjectData data, boolean shouldCalculateSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf) {
        this(data, shouldCalculateSource, excludePatterns, includePatterns, cf, null);
    }

    public CoverageClassfileTransformer(ProjectData data, boolean shouldCalculateSource, List<Pattern> excludePatterns, List<Pattern> includePatterns, ClassFinder cf, TestTrackingMode testTrackingMode) {
        this.data = data;
        this.shouldCalculateSource = shouldCalculateSource;
        this.excludePatterns = excludePatterns;
        this.includePatterns = includePatterns;
        this.cf = cf;
        this.testTrackingMode = testTrackingMode;
    }

    @Override
    protected ClassVisitor createClassVisitor(String className, ClassLoader loader, ClassReader cr, ClassVisitor cw) {
        return CoverageClassfileTransformer.createInstrumenter(this.data, className, cr, cw, this.testTrackingMode, this.data.isSampling(), this.shouldCalculateSource, OptionsUtil.IGNORE_PRIVATE_CONSTRUCTOR_OF_UTIL_CLASS);
    }

    static ClassVisitor createInstrumenter(ProjectData data, String className, ClassReader cr, ClassVisitor cw, TestTrackingMode testTrackingMode, boolean isSampling, boolean shouldCalculateSource, boolean shouldIgnorePrivateConstructorOfUtilCLass) {
        for (ClassSignatureFilter filter : ourFilters) {
            if (!filter.shouldFilter(cr)) continue;
            return null;
        }
        Instrumenter instrumenter = isSampling ? (OptionsUtil.NEW_SAMPLING_ENABLED ? (OptionsUtil.CONDY_ENABLED && InstrumentationUtils.getBytecodeVersion(cr) >= 55 ? new CondySamplingInstrumenter(data, cw, className, shouldCalculateSource) : new NewSamplingInstrumenter(data, cw, cr, className, shouldCalculateSource)) : new SamplingInstrumenter(data, cw, className, shouldCalculateSource)) : (OptionsUtil.NEW_TRACING_ENABLED ? (data.isTestTracking() && testTrackingMode != null ? testTrackingMode.createInstrumenter(data, cw, cr, className, shouldCalculateSource) : (OptionsUtil.CONDY_ENABLED && InstrumentationUtils.getBytecodeVersion(cr) >= 55 ? new CondyTracingInstrumenter(data, cw, className, shouldCalculateSource) : new NewTracingInstrumenter(data, cw, cr, className, shouldCalculateSource))) : new TracingInstrumenter(data, cw, className, shouldCalculateSource));
        ClassVisitor result = instrumenter;
        if (shouldIgnorePrivateConstructorOfUtilCLass) {
            result = PrivateConstructorOfUtilClassFilter.createWithContext(result, instrumenter);
        }
        return result;
    }

    @Override
    protected boolean shouldExclude(String className) {
        return ClassNameUtil.matchesPatterns(className, this.excludePatterns);
    }

    @Override
    protected AbstractIntellijClassfileTransformer.InclusionPattern getInclusionPattern() {
        return this.includePatterns.isEmpty() ? null : new AbstractIntellijClassfileTransformer.InclusionPattern(){

            public boolean accept(String className) {
                return ClassNameUtil.matchesPatterns(className, CoverageClassfileTransformer.this.includePatterns);
            }
        };
    }

    @Override
    protected void visitClassLoader(ClassLoader classLoader) {
        this.cf.addClassLoader(classLoader);
    }

    @Override
    protected boolean isStopped() {
        return this.data.isStopped();
    }
}

