/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data.instructions;

import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.rt.coverage.data.instructions.ClassInstructions;
import com.intellij.rt.coverage.data.instructions.LineInstructions;
import com.intellij.rt.coverage.util.LineMapper;
import com.intellij.rt.coverage.util.classFinder.ClassFilter;
import java.util.Map;

public class InstructionsUtil {
    public static void merge(ProjectData source, ProjectData target, ClassFilter classFilter) {
        if (!target.isInstructionsCoverageEnabled()) {
            return;
        }
        Map<String, ClassInstructions> instructions = target.getInstructions();
        for (Map.Entry<String, ClassInstructions> entry : source.getInstructions().entrySet()) {
            ClassData classData;
            String className = entry.getKey();
            if (classFilter != null && !classFilter.shouldInclude(className) || (classData = target.getClassData(className)) == null) continue;
            ClassInstructions mergedInstructions = entry.getValue();
            ClassInstructions classInstructions = instructions.get(className);
            if (classInstructions == null) {
                classInstructions = new ClassInstructions();
                instructions.put(className, classInstructions);
            }
            classInstructions.merge(mergedInstructions, classData);
        }
    }

    public static void applyInstructionsSMAP(ProjectData projectData, LineMapData[] linesMap, ClassData sourceClass, ClassData targetClass) {
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        InstructionsLineMapper mapper = new InstructionsLineMapper(projectData);
        LineInstructions[] lines = (LineInstructions[])mapper.mapLines(linesMap, sourceClass, targetClass);
        projectData.getInstructions().put(sourceClass.getName(), new ClassInstructions(lines));
    }

    public static void dropMappedLines(ProjectData projectData, String className, FileMapData[] mappings) {
        if (!projectData.isInstructionsCoverageEnabled()) {
            return;
        }
        ClassInstructions classInstructions = projectData.getInstructions().get(className);
        LineInstructions[] instructions = classInstructions.getlines();
        LineMapper.dropMappedLines(mappings, instructions, className);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InstructionsLineMapper
    extends LineMapper<LineInstructions> {
        private final ProjectData projectData;

        public InstructionsLineMapper(ProjectData projectData) {
            this.projectData = projectData;
        }

        @Override
        protected LineInstructions createNewLine(LineInstructions targetLine, LineMapData mapData) {
            return new LineInstructions();
        }

        protected LineInstructions[] createArray(int size) {
            return new LineInstructions[size];
        }

        protected LineInstructions[] getLines(ClassData classData) {
            ClassInstructions classInstructions = this.projectData.getInstructions().get(classData.getName());
            if (classInstructions == null) {
                return null;
            }
            return classInstructions.getlines();
        }
    }
}

