/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import java.io.DataOutputStream;
import java.io.IOException;

public class JumpData
implements CoverageData {
    private int myTrueHits;
    private int myFalseHits;
    private int myTrueId = -1;
    private int myFalseId = -1;

    public void touchTrueHit() {
        ++this.myTrueHits;
    }

    public void touchFalseHit() {
        ++this.myFalseHits;
    }

    public int getTrueHits() {
        return this.myTrueHits;
    }

    public int getFalseHits() {
        return this.myFalseHits;
    }

    public void save(DataOutputStream os) throws IOException {
        CoverageIOUtil.writeINT(os, this.myTrueHits);
        CoverageIOUtil.writeINT(os, this.myFalseHits);
    }

    public void merge(CoverageData data) {
        JumpData jumpData = (JumpData)data;
        this.myTrueHits += jumpData.myTrueHits;
        this.myFalseHits += jumpData.myFalseHits;
    }

    public void setTrueHits(int trueHits) {
        this.myTrueHits = trueHits;
    }

    public void setFalseHits(int falseHits) {
        this.myFalseHits = falseHits;
    }

    public int getId(boolean type) {
        return type ? this.myTrueId : this.myFalseId;
    }

    public void setId(int id, boolean type) {
        if (type) {
            this.myTrueId = id;
        } else {
            this.myFalseId = id;
        }
    }
}

