/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.data;

import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.FileMapData;
import com.intellij.rt.coverage.data.JumpData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.LineMapData;
import com.intellij.rt.coverage.data.SwitchData;
import com.intellij.rt.coverage.util.ArrayUtil;
import com.intellij.rt.coverage.util.CoverageIOUtil;
import com.intellij.rt.coverage.util.DictionaryLookup;
import com.intellij.rt.coverage.util.ErrorReporter;
import com.intellij.rt.coverage.util.LineMapper;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.coverage.gnu.trove.TIntHashSet;
import org.jetbrains.coverage.gnu.trove.TIntProcedure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData
implements CoverageData {
    private final String myClassName;
    private LineData[] myLinesArray;
    private Map<String, Integer> myStatus;
    private int[] myLineMask;
    private String mySource;
    private volatile int[] myHitsMask;
    private volatile boolean[] myTraceMask;
    private TIntHashSet myIgnoredLines;
    private boolean myFullyAnalysed = false;

    public ClassData(String name) {
        this.myClassName = name;
    }

    public String getName() {
        return this.myClassName;
    }

    public void save(DataOutputStream os, DictionaryLookup dictionaryLookup) throws IOException {
        CoverageIOUtil.writeINT(os, dictionaryLookup.getDictionaryIndex(this.myClassName));
        Map<String, List<LineData>> sigLines = this.prepareSignaturesMap(dictionaryLookup, true);
        Set<String> sigs = sigLines.keySet();
        CoverageIOUtil.writeINT(os, sigs.size());
        for (String sig1 : sigs) {
            CoverageIOUtil.writeUTF(os, sig1);
            List<LineData> lines = sigLines.get(sig1);
            CoverageIOUtil.writeINT(os, lines.size());
            for (LineData line : lines) {
                line.save(os);
            }
        }
    }

    private Map<String, List<LineData>> prepareSignaturesMap(DictionaryLookup dictionaryLookup, boolean collapseSignatures) {
        HashMap<String, List<LineData>> sigLines = new HashMap<String, List<LineData>>();
        if (this.myLinesArray == null) {
            return sigLines;
        }
        for (LineData lineData : this.myLinesArray) {
            if (lineData == null) continue;
            String methodSignature = lineData.getMethodSignature();
            String sig = collapseSignatures ? CoverageIOUtil.collapse(methodSignature, dictionaryLookup) : methodSignature;
            ArrayList<LineData> lines = (ArrayList<LineData>)sigLines.get(sig);
            if (lines == null) {
                lines = new ArrayList<LineData>();
                sigLines.put(sig, lines);
            }
            lines.add(lineData);
        }
        return sigLines;
    }

    public Map<String, List<LineData>> mapLinesToMethods() {
        return this.prepareSignaturesMap(null, false);
    }

    @Override
    public void merge(CoverageData data) {
        ClassData classData = (ClassData)data;
        this.mergeLines(classData.myLinesArray);
        for (String o : this.getMethodSigs()) {
            this.myStatus.put(o, null);
        }
        if (this.mySource == null && classData.mySource != null) {
            this.mySource = classData.mySource;
        }
        if (!this.isFullyAnalysed() && classData.isFullyAnalysed()) {
            this.setFullyAnalysed(true);
        }
    }

    private void mergeLines(LineData[] dLines) {
        if (dLines == null) {
            return;
        }
        if (this.myLinesArray == null || this.myLinesArray.length < dLines.length) {
            LineData[] lines = new LineData[dLines.length];
            if (this.myLinesArray != null) {
                System.arraycopy(this.myLinesArray, 0, lines, 0, this.myLinesArray.length);
            }
            this.myLinesArray = lines;
        }
        for (int i = 0; i < dLines.length; ++i) {
            LineData mergedData = dLines[i];
            if (mergedData == null) continue;
            LineData lineData = this.myLinesArray[i];
            if (lineData == null) {
                if (this.isIgnoredLine(i)) continue;
                lineData = new LineData(mergedData.getLineNumber(), mergedData.getMethodSignature());
                this.registerMethodSignature(lineData);
                this.myLinesArray[i] = lineData;
            }
            lineData.merge(mergedData);
        }
    }

    public void touchLine(int line) {
        int n = line;
        this.myLineMask[n] = this.myLineMask[n] + 1;
    }

    public void touch(int line) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touch();
        }
    }

    public void touch(int line, int jump, boolean hit) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touchBranch(jump, hit);
        }
    }

    public void touch(int line, int switchNumber, int key) {
        LineData lineData = this.getLineData(line);
        if (lineData != null) {
            lineData.touchBranch(switchNumber, key);
        }
    }

    public void registerMethodSignature(LineData lineData) {
        this.initStatusMap();
        this.myStatus.put(lineData.getMethodSignature(), null);
    }

    public LineData getLineData(int line) {
        return this.myLinesArray[line];
    }

    public Object[] getLines() {
        return this.myLinesArray;
    }

    public boolean containsLine(int line) {
        return this.myLinesArray[line] != null;
    }

    public Collection<String> getMethodSigs() {
        this.initStatusMap();
        return this.myStatus.keySet();
    }

    private void initStatusMap() {
        if (this.myStatus == null) {
            this.myStatus = new HashMap<String, Integer>();
        }
    }

    public Integer getStatus(String methodSignature) {
        if (this.myStatus == null) {
            return null;
        }
        Integer methodStatus = this.myStatus.get(methodSignature);
        if (methodStatus == null) {
            for (LineData lineData : this.myLinesArray) {
                if (lineData == null || !methodSignature.equals(lineData.getMethodSignature()) || lineData.getStatus() == 0) continue;
                methodStatus = 1;
                break;
            }
            if (methodStatus == null) {
                methodStatus = 0;
            }
            this.myStatus.put(methodSignature, methodStatus);
        }
        return methodStatus;
    }

    public String toString() {
        return this.myClassName;
    }

    public void initLineMask(LineData[] lines) {
        block4: {
            block3: {
                if (this.myLineMask != null) break block3;
                this.myLineMask = new int[this.myLinesArray != null ? Math.max(lines.length, this.myLinesArray.length) : lines.length];
                if (this.myLinesArray == null) break block4;
                for (int i = 0; i < this.myLinesArray.length; ++i) {
                    LineData data = this.myLinesArray[i];
                    if (data == null) continue;
                    this.myLineMask[i] = data.getHits();
                }
                break block4;
            }
            if (this.myLineMask.length < lines.length) {
                int[] lineMask = new int[lines.length];
                System.arraycopy(this.myLineMask, 0, lineMask, 0, this.myLineMask.length);
                this.myLineMask = lineMask;
            }
            for (int i = 0; i < lines.length; ++i) {
                if (lines[i] == null) continue;
                int n = i;
                this.myLineMask[n] = this.myLineMask[n] + lines[i].getHits();
            }
        }
    }

    public void setLines(LineData[] lines) {
        if (this.myLinesArray == null) {
            this.myLinesArray = lines;
        } else if (this.isFullyAnalysed()) {
            this.mergeLines(lines);
        } else {
            LineData[] incompleteData = this.myLinesArray;
            this.myLinesArray = null;
            this.myStatus = null;
            this.mergeLines(lines);
            this.mergeLines(incompleteData);
        }
        this.setFullyAnalysed(true);
    }

    public static void checkLineMappings(LineMapData[] linesMap, ClassData sourceClassData, ClassData targetClassData) {
        sourceClassData.myLinesArray = (LineData[])new BasicLineMapper().mapLines(linesMap, sourceClassData, targetClassData);
    }

    public void dropMappedLines(FileMapData[] mappings) {
        LineMapper.dropMappedLines(mappings, this.myLinesArray, this.myClassName);
    }

    public void setSource(String source) {
        this.mySource = source;
    }

    public String getSource() {
        return this.mySource;
    }

    public boolean isFullyAnalysed() {
        return this.myFullyAnalysed;
    }

    public void setFullyAnalysed(boolean value) {
        this.myFullyAnalysed = value;
    }

    public synchronized void createHitsMask(int size) {
        if (this.myHitsMask != null && this.myHitsMask.length >= size) {
            return;
        }
        int[] newMask = new int[size];
        if (this.myHitsMask != null) {
            System.arraycopy(newMask, 0, this.myHitsMask, 0, this.myHitsMask.length);
        }
        this.myHitsMask = newMask;
    }

    public synchronized void createTraceMask(int size) {
        if (this.myTraceMask != null && this.myTraceMask.length >= size) {
            return;
        }
        boolean[] newMask = new boolean[size];
        if (this.myTraceMask != null) {
            System.arraycopy(newMask, 0, this.myTraceMask, 0, this.myTraceMask.length);
        }
        this.myTraceMask = newMask;
    }

    public int[] getLineMask() {
        return this.myLineMask;
    }

    public int[] getHitsMask() {
        return this.myHitsMask;
    }

    public boolean[] getTraceMask() {
        return this.myTraceMask;
    }

    public void setTraceMask(boolean[] traceMask) {
        this.myTraceMask = traceMask;
    }

    public void applyLinesMask() {
        if (this.myLineMask == null) {
            return;
        }
        int size = this.myLineMask.length;
        for (LineData lineData : this.myLinesArray) {
            if (lineData == null || lineData.getLineNumber() >= size) continue;
            lineData.setHits(this.myLineMask[lineData.getLineNumber()]);
        }
    }

    public void applyBranches() {
        if (this.myHitsMask == null) {
            return;
        }
        try {
            for (LineData lineData : this.myLinesArray) {
                SwitchData[] switches;
                JumpData[] jumps;
                if (lineData == null) continue;
                int lineId = lineData.getId();
                if (lineId != -1) {
                    lineData.setHits(this.myHitsMask[lineId]);
                }
                if ((jumps = lineData.getJumps()) != null) {
                    for (JumpData jumpData : jumps) {
                        int falseId;
                        if (jumpData == null) continue;
                        int trueId = jumpData.getId(true);
                        if (trueId != -1) {
                            jumpData.setTrueHits(jumpData.getTrueHits() + this.myHitsMask[trueId]);
                        }
                        if ((falseId = jumpData.getId(false)) == -1) continue;
                        jumpData.setFalseHits(jumpData.getFalseHits() + this.myHitsMask[falseId]);
                    }
                }
                if ((switches = lineData.getSwitches()) == null) continue;
                for (SwitchData switchData : switches) {
                    if (switchData == null) continue;
                    int defaultId = switchData.getId(-1);
                    if (defaultId != -1) {
                        switchData.setDefaultHits(switchData.getDefaultHits() + this.myHitsMask[defaultId]);
                    }
                    int[] keys = switchData.getKeys();
                    int[] hits = switchData.getHits();
                    for (int i = 0; i < hits.length; ++i) {
                        int caseId = switchData.getId(i);
                        if (caseId == -1) continue;
                        int n = i;
                        hits[n] = hits[n] + this.myHitsMask[caseId];
                    }
                    switchData.setKeysAndHits(keys, hits);
                }
            }
        }
        catch (Throwable e) {
            ErrorReporter.reportError("Unexpected error during applying branch data to class " + this.getName(), e);
        }
    }

    public void dropIgnoredLines() {
        if (this.myIgnoredLines == null) {
            return;
        }
        this.myIgnoredLines.forEach(new TIntProcedure(){

            public boolean execute(int line) {
                ArrayUtil.safeStore(ClassData.this.myLinesArray, line, null);
                return true;
            }
        });
    }

    public void setIgnoredLines(TIntHashSet ignoredLines) {
        if (ignoredLines != null && !ignoredLines.isEmpty()) {
            this.myIgnoredLines = ignoredLines;
        }
    }

    public boolean isIgnoredLine(int line) {
        return this.myIgnoredLines != null && this.myIgnoredLines.contains(line);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class BasicLineMapper
    extends LineMapper<LineData> {
        private BasicLineMapper() {
        }

        @Override
        protected LineData createNewLine(LineData targetLine, LineMapData mapData) {
            return new LineData(mapData.getSourceLineNumber(), targetLine.getMethodSignature());
        }

        protected LineData[] createArray(int size) {
            return new LineData[size];
        }

        protected LineData[] getLines(ClassData classData) {
            return classData.myLinesArray;
        }
    }
}

