/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.codeHighlighting.HighlightingPass;
import com.intellij.codeInsight.daemon.impl.DefaultHighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.TextEditorHighlightingPassRegistrarEx;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.BooleanTableCellEditor;
import com.intellij.ui.UserActivityListener;
import com.intellij.ui.UserActivityWatcher;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ClassMap;
import com.intellij.util.ui.JBUI;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementsErrorPanel;
import com.intellij.util.xml.ui.BaseControl;
import com.intellij.util.xml.ui.CaptionComponent;
import com.intellij.util.xml.ui.ComboTableCellEditor;
import com.intellij.util.xml.ui.Committable;
import com.intellij.util.xml.ui.CommittablePanel;
import com.intellij.util.xml.ui.CommittableUtil;
import com.intellij.util.xml.ui.DomUIFactory;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import com.intellij.util.xml.ui.TextControl;
import java.awt.Component;
import java.lang.reflect.Type;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomUIFactoryImpl
extends DomUIFactory {
    private final ClassMap<Function<DomWrapper<String>, BaseControl>> myCustomControlCreators = new ClassMap();
    private final ClassMap<Function<DomElement, TableCellEditor>> myCustomCellEditorCreators = new ClassMap();

    public DomUIFactoryImpl() {
        Function booleanCreator = domElement -> new BooleanTableCellEditor();
        this.registerCustomCellEditor(Boolean.class, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(Boolean.TYPE, (Function<DomElement, TableCellEditor>)booleanCreator);
        this.registerCustomCellEditor(String.class, (Function<DomElement, TableCellEditor>)((Function)domElement -> new DefaultCellEditor(DomUIFactoryImpl.removeBorder(new JTextField()))));
        for (Consumer extension : EXTENSION_POINT_NAME.getExtensionList()) {
            extension.consume((Object)this);
        }
    }

    protected TableCellEditor createCellEditor(DomElement element, Class type) {
        if (Enum.class.isAssignableFrom(type)) {
            return new ComboTableCellEditor(type, false);
        }
        Function function = (Function)this.myCustomCellEditorCreators.get(type);
        assert (function != null) : "Type not supported: " + type;
        return (TableCellEditor)function.fun((Object)element);
    }

    public final UserActivityWatcher createEditorAwareUserActivityWatcher() {
        return new UserActivityWatcher(){
            private final DocumentListener myListener = new DocumentListener(){

                public void documentChanged(@NotNull DocumentEvent e) {
                    this.fireUIChanged();
                }
            };

            protected void processComponent(Component component) {
                super.processComponent(component);
                if (component instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component).getEditor().getDocument().addDocumentListener(this.myListener);
                }
            }

            protected void unprocessComponent(Component component) {
                super.unprocessComponent(component);
                if (component instanceof EditorComponentImpl) {
                    ((EditorComponentImpl)component).getEditor().getDocument().removeDocumentListener(this.myListener);
                }
            }
        };
    }

    public void setupErrorOutdatingUserActivityWatcher(final CommittablePanel panel, final DomElement ... elements) {
        UserActivityWatcher userActivityWatcher = this.createEditorAwareUserActivityWatcher();
        userActivityWatcher.addUserActivityListener(new UserActivityListener(){
            private boolean isProcessingChange;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stateChanged() {
                if (this.isProcessingChange) {
                    return;
                }
                this.isProcessingChange = true;
                try {
                    for (DomElement element : elements) {
                        ((DomElementAnnotationsManagerImpl)DomElementAnnotationsManager.getInstance((Project)element.getManager().getProject())).outdateProblemHolder(element);
                    }
                    CommittableUtil.updateHighlighting((Committable)panel);
                }
                finally {
                    this.isProcessingChange = false;
                }
            }
        }, (Disposable)panel);
        userActivityWatcher.register((Component)panel.getComponent());
    }

    @Nullable
    public BaseControl createCustomControl(Type type, DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        Function factory = (Function)this.myCustomControlCreators.get(ReflectionUtil.getRawType((Type)type));
        return factory == null ? null : (BaseControl)factory.fun(wrapper);
    }

    public CaptionComponent addErrorPanel(CaptionComponent captionComponent, DomElement ... elements) {
        captionComponent.initErrorPanel((CommittablePanel)new DomElementsErrorPanel(elements));
        return captionComponent;
    }

    public BackgroundEditorHighlighter createDomHighlighter(Project project, PerspectiveFileEditor editor, DomElement element) {
        return () -> {
            if (!element.isValid()) {
                return HighlightingPass.EMPTY_ARRAY;
            }
            XmlFile psiFile = DomUtil.getFile((DomElement)element);
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = psiDocumentManager.getDocument((PsiFile)psiFile);
            if (document == null) {
                return HighlightingPass.EMPTY_ARRAY;
            }
            editor.commit();
            return TextEditorHighlightingPassRegistrarEx.getInstanceEx((Project)project).instantiateMainPasses((PsiFile)psiFile, document, (HighlightInfoProcessor)new DefaultHighlightInfoProcessor()).toArray(HighlightingPass.EMPTY_ARRAY);
        };
    }

    public BaseControl createTextControl(DomWrapper<String> wrapper, boolean commitOnEveryChange) {
        return new TextControl(wrapper, commitOnEveryChange);
    }

    public void registerCustomControl(@NotNull Class aClass, Function<DomWrapper<String>, BaseControl> creator) {
        this.myCustomControlCreators.put(aClass, creator);
    }

    public void registerCustomCellEditor(@NotNull Class aClass, Function<DomElement, TableCellEditor> creator) {
        this.myCustomCellEditorCreators.put(aClass, creator);
    }

    private static <T extends JComponent> T removeBorder(T component) {
        component.setBorder((Border)JBUI.Borders.empty());
        return component;
    }
}

