/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs.builder;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.stubs.BinaryFileStubBuilder;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomApplicationComponent;
import com.intellij.util.xml.impl.DomFileMetaData;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.util.xml.stubs.builder.DomStubBuilderVisitor;
import com.intellij.xml.util.XmlUtil;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class DomStubBuilder
implements BinaryFileStubBuilder.CompositeBinaryFileStubBuilder<DomFileMetaData> {
    private static final Logger LOG = Logger.getInstance(DomStubBuilder.class);

    DomStubBuilder() {
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        FileType fileType = file.getFileType();
        return fileType == XmlFileType.INSTANCE && !FileBasedIndexImpl.isProjectOrWorkspaceFile((VirtualFile)file, (FileType)fileType);
    }

    @NotNull
    public Stream<DomFileMetaData> getAllSubBuilders() {
        return DomApplicationComponent.getInstance().getStubBuildingMetadata().stream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public DomFileMetaData getSubBuilder(@NotNull FileContent fileContent) {
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            PsiFile psiFile = fileContent.getPsiFile();
            if (!(psiFile instanceof XmlFile)) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            Project project = fileContent.getProject();
            XmlFile xmlFile = (XmlFile)psiFile;
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            if (fileElement == null) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData meta = DomApplicationComponent.getInstance().findMeta(fileElement.getFileDescription());
            if (meta == null || !meta.hasStubs()) {
                DomFileMetaData domFileMetaData = null;
                return domFileMetaData;
            }
            DomFileMetaData domFileMetaData = meta;
            return domFileMetaData;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    @NotNull
    public String getSubBuilderVersion(@Nullable DomFileMetaData data) {
        return data == null ? "<no-stub>" : data.rootTagName + ":" + data.rootTagName + ":" + data.implementation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Stub buildStubTree(@NotNull FileContent fileContent, @Nullable DomFileMetaData meta) {
        if (meta == null) {
            return null;
        }
        PsiFile psiFile = fileContent.getPsiFile();
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        Project project = fileContent.getProject();
        XmlFile xmlFile = (XmlFile)psiFile;
        try {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.TRUE);
            DomFileElement fileElement = DomManager.getDomManager((Project)project).getFileElement(xmlFile);
            XmlFileHeader header = DomService.getInstance().getXmlFileHeader(xmlFile);
            if (header.getRootTagLocalName() == null) {
                LOG.error("null root tag for " + fileElement + " for " + fileContent.getFile());
            }
            FileStub fileStub = new FileStub(header);
            XmlTag rootTag = xmlFile.getRootTag();
            if (rootTag != null) {
                new DomStubBuilderVisitor(DomManagerImpl.getDomManager(project)).visitXmlElement((XmlElement)rootTag, fileStub, 0);
            }
            FileStub fileStub2 = fileStub;
            return fileStub2;
        }
        finally {
            XmlUtil.BUILDING_DOM_STUBS.set(Boolean.FALSE);
        }
    }

    public int getStubVersion() {
        return 23;
    }
}

