/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.stubs;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.stubs.ObjectStubBase;
import com.intellij.psi.stubs.Stub;
import com.intellij.util.SmartList;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.CollectionElementInvocationHandler;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.AttributeStub;
import com.intellij.util.xml.stubs.ElementStub;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DomStub
extends ObjectStubBase<DomStub> {
    @NotNull
    private final String myName;
    @NotNull
    private final String myLocalName;
    @Nullable
    private final String myNamespace;
    private DomInvocationHandler myHandler;

    DomStub(DomStub parent, @NotNull String name, @Nullable String namespace) {
        super((Stub)parent);
        this.myNamespace = namespace;
        if (parent != null) {
            ((ElementStub)parent).addChild((Stub)this);
        }
        this.myName = name;
        this.myLocalName = StringUtil.getShortName((String)this.myName, (char)':');
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @Nullable
    public String getNamespaceKey() {
        return this.myNamespace;
    }

    public boolean matches(XmlName name) {
        return name.getLocalName().equals(this.myLocalName) && StringUtil.notNullize((String)name.getNamespaceKey()).equals(this.getNamespaceKey());
    }

    public List<DomStub> getChildrenByName(XmlName xmlName) {
        List stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return Collections.emptyList();
        }
        SmartList result = new SmartList();
        int size = stubs.size();
        for (int i = 0; i < size; ++i) {
            Stub stub = (Stub)stubs.get(i);
            if (!(stub instanceof DomStub) || !((DomStub)stub).matches(xmlName)) continue;
            result.add((DomStub)stub);
        }
        return result;
    }

    @Nullable
    public AttributeStub getAttributeStub(XmlName name) {
        List stubs = this.getChildrenStubs();
        if (stubs.isEmpty()) {
            return null;
        }
        int size = stubs.size();
        for (int i = 0; i < size; ++i) {
            Stub stub = (Stub)stubs.get(i);
            if (!(stub instanceof AttributeStub) || !((AttributeStub)stub).getName().equals(name.getLocalName())) continue;
            return (AttributeStub)stub;
        }
        return null;
    }

    @Nullable
    public ElementStub getElementStub(String name, int index) {
        List stubs = this.getChildrenStubs();
        int i = 0;
        for (Stub stub : stubs) {
            if (!(stub instanceof ElementStub) || !name.equals(((ElementStub)stub).getName()) || i++ != index) continue;
            return (ElementStub)stub;
        }
        return null;
    }

    public synchronized DomInvocationHandler getOrCreateHandler(DomChildDescriptionImpl description, DomManagerImpl manager) {
        if (this.myHandler == null) {
            XmlName name = description.getXmlName();
            EvaluatedXmlNameImpl evaluatedXmlName = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)name, (String)name.getNamespaceKey(), (boolean)true);
            this.myHandler = new CollectionElementInvocationHandler((EvaluatedXmlName)evaluatedXmlName, description, manager, (ElementStub)this);
        }
        return this.myHandler;
    }

    public DomInvocationHandler getHandler() {
        return this.myHandler;
    }

    public void setHandler(DomInvocationHandler handler) {
        this.myHandler = handler;
    }

    public boolean isCustom() {
        return false;
    }

    public abstract int getIndex();
}

