/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.reflect;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.SmartList;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.ConvertAnnotationImpl;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.reflect.CustomDomChildrenDescription;
import com.intellij.util.xml.reflect.DomExtender;
import com.intellij.util.xml.reflect.DomExtension;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class DomExtensionImpl
implements DomExtension {
    public static final Key<Supplier<? extends DomElement>> KEY_DOM_DECLARATION = Key.create((String)"DOM_DECLARATION");
    public static final Key<List<DomExtender<?>>> DOM_EXTENDER_KEY = Key.create((String)"Dom.Extender");
    public static final Key<SmartPsiElementPointer<?>> DECLARING_ELEMENT_KEY = Key.create((String)"Dom.Extension.PsiDeclaration");
    private final XmlName myXmlName;
    private final Type myType;
    private Converter<?> myConverter;
    private final List<Annotation> myCustomAnnotations = new SmartList();
    private boolean mySoft;
    private int myCount = 1;
    private Map<Key<?>, Object> myUserMap;
    private CustomDomChildrenDescription.TagNameDescriptor myTagNameDescriptor = CustomDomChildrenDescription.AttributeDescriptor.EMPTY;
    private CustomDomChildrenDescription.AttributeDescriptor myAttributesDescriptor;

    public DomExtensionImpl(Type type, XmlName xmlName) {
        this.myType = type;
        this.myXmlName = xmlName;
    }

    public void setTagNameDescriptor(CustomDomChildrenDescription.TagNameDescriptor tagNameDescriptor) {
        this.myTagNameDescriptor = tagNameDescriptor;
    }

    public CustomDomChildrenDescription.TagNameDescriptor getTagNameDescriptor() {
        return this.myTagNameDescriptor;
    }

    public CustomDomChildrenDescription.AttributeDescriptor getAttributesDescriptor() {
        return this.myAttributesDescriptor;
    }

    public void setAttributesDescriptor(CustomDomChildrenDescription.AttributeDescriptor attributesDescriptor) {
        this.myAttributesDescriptor = attributesDescriptor;
    }

    @NotNull
    public XmlName getXmlName() {
        return this.myXmlName;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    public DomExtension setDeclaringElement(@NotNull DomElement declaringElement) {
        DomAnchor<DomElement> anchor = DomAnchorImpl.createAnchor(declaringElement, true);
        return this.setDeclaringDomElement(() -> anchor.retrieveDomElement());
    }

    public DomExtension setDeclaringDomElement(@NotNull Supplier<? extends DomElement> declarationFinder) {
        this.putUserData(KEY_DOM_DECLARATION, declarationFinder);
        return this;
    }

    public DomExtension setDeclaringElement(@NotNull PsiElement declaringElement) {
        this.putUserData(DECLARING_ELEMENT_KEY, SmartPointerManager.getInstance((Project)declaringElement.getProject()).createSmartPsiElementPointer(declaringElement));
        return this;
    }

    public DomExtension setConverter(@NotNull Converter converter) {
        return this.setConverter(converter, false);
    }

    public final DomExtension setConverter(@NotNull Converter converter, boolean soft) {
        this.myConverter = converter;
        this.mySoft = soft;
        return this;
    }

    public DomExtension addCustomAnnotation(@NotNull Annotation anno) {
        this.myCustomAnnotations.add(anno);
        return this;
    }

    public <T> void putUserData(Key<T> key, T value) {
        Map<Key<?>, Object> map = this.myUserMap;
        if (map == null) {
            map = new HashMap();
            this.myUserMap = map;
        }
        map.put(key, value);
    }

    public DomExtension addExtender(DomExtender extender) {
        if (this.myUserMap == null || !this.myUserMap.containsKey(DOM_EXTENDER_KEY)) {
            this.putUserData(DOM_EXTENDER_KEY, new SmartList());
        }
        ((List)this.myUserMap.get(DOM_EXTENDER_KEY)).add(extender);
        return this;
    }

    public final DomExtensionImpl setCount(int count) {
        this.myCount = count;
        return this;
    }

    public final int getCount() {
        return this.myCount;
    }

    public final <T extends DomChildDescriptionImpl> T addAnnotations(T t) {
        t.setUserMap(this.myUserMap);
        if (this.myConverter != null) {
            t.addCustomAnnotation((Annotation)((Object)new ConvertAnnotationImpl(this.myConverter, this.mySoft)));
        }
        for (Annotation anno : this.myCustomAnnotations) {
            t.addCustomAnnotation(anno);
        }
        return t;
    }
}

