/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.util.SofterReference;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class SofterCache<T, V> {
    private final Function<? super T, ? extends @NotNull V> myValueProvider;
    private SofterReference<ConcurrentMap<T, V>> myCache;

    SofterCache(Function<? super T, ? extends @NotNull V> valueProvider) {
        this.myValueProvider = valueProvider;
    }

    public void clearCache() {
        this.myCache = null;
    }

    @NotNull
    public V getCachedValue(T key) {
        ConcurrentHashMap<T, ? extends V> map;
        SofterReference<ConcurrentMap<T, V>> ref = this.myCache;
        ConcurrentHashMap<T, ? extends V> concurrentHashMap = map = ref == null ? null : (ConcurrentHashMap<T, ? extends V>)ref.get();
        if (map == null) {
            map = new ConcurrentHashMap<T, V>();
            this.myCache = new SofterReference(map);
        }
        return map.computeIfAbsent(key, this.myValueProvider);
    }
}

