/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomNameStrategy;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.JavaMethod;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.impl.AbstractCollectionChildDescription;
import com.intellij.util.xml.impl.DomChildDescriptionImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomInvocationHandler;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.reflect.DomCollectionChildDescription;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CollectionChildDescriptionImpl
extends DomChildDescriptionImpl
implements DomCollectionChildDescription,
AbstractCollectionChildDescription {
    private final Collection<JavaMethod> myGetterMethods;

    public CollectionChildDescriptionImpl(XmlName tagName, Type type, Collection<JavaMethod> getterMethods) {
        super(tagName, type);
        this.myGetterMethods = getterMethods;
    }

    public String toString() {
        return "CollectionChildDescription:" + this.getXmlName();
    }

    List<XmlTag> getCollectionSubTags(DomInvocationHandler handler, @NotNull XmlTag tag, boolean processIncludes) {
        return DomImplUtil.findSubTags(tag, handler.createEvaluatedXmlName(this.getXmlName()), handler.getFile(), processIncludes);
    }

    public DomElement addValue(@NotNull DomElement element) {
        assert (element.getGenericInfo().getCollectionChildrenDescriptions().contains(this));
        return this.addChild(element, this.getType(), Integer.MAX_VALUE);
    }

    private DomElement addChild(DomElement element, Type type, int index) {
        try {
            DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
            assert (handler != null);
            return handler.addCollectionChild(this, type, index);
        }
        catch (IncorrectOperationException e) {
            throw new RuntimeException(e);
        }
    }

    public DomElement addValue(@NotNull DomElement element, int index) {
        return this.addChild(element, this.getType(), index);
    }

    public DomElement addValue(@NotNull DomElement parent, Type type) {
        return this.addValue(parent, type, Integer.MAX_VALUE);
    }

    public final DomElement addValue(@NotNull DomElement parent, Type type, int index) {
        return this.addChild(parent, type, index);
    }

    @Nullable
    public final JavaMethod getGetterMethod() {
        Collection<JavaMethod> methods = this.myGetterMethods;
        return methods.isEmpty() ? null : methods.iterator().next();
    }

    @NotNull
    public List<? extends DomElement> getValues(@NotNull DomElement element) {
        DomInvocationHandler handler = DomManagerImpl.getDomInvocationHandler(element);
        if (handler != null) {
            return handler.getCollectionChildren(this);
        }
        JavaMethod getterMethod = this.getGetterMethod();
        if (getterMethod == null) {
            List collection = ModelMergerUtil.getFilteredImplementations((Object)element);
            return ContainerUtil.concat((Iterable)collection, domElement -> {
                DomInvocationHandler handler1 = DomManagerImpl.getDomInvocationHandler(domElement);
                assert (handler1 != null) : domElement;
                return handler1.getCollectionChildren(this);
            });
        }
        return (List)getterMethod.invoke((Object)element, ArrayUtilRt.EMPTY_OBJECT_ARRAY);
    }

    @NotNull
    public String getCommonPresentableName(@NotNull DomNameStrategy strategy) {
        @NlsSafe String words = strategy.splitIntoWords(this.getXmlElementName());
        return StringUtil.capitalizeWords((String)(words.endsWith("es") ? words : StringUtil.pluralize((String)words)), (boolean)true);
    }

    @Override
    @Nullable
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation annotation;
        JavaMethod method = this.getGetterMethod();
        if (method != null && (annotation = method.getAnnotation(annotationClass)) != null) {
            return (T)annotation;
        }
        Type elemType = this.getType();
        return elemType instanceof AnnotatedElement ? ((AnnotatedElement)((Object)elemType)).getAnnotation(annotationClass) : super.getAnnotation(annotationClass);
    }

    @Override
    public List<XmlTag> getSubTags(DomInvocationHandler handler, XmlTag[] subTags, XmlFile file) {
        return DomImplUtil.findSubTags(subTags, handler.createEvaluatedXmlName(this.getXmlName()), file);
    }

    @Override
    public EvaluatedXmlName createEvaluatedXmlName(DomInvocationHandler parent, XmlTag childTag) {
        return parent.createEvaluatedXmlName(this.getXmlName());
    }
}

