/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolderImpl;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManagerImpl;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomElementsProblemsHolderImpl
implements DomElementsProblemsHolder {
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedErrors = new ConcurrentHashMap();
    private final Map<DomElement, Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>>> myCachedChildrenErrors = new ConcurrentHashMap();
    private final List<Annotation> myAnnotations = new ArrayList<Annotation>();
    private final Function<DomElement, List<DomElementProblemDescriptor>> myDomProblemsGetter = s -> {
        Map<Class<DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map = this.myCachedErrors.get(s);
        return map == null ? Collections.emptyList() : ContainerUtil.concat(map.values());
    };
    private final DomFileElement myElement;
    private final Set<Class<? extends DomElementsInspection>> myPassedInspections = new HashSet<Class<? extends DomElementsInspection>>();

    public DomElementsProblemsHolderImpl(DomFileElement element) {
        this.myElement = element;
    }

    public void appendProblems(DomElementAnnotationHolderImpl holder, Class<? extends DomElementsInspection<?>> inspectionClass) {
        if (this.isInspectionCompleted(inspectionClass)) {
            return;
        }
        Iterator iterator = holder.iterator();
        while (iterator.hasNext()) {
            DomElementProblemDescriptor descriptor = (DomElementProblemDescriptor)iterator.next();
            this.addProblem(descriptor, inspectionClass);
        }
        this.myAnnotations.addAll((Collection<Annotation>)holder.getAnnotations());
        this.myPassedInspections.add(inspectionClass);
    }

    public boolean isInspectionCompleted(@NotNull DomElementsInspection inspection) {
        return this.isInspectionCompleted(inspection.getClass());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInspectionCompleted(Class<? extends DomElementsInspection> inspectionClass) {
        Object object = DomElementAnnotationsManagerImpl.LOCK;
        synchronized (object) {
            return this.myPassedInspections.contains(inspectionClass);
        }
    }

    public List<Annotation> getAnnotations() {
        return this.myAnnotations;
    }

    public void addProblem(DomElementProblemDescriptor descriptor, Class<? extends DomElementsInspection<?>> inspection) {
        this.myCachedErrors.computeIfAbsent(descriptor.getDomElement(), __ -> new ConcurrentHashMap()).computeIfAbsent(inspection, __ -> new SmartList()).add(descriptor);
        this.myCachedChildrenErrors.clear();
    }

    @NotNull
    public synchronized List<DomElementProblemDescriptor> getProblems(DomElement domElement) {
        if (domElement == null || !domElement.isValid()) {
            return Collections.emptyList();
        }
        return this.myDomProblemsGetter.apply(domElement);
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren) {
        if (!withChildren || domElement == null || !domElement.isValid()) {
            return this.getProblems(domElement);
        }
        return ContainerUtil.concat(this.getProblemsMap(domElement).values());
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean includeXmlProblems, boolean withChildren, HighlightSeverity minSeverity) {
        return this.getProblems(domElement, withChildren, minSeverity);
    }

    public List<DomElementProblemDescriptor> getProblems(DomElement domElement, boolean withChildren, HighlightSeverity minSeverity) {
        return ContainerUtil.findAll(this.getProblems(domElement, true, withChildren), object -> SeverityRegistrar.getSeverityRegistrar((Project)domElement.getManager().getProject()).compare(object.getHighlightSeverity(), minSeverity) >= 0);
    }

    @NotNull
    private Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> getProblemsMap(DomElement domElement) {
        Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map = this.myCachedChildrenErrors.get(domElement);
        if (map != null) {
            return map;
        }
        final HashMap problems = new HashMap();
        if (domElement == this.myElement) {
            for (Map<Class<? extends DomElementsInspection<?>>, List<DomElementProblemDescriptor>> map2 : this.myCachedErrors.values()) {
                DomElementsProblemsHolderImpl.mergeMaps(problems, map2);
            }
        } else {
            DomElementsProblemsHolderImpl.mergeMaps(problems, this.myCachedErrors.get(domElement));
            if (DomUtil.hasXml((DomElement)domElement)) {
                domElement.acceptChildren(new DomElementVisitor(){

                    public void visitDomElement(DomElement element) {
                        DomElementsProblemsHolderImpl.mergeMaps(problems, DomElementsProblemsHolderImpl.this.getProblemsMap(element));
                    }
                });
            }
        }
        this.myCachedChildrenErrors.put(domElement, problems);
        return problems;
    }

    private static <T> void mergeMaps(@NotNull Map<T, List<DomElementProblemDescriptor>> accumulator, @Nullable Map<T, List<DomElementProblemDescriptor>> toAdd) {
        if (toAdd == null) {
            return;
        }
        for (Map.Entry<T, List<DomElementProblemDescriptor>> entry : toAdd.entrySet()) {
            accumulator.computeIfAbsent(entry.getKey(), __ -> new SmartList()).addAll((Collection)entry.getValue());
        }
    }

    public List<DomElementProblemDescriptor> getAllProblems() {
        return this.getProblems((DomElement)this.myElement, false, true);
    }

    public List<DomElementProblemDescriptor> getAllProblems(@NotNull DomElementsInspection inspection) {
        if (!this.myElement.isValid()) {
            return Collections.emptyList();
        }
        List<DomElementProblemDescriptor> list = this.getProblemsMap((DomElement)this.myElement).get(inspection.getClass());
        return list != null ? new ArrayList<DomElementProblemDescriptor>(list) : Collections.emptyList();
    }
}

