/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsHighlightingUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomElementProblemDescriptorImpl
implements DomElementProblemDescriptor {
    private static final Logger LOG = Logger.getInstance(DomElementProblemDescriptorImpl.class);
    private final DomElement myDomElement;
    private final HighlightSeverity mySeverity;
    private final @InspectionMessage String myMessage;
    private final LocalQuickFix[] myFixes;
    private List<Annotation> myAnnotations;
    private Pair<TextRange, PsiElement> myPair;
    public static final Pair<TextRange, PsiElement> NO_PROBLEM = new Pair(null, null);
    private final ProblemHighlightType myHighlightType;

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type) {
        this(domElement, message, type, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type, @Nullable TextRange textRange) {
        this(domElement, message, type, textRange, null, LocalQuickFix.EMPTY_ARRAY);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type, LocalQuickFix ... fixes) {
        this(domElement, message, type, (TextRange)null, (ProblemHighlightType)null, fixes);
    }

    public DomElementProblemDescriptorImpl(@NotNull DomElement domElement, @InspectionMessage String message, HighlightSeverity type, @Nullable TextRange textRange, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        this.myDomElement = domElement;
        XmlElement element = domElement.getXmlElement();
        if (element == null || !ApplicationManager.getApplication().isUnitTestMode()) {
            // empty if block
        }
        this.mySeverity = type;
        this.myMessage = message;
        LocalQuickFix[] localQuickFixArray = this.myFixes = ArrayUtil.contains(null, (Object[])fixes) ? (LocalQuickFix[])ContainerUtil.mapNotNull((Object[])fixes, (Function)FunctionUtil.id(), (Object[])LocalQuickFix.EMPTY_ARRAY) : fixes;
        if (textRange != null) {
            PsiElement psiElement = this.getPsiElement();
            LOG.assertTrue(psiElement != null, (Object)"Problems with explicit text range can't be created for DOM elements without underlying XML element");
            assert (psiElement.isValid());
            this.myPair = Pair.create((Object)textRange, (Object)psiElement);
        }
        this.myHighlightType = highlightType;
    }

    @NotNull
    public DomElement getDomElement() {
        return this.myDomElement;
    }

    @NotNull
    public HighlightSeverity getHighlightSeverity() {
        return this.mySeverity;
    }

    @NotNull
    public String getDescriptionTemplate() {
        return this.myMessage == null ? "" : this.myMessage;
    }

    public LocalQuickFix @NotNull [] getFixes() {
        return this.myFixes;
    }

    @NotNull
    public final List<Annotation> getAnnotations() {
        if (this.myAnnotations == null) {
            this.myAnnotations = ContainerUtil.createMaybeSingletonList((Object)DomElementsHighlightingUtil.createAnnotation(this));
        }
        return this.myAnnotations;
    }

    public void highlightWholeElement() {
        PsiElement psiElement = this.getPsiElement();
        if (psiElement instanceof XmlAttributeValue) {
            assert (psiElement.isValid()) : psiElement;
            PsiElement attr = psiElement.getParent();
            this.myPair = Pair.create((Object)new TextRange(0, attr.getTextLength()), (Object)attr);
        } else if (psiElement != null) {
            assert (psiElement.isValid()) : psiElement;
            XmlTag tag = (XmlTag)(psiElement instanceof XmlTag ? psiElement : psiElement.getParent());
            this.myPair = new Pair((Object)new TextRange(0, tag.getTextLength()), (Object)tag);
        }
    }

    public Pair<TextRange, PsiElement> getProblemRange() {
        PsiElement element;
        if (this.myPair == null) {
            this.myPair = this.computeProblemRange();
        }
        if ((element = (PsiElement)this.myPair.second) != null) {
            PsiUtilCore.ensureValid((PsiElement)element);
        }
        return this.myPair;
    }

    @NotNull
    protected Pair<TextRange, PsiElement> computeProblemRange() {
        PsiElement element = this.getPsiElement();
        if (element != null) {
            String value;
            assert (element.isValid()) : element;
            if (element instanceof XmlTag) {
                return DomUtil.getProblemRange((XmlTag)((XmlTag)element));
            }
            TextRange range = TextRange.from((int)0, (int)element.getTextLength());
            if (element instanceof XmlAttributeValue && StringUtil.isNotEmpty((String)(value = ((XmlAttributeValue)element).getValue()))) {
                range = TextRange.from((int)element.getText().indexOf(value), (int)value.length());
            }
            return Pair.create((Object)range, (Object)element);
        }
        XmlTag tag = this.getParentXmlTag();
        if (tag != null) {
            return DomUtil.getProblemRange((XmlTag)tag);
        }
        return NO_PROBLEM;
    }

    public String toString() {
        return this.myDomElement + "; " + this.myMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DomElementProblemDescriptorImpl that = (DomElementProblemDescriptorImpl)o;
        if (this.myDomElement != null ? !this.myDomElement.equals(that.myDomElement) : that.myDomElement != null) {
            return false;
        }
        if (!this.myMessage.equals(that.myMessage)) {
            return false;
        }
        return this.mySeverity.equals((Object)that.mySeverity);
    }

    public int hashCode() {
        int result = this.myDomElement != null ? this.myDomElement.hashCode() : 0;
        result = 31 * result + this.mySeverity.hashCode();
        result = 31 * result + this.myMessage.hashCode();
        return result;
    }

    @Nullable
    private PsiElement getPsiElement() {
        XmlText[] textElements;
        if (this.myDomElement instanceof DomFileElement) {
            return ((DomFileElement)this.myDomElement).getFile();
        }
        if (this.myDomElement instanceof GenericAttributeValue) {
            GenericAttributeValue attributeValue = (GenericAttributeValue)this.myDomElement;
            XmlAttributeValue value = attributeValue.getXmlAttributeValue();
            return value != null && StringUtil.isNotEmpty((String)value.getText()) ? value : attributeValue.getXmlElement();
        }
        XmlTag tag = this.myDomElement.getXmlTag();
        if (this.myDomElement instanceof GenericValue && tag != null && (textElements = tag.getValue().getTextElements()).length > 0) {
            return textElements[0];
        }
        return tag;
    }

    @Nullable
    private XmlTag getParentXmlTag() {
        for (DomElement parent = this.myDomElement.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getXmlTag() == null) continue;
            return parent.getXmlTag();
        }
        return null;
    }

    @Nullable
    public ProblemHighlightType getHighlightType() {
        return this.myHighlightType;
    }
}

