/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.highlighting;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xml.XmlDomBundle;
import org.jetbrains.annotations.NotNull;

public class DefineAttributeQuickFix
implements LocalQuickFix {
    private final String myAttrName;
    private final String myAttrValue;
    private final String myNamespace;

    public DefineAttributeQuickFix(String attrName) {
        this(attrName, "", "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace) {
        this(attrName, namespace, "");
    }

    public DefineAttributeQuickFix(@NotNull String attrName, @NotNull String namespace, @NotNull String attrValue) {
        this.myAttrName = attrName;
        this.myNamespace = namespace;
        this.myAttrValue = attrValue;
    }

    @NotNull
    public String getName() {
        return XmlDomBundle.message((String)"dom.quickfix.define.attribute.text", (Object[])new Object[]{this.myAttrName});
    }

    @NotNull
    public String getFamilyName() {
        return XmlDomBundle.message((String)"dom.quickfix.define.attribute.family", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        XmlTag tag;
        XmlAttribute attribute = tag.setAttribute(this.myAttrName, this.myNamespace.equals((tag = (XmlTag)descriptor.getPsiElement()).getNamespace()) ? "" : this.myNamespace, this.myAttrValue);
        VirtualFile virtualFile = tag.getContainingFile().getVirtualFile();
        if (virtualFile != null) {
            PsiNavigationSupport.getInstance().createNavigatable(project, virtualFile, attribute.getValueElement().getTextRange().getStartOffset() + 1).navigate(true);
        }
    }
}

