/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.NonExhaustiveEnum;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.XmlDomBundle;
import com.intellij.xml.util.XmlUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EnumConverter<T extends Enum>
extends ResolvingConverter<T> {
    private final Class<T> myType;

    private EnumConverter(Class<T> aClass) {
        this.myType = aClass;
    }

    public static <T extends Enum> EnumConverter<T> createEnumConverter(Class<T> aClass) {
        return new EnumConverter<T>(aClass);
    }

    private String getStringValue(T anEnum) {
        return NamedEnumUtil.getEnumValueByElement(anEnum);
    }

    public T fromString(String s, ConvertContext context) {
        return (T)(s == null ? null : NamedEnumUtil.getEnumElementByValue(this.myType, (String)s));
    }

    public String toString(T t, ConvertContext context) {
        return t == null ? null : this.getStringValue(t);
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return XmlDomBundle.message((String)"dom.converter.unknown.enum.value", (Object[])new Object[]{s});
    }

    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        XmlTag simpleContent;
        XmlElement element = context.getXmlElement();
        if (element instanceof XmlTag && (simpleContent = XmlUtil.getSchemaSimpleContent((XmlTag)((XmlTag)element))) != null && XmlUtil.collectEnumerationValues((XmlTag)simpleContent, new HashSet())) {
            return Collections.emptyList();
        }
        return Arrays.asList((Enum[])this.myType.getEnumConstants());
    }

    public boolean isExhaustive() {
        return !ReflectionUtil.isAssignable(NonExhaustiveEnum.class, this.myType);
    }
}

