/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ObjectUtils;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.DefaultFileTypeSpecificInputFilter;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class DomFileIndex
extends ScalarIndexExtension<DomIndexKey> {
    private static final ID<DomIndexKey, Void> INDEX_ID = ID.create((String)"DomFileIndex");
    private static final String NULL_NAMESPACE = "-NULL-";

    @NotNull
    public ID<DomIndexKey, Void> getName() {
        return INDEX_ID;
    }

    @NotNull
    public static Collection<VirtualFile> findFiles(@NotNull String rootTagName, @Nullable String namespace, @NotNull GlobalSearchScope scope) {
        return FileBasedIndex.getInstance().getContainingFiles(INDEX_ID, (Object)new DomIndexKey(rootTagName, (String)ObjectUtils.notNull((Object)namespace, (Object)NULL_NAMESPACE)), scope);
    }

    @NotNull
    public DataIndexer<DomIndexKey, Void, FileContent> getIndexer() {
        return new DataIndexer<DomIndexKey, Void, FileContent>(){

            @NotNull
            public Map<DomIndexKey, Void> map(@NotNull FileContent inputData) {
                XmlFileHeader header = NanoXmlUtil.parseHeader((Reader)CharArrayUtil.readerFromCharSequence((CharSequence)inputData.getContentAsText()));
                String rootTagName = header.getRootTagLocalName();
                if (rootTagName == null) {
                    return Collections.emptyMap();
                }
                String[] namespaces = new String[]{header.getPublicId(), header.getSystemId(), header.getRootTagNamespace(), DomFileIndex.NULL_NAMESPACE};
                HashMap<DomIndexKey, Void> set = new HashMap<DomIndexKey, Void>(namespaces.length);
                for (String t : namespaces) {
                    if (t == null) continue;
                    set.put(new DomIndexKey(rootTagName, t), null);
                }
                return set;
            }
        };
    }

    @NotNull
    public KeyDescriptor<DomIndexKey> getKeyDescriptor() {
        return new DomIndexKeyDescriptor();
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        return new DefaultFileTypeSpecificInputFilter(new FileType[]{XmlFileType.INSTANCE});
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public int getVersion() {
        return 0;
    }

    public static class DomIndexKey {
        @NotNull
        private final String myRootTagName;
        @NotNull
        private final String myNamespace;

        private DomIndexKey(@NotNull String rootTagName, @NotNull String namespace) {
            this.myRootTagName = rootTagName;
            this.myNamespace = namespace;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DomIndexKey key = (DomIndexKey)o;
            return this.myRootTagName.equals(key.myRootTagName) && this.myNamespace.equals(key.myNamespace);
        }

        public int hashCode() {
            return Objects.hash(this.myRootTagName, this.myNamespace);
        }

        public String toString() {
            return "DomIndexKey{myRootTagName='" + this.myRootTagName + "', myNamespace='" + this.myNamespace + "'}";
        }
    }

    private static class DomIndexKeyDescriptor
    implements KeyDescriptor<DomIndexKey> {
        private DomIndexKeyDescriptor() {
        }

        public boolean isEqual(DomIndexKey val1, DomIndexKey val2) {
            return val1.equals(val2);
        }

        public DomIndexKey read(@NotNull DataInput in) throws IOException {
            return new DomIndexKey(EnumeratorStringDescriptor.INSTANCE.read(in), EnumeratorStringDescriptor.INSTANCE.read(in));
        }

        public int getHashCode(DomIndexKey value) {
            return value.hashCode();
        }

        public void save(@NotNull DataOutput out, DomIndexKey value) throws IOException {
            EnumeratorStringDescriptor.INSTANCE.save(out, value.myRootTagName);
            EnumeratorStringDescriptor.INSTANCE.save(out, value.myNamespace);
        }
    }
}

