/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.navigation.DomGotoRelatedItem;
import com.intellij.codeInsight.navigation.NavigationGutterIconRenderer;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NotNullFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.ConstantFunction;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.NullableFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NavigationGutterIconBuilder<T> {
    @NonNls
    private static final String PATTERN = "&nbsp;&nbsp;&nbsp;&nbsp;{0}";
    protected static final NotNullFunction<PsiElement, Collection<? extends PsiElement>> DEFAULT_PSI_CONVERTOR = ContainerUtil::createMaybeSingletonList;
    protected final Icon myIcon;
    private final NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> myConverter;
    protected NotNullLazyValue<Collection<? extends T>> myTargets;
    protected boolean myLazy;
    protected @NlsContexts.Tooltip String myTooltipText;
    protected @NlsContexts.PopupTitle String myPopupTitle;
    protected @NlsContexts.PopupContent String myEmptyText;
    protected @NlsContexts.PopupTitle String myTooltipTitle;
    protected GutterIconRenderer.Alignment myAlignment = GutterIconRenderer.Alignment.CENTER;
    private Computable<PsiElementListCellRenderer<?>> myCellRenderer;
    @NotNull
    private NullableFunction<? super T, String> myNamer = ElementPresentationManager.namer();
    private final NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> myGotoRelatedItemProvider;
    public static final NotNullFunction<DomElement, Collection<? extends PsiElement>> DEFAULT_DOM_CONVERTOR = o -> ContainerUtil.createMaybeSingletonList((Object)o.getXmlElement());
    public static final NotNullFunction<DomElement, Collection<? extends GotoRelatedItem>> DOM_GOTO_RELATED_ITEM_PROVIDER = dom -> {
        if (dom.getXmlElement() != null) {
            return List.of(new DomGotoRelatedItem(dom));
        }
        return Collections.emptyList();
    };
    protected static final NotNullFunction<PsiElement, Collection<? extends GotoRelatedItem>> PSI_GOTO_RELATED_ITEM_PROVIDER = dom -> List.of(new GotoRelatedItem(dom, InspectionsBundle.message((String)"xml.goto.group", (Object[])new Object[0])));

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        this(icon, converter, null);
    }

    protected NavigationGutterIconBuilder(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        this.myIcon = icon;
        this.myConverter = converter;
        this.myGotoRelatedItemProvider = gotoRelatedItemProvider;
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon) {
        return NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR, PSI_GOTO_RELATED_ITEM_PROVIDER);
    }

    @NotNull
    public static NavigationGutterIconBuilder<PsiElement> create(@NotNull Icon icon, @NlsContexts.Separator String navigationGroup) {
        return NavigationGutterIconBuilder.create(icon, DEFAULT_PSI_CONVERTOR, element -> List.of(new GotoRelatedItem(element, navigationGroup)));
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        return NavigationGutterIconBuilder.create(icon, converter, null);
    }

    @NotNull
    public static <T> NavigationGutterIconBuilder<T> create(@NotNull Icon icon, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter, @Nullable NotNullFunction<? super T, ? extends Collection<? extends GotoRelatedItem>> gotoRelatedItemProvider) {
        return new NavigationGutterIconBuilder<T>(icon, converter, gotoRelatedItemProvider);
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTarget(@Nullable T target) {
        return this.setTargets(ContainerUtil.createMaybeSingletonList(target));
    }

    @SafeVarargs
    @NotNull
    public final NavigationGutterIconBuilder<T> setTargets(T ... targets) {
        return this.setTargets((Collection<? extends T>)Arrays.asList(targets));
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull NotNullLazyValue<Collection<? extends T>> targets) {
        this.myTargets = targets;
        this.myLazy = true;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTargets(@NotNull Collection<? extends T> targets) {
        if (ContainerUtil.containsIdentity(targets, null)) {
            throw new IllegalArgumentException("Must not pass collection with null target but got: " + targets);
        }
        this.myTargets = NotNullLazyValue.createConstantValue(targets);
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipText(@NotNull @NlsContexts.Tooltip String tooltipText) {
        this.myTooltipText = tooltipText;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setAlignment(@NotNull GutterIconRenderer.Alignment alignment) {
        this.myAlignment = alignment;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setPopupTitle(@NotNull @NlsContexts.PopupTitle String popupTitle) {
        this.myPopupTitle = popupTitle;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setEmptyPopupText(@NotNull @NlsContexts.PopupContent String emptyText) {
        this.myEmptyText = emptyText;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setTooltipTitle(@NotNull @NlsContexts.PopupTitle String tooltipTitle) {
        this.myTooltipTitle = tooltipTitle;
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setNamer(@NotNull NullableFunction<? super T, String> namer) {
        this.myNamer = namer;
        return this;
    }

    @Deprecated
    @NotNull
    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull PsiElementListCellRenderer cellRenderer) {
        this.myCellRenderer = new Computable.PredefinedValueComputable((Object)cellRenderer);
        return this;
    }

    @NotNull
    public NavigationGutterIconBuilder<T> setCellRenderer(@NotNull Computable<PsiElementListCellRenderer<?>> cellRendererProvider) {
        this.myCellRenderer = cellRendererProvider;
        return this;
    }

    @Deprecated(forRemoval=true)
    @Nullable
    public Annotation install(@NotNull DomElementAnnotationHolder holder, @Nullable DomElement element) {
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createAnnotation(element, HighlightSeverity.INFORMATION, null), element.getManager().getProject());
    }

    @Deprecated
    @Nullable
    public Annotation install(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return null;
        }
        return this.doInstall(holder.createInfoAnnotation(element, null), element.getProject());
    }

    public void createGutterIcon(@NotNull AnnotationHolder holder, @Nullable PsiElement element) {
        if (!this.myLazy && ((Collection)this.myTargets.getValue()).isEmpty() || element == null) {
            return;
        }
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject(), null);
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(element).gutterIconRenderer((GutterIconRenderer)renderer).needsUpdateOnTyping(false).create();
    }

    @NotNull
    private Annotation doInstall(@NotNull Annotation annotation, @NotNull Project project) {
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(project, null);
        annotation.setGutterIconRenderer((GutterIconRenderer)renderer);
        annotation.setNeedsUpdateOnTyping(false);
        return annotation;
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element) {
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject(), null);
        return this.createLineMarkerInfo(element, renderer.isNavigateAction() ? renderer : null);
    }

    @NotNull
    public RelatedItemLineMarkerInfo<PsiElement> createLineMarkerInfo(@NotNull PsiElement element, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        NavigationGutterIconRenderer renderer = this.createGutterIconRenderer(element.getProject(), navigationHandler);
        String tooltip = renderer.getTooltipText();
        return new RelatedItemLineMarkerInfo(element, element.getTextRange(), renderer.getIcon(), (Function)(tooltip == null ? null : new ConstantFunction((Object)tooltip)), navigationHandler, renderer.getAlignment(), () -> this.computeGotoTargets());
    }

    @NotNull
    protected Collection<GotoRelatedItem> computeGotoTargets() {
        if (this.myTargets == null || this.myGotoRelatedItemProvider == null) {
            return Collections.emptyList();
        }
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        return ContainerUtil.concat((Iterable)((Iterable)factory.create()), this.myGotoRelatedItemProvider);
    }

    private void checkBuilt() {
        assert (this.myTargets != null) : "Must have called .setTargets() before calling create()";
    }

    @NotNull
    private static <T> NotNullFactory<T> evaluateAndForget(@NotNull NotNullLazyValue<T> lazyValue) {
        final Ref ref = Ref.create(lazyValue);
        return new NotNullFactory<T>(){
            volatile T value;

            @NotNull
            public T create() {
                Object result = this.value;
                if (result == null) {
                    this.value = result = ((NotNullLazyValue)ref.get()).getValue();
                    ref.set(null);
                }
                return result;
            }
        };
    }

    @NotNull
    protected NavigationGutterIconRenderer createGutterIconRenderer(@NotNull Project project, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        this.checkBuilt();
        NotNullFactory<Collection<? extends T>> factory = NavigationGutterIconBuilder.evaluateAndForget(this.myTargets);
        NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers = NavigationGutterIconBuilder.createPointersThunk(this.myLazy, project, factory, this.myConverter);
        boolean empty = this.isEmpty();
        if (this.myTooltipText == null && !this.myLazy) {
            TreeSet<String> names = new TreeSet<String>();
            for (Object t : (Collection)this.myTargets.getValue()) {
                String text = (String)this.myNamer.fun(t);
                if (text == null) continue;
                names.add(MessageFormat.format(PATTERN, text));
            }
            @Nls StringBuilder sb = new StringBuilder("<html><body>");
            if (this.myTooltipTitle != null) {
                sb.append(this.myTooltipTitle).append("<br>");
            }
            for (String name : names) {
                sb.append(name).append("<br>");
            }
            sb.append("</body></html>");
            this.myTooltipText = sb.toString();
        }
        Computable<PsiElementListCellRenderer<?>> renderer = this.myCellRenderer == null ? DefaultPsiElementCellRenderer::new : this.myCellRenderer;
        return this.createGutterIconRenderer(pointers, renderer, empty, navigationHandler);
    }

    @NotNull
    protected NavigationGutterIconRenderer createGutterIconRenderer(@NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> renderer, boolean empty, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        if (this.myLazy) {
            return this.createLazyGutterIconRenderer(pointers, renderer, empty, navigationHandler);
        }
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty, navigationHandler);
    }

    @NotNull
    protected NavigationGutterIconRenderer createLazyGutterIconRenderer(@NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> renderer, boolean empty, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
        return new MyNavigationGutterIconRenderer(this, this.myAlignment, this.myIcon, this.myTooltipText, pointers, renderer, empty, true, navigationHandler);
    }

    @NotNull
    private static <T> NotNullLazyValue<List<SmartPsiElementPointer<?>>> createPointersThunk(boolean lazy, Project project, NotNullFactory<? extends Collection<? extends T>> targets, NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        if (!lazy) {
            return NotNullLazyValue.createConstantValue(NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter));
        }
        return NotNullLazyValue.lazy(() -> NavigationGutterIconBuilder.calcPsiTargets(project, (Collection)targets.create(), converter));
    }

    @NotNull
    private static <T> List<SmartPsiElementPointer<?>> calcPsiTargets(@NotNull Project project, @NotNull Collection<? extends T> targets, @NotNull NotNullFunction<? super T, ? extends Collection<? extends PsiElement>> converter) {
        SmartPointerManager manager = SmartPointerManager.getInstance((Project)project);
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        ArrayList list = new ArrayList(targets.size());
        for (T target : targets) {
            for (PsiElement psiElement : (Collection)converter.fun(target)) {
                if (psiElement == null) {
                    throw new IllegalArgumentException(converter + " returned null element");
                }
                if (!elements.add(psiElement) || !psiElement.isValid()) continue;
                list.add(manager.createSmartPsiElementPointer(psiElement));
            }
        }
        return list;
    }

    private boolean isEmpty() {
        if (this.myLazy) {
            return false;
        }
        HashSet<PsiElement> elements = new HashSet<PsiElement>();
        Collection targets = (Collection)this.myTargets.getValue();
        for (Object target : targets) {
            for (PsiElement psiElement : (Collection)this.myConverter.fun(target)) {
                if (!elements.add(psiElement)) continue;
                return false;
            }
        }
        return true;
    }

    private static class MyNavigationGutterIconRenderer
    extends NavigationGutterIconRenderer {
        private final GutterIconRenderer.Alignment myAlignment;
        private final Icon myIcon;
        private final @NlsContexts.Tooltip String myTooltipText;
        private final boolean myEmpty;

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder, @NotNull GutterIconRenderer.Alignment alignment, Icon icon, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> cellRenderer, boolean empty, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers, false, navigationHandler);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        MyNavigationGutterIconRenderer(@NotNull NavigationGutterIconBuilder<?> builder, @NotNull GutterIconRenderer.Alignment alignment, Icon icon, @Nullable @NlsContexts.Tooltip String tooltipText, @NotNull NotNullLazyValue<List<SmartPsiElementPointer<?>>> pointers, @NotNull Computable<PsiElementListCellRenderer<?>> cellRenderer, boolean empty, boolean computeTargetsInBackground, @Nullable GutterIconNavigationHandler<PsiElement> navigationHandler) {
            super(builder.myPopupTitle, builder.myEmptyText, cellRenderer, pointers, computeTargetsInBackground, navigationHandler);
            this.myAlignment = alignment;
            this.myIcon = icon;
            this.myTooltipText = tooltipText;
            this.myEmpty = empty;
        }

        @Override
        public boolean isNavigateAction() {
            return !this.myEmpty;
        }

        @NotNull
        public Icon getIcon() {
            return this.myIcon;
        }

        @Nullable
        public String getTooltipText() {
            return this.myTooltipText;
        }

        @NotNull
        public GutterIconRenderer.Alignment getAlignment() {
            return this.myAlignment;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!super.equals(o)) {
                return false;
            }
            MyNavigationGutterIconRenderer that = (MyNavigationGutterIconRenderer)((Object)o);
            if (this.myAlignment != that.myAlignment) {
                return false;
            }
            if (this.myIcon != null ? !this.myIcon.equals(that.myIcon) : that.myIcon != null) {
                return false;
            }
            return !(this.myTooltipText != null ? !this.myTooltipText.equals(that.myTooltipText) : that.myTooltipText != null);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.myAlignment != null ? this.myAlignment.hashCode() : 0);
            result = 31 * result + (this.myIcon != null ? this.myIcon.hashCode() : 0);
            result = 31 * result + (this.myTooltipText != null ? this.myTooltipText.hashCode() : 0);
            return result;
        }
    }
}

