/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintRequest;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;

public class LintIdeRequest
extends LintRequest {
    private final com.intellij.openapi.project.Project myProject;
    private final List<Module> myModules;
    private final LintIdeClient mLintClient;
    private final List<VirtualFile> myFileList;
    private Project myMainProject;
    private final boolean myIncremental;

    public LintIdeRequest(LintIdeClient client, com.intellij.openapi.project.Project project, List<VirtualFile> fileList, List<Module> modules, boolean incremental) {
        super((LintClient)client, Collections.emptyList());
        this.mLintClient = client;
        this.myProject = project;
        this.myModules = modules;
        this.myFileList = fileList;
        this.myIncremental = incremental;
        this.platform = LintIdeSupport.get().getPlatforms();
    }

    com.intellij.openapi.project.Project getProject() {
        return this.myProject;
    }

    public EnumSet<Scope> getScope() {
        Collection<Project> projects;
        if (this.scope == null && (projects = this.getProjects()) != null) {
            this.scope = Scope.infer(projects);
            if (this.scope.contains(Scope.CLASS_FILE) || this.scope.contains(Scope.ALL_CLASS_FILES) || this.scope.contains(Scope.JAVA_LIBRARIES)) {
                this.scope = EnumSet.copyOf(this.scope);
                this.scope.remove(Scope.CLASS_FILE);
                this.scope.remove(Scope.ALL_CLASS_FILES);
                this.scope.remove(Scope.JAVA_LIBRARIES);
            }
        }
        return this.scope;
    }

    public Collection<Project> getProjects() {
        if (this.projects == null) {
            if (this.myIncremental && this.myFileList != null && this.myFileList.size() == 1 && this.myModules.size() == 1) {
                Pair<Project, Project> pair = LintIdeSupport.get().createProjectForSingleFile(this.mLintClient, this.myFileList.get(0), this.myModules.get(0));
                this.projects = pair.first != null ? Collections.singletonList((Project)pair.first) : Collections.emptyList();
                this.myMainProject = (Project)pair.second;
            } else {
                this.projects = !this.myModules.isEmpty() ? LintIdeSupport.get().createProject(this.mLintClient, this.myFileList, this.myModules.toArray(Module.EMPTY_ARRAY)) : super.getProjects();
            }
        }
        return this.projects;
    }

    public Project getMainProject(Project project) {
        if (this.myMainProject != null) {
            return this.myMainProject;
        }
        return super.getMainProject(project);
    }
}

