/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.LintIdeIssueRegistry;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.ConfigurationHierarchy;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintXmlConfiguration;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\"\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000bH\u0016R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/lint/common/LintIdeConfiguration;", "Lcom/android/tools/lint/client/api/LintXmlConfiguration;", "configurations", "Lcom/android/tools/lint/client/api/ConfigurationHierarchy;", "project", "Lcom/android/tools/lint/detector/api/Project;", "issues", "", "Lcom/android/tools/lint/detector/api/Issue;", "(Lcom/android/tools/lint/client/api/ConfigurationHierarchy;Lcom/android/tools/lint/detector/api/Project;Ljava/util/Set;)V", "getDefinedSeverity", "Lcom/android/tools/lint/detector/api/Severity;", "issue", "source", "Lcom/android/tools/lint/client/api/Configuration;", "visibleDefault", "intellij.lint"})
public final class LintIdeConfiguration
extends LintXmlConfiguration {
    @NotNull
    private final Set<Issue> issues;

    public LintIdeConfiguration(@NotNull ConfigurationHierarchy configurations, @NotNull Project project, @NotNull Set<Issue> issues) {
        Intrinsics.checkNotNullParameter((Object)configurations, (String)"configurations");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(issues, (String)"issues");
        super(configurations, project);
        this.issues = issues;
    }

    @Nullable
    public Severity getDefinedSeverity(@NotNull Issue issue, @NotNull Configuration source, @NotNull Severity visibleDefault) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)visibleDefault, (String)"visibleDefault");
        boolean known = this.issues.contains(issue);
        if (!known) {
            if (Intrinsics.areEqual((Object)issue, (Object)IssueRegistry.BASELINE)) {
                return Severity.INFORMATIONAL;
            }
            IssueRegistry builtin = LintIdeIssueRegistry.get();
            if (builtin.isIssueId(issue.getId())) {
                return Severity.IGNORE;
            }
        }
        return super.getDefinedSeverity(issue, source, visibleDefault);
    }
}

