/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.common;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.AnnotateQuickFixKt;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.base.codeInsight.ShortenReferencesFacility;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtAnnotated;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtPsiFactory;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B)\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/idea/lint/common/AnnotateQuickFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "displayName", "", "familyName", "annotationSource", "replace", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Z)V", "apply", "", "element", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "findContainer", "isApplicable", "startElement", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "intellij.lint"})
public final class AnnotateQuickFix
extends DefaultLintQuickFix {
    @NotNull
    private final String annotationSource;
    private final boolean replace;

    public AnnotateQuickFix(@Nullable String displayName, @Nullable String familyName, @NotNull String annotationSource, boolean replace) {
        Intrinsics.checkNotNullParameter((Object)annotationSource, (String)"annotationSource");
        String string = displayName;
        if (string == null) {
            string = "Annotate";
        }
        super(string, familyName);
        this.annotationSource = annotationSource;
        this.replace = replace;
    }

    private final PsiElement findContainer(PsiElement element) {
        Language language = element.getLanguage();
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? (PsiElement)AnnotateQuickFixKt.findJavaAnnotationTarget(element) : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? AnnotateQuickFixKt.access$findKotlinAnnotationTarget(element) : null);
    }

    @Override
    public void apply(@NotNull PsiElement element, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"element.language");
        Language language2 = language;
        PsiElement psiElement = this.findContainer(element);
        if (psiElement == null) {
            return;
        }
        PsiElement container = psiElement;
        if (!IntentionPreviewUtils.prepareElementForWrite((PsiElement)container)) {
            return;
        }
        Language language3 = language2;
        if (Intrinsics.areEqual((Object)language3, (Object)JavaLanguage.INSTANCE)) {
            PsiModifierListOwner owner = (PsiModifierListOwner)container;
            Project project = element.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"element.project");
            Project project2 = project;
            PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
            Intrinsics.checkNotNullExpressionValue((Object)psiElementFactory, (String)"getInstance(project).elementFactory");
            PsiElementFactory factory = psiElementFactory;
            PsiAnnotation psiAnnotation = factory.createAnnotationFromText(this.annotationSource, element);
            Intrinsics.checkNotNullExpressionValue((Object)psiAnnotation, (String)"factory.createAnnotation\u2026nnotationSource, element)");
            PsiAnnotation newAnnotation = psiAnnotation;
            String string = newAnnotation.getQualifiedName();
            if (string == null) {
                return;
            }
            String annotationName = string;
            String[] stringArray = new String[]{annotationName};
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (String[])stringArray);
            if (annotation != null && annotation.isPhysical() && this.replace) {
                annotation.replace((PsiElement)newAnnotation);
            } else {
                PsiNameValuePair[] attributes = newAnnotation.getParameterList().getAttributes();
                new AddAnnotationFix(annotationName, (PsiModifierListOwner)container, attributes, new String[0]).invoke(project2, null, element.getContainingFile());
            }
        } else if (Intrinsics.areEqual((Object)language3, (Object)KotlinLanguage.INSTANCE)) {
            KtAnnotationEntry ktAnnotationEntry;
            if (!(container instanceof KtModifierListOwner)) {
                return;
            }
            KtPsiFactory psiFactory = new KtPsiFactory((KtElement)container, false, 2, null);
            KtAnnotationEntry annotationEntry = psiFactory.createAnnotationEntry(this.annotationSource);
            FqName fqName = new FqName(StringsKt.substringBefore$default((String)StringsKt.substringAfter$default((String)StringsKt.removePrefix((String)this.annotationSource, (CharSequence)"@"), (char)':', null, (int)2, null), (char)'(', null, (int)2, null));
            KtAnnotationEntry existing = LintIdeUtilsKt.findAnnotation((KtAnnotated)container, fqName);
            if (existing != null && existing.isPhysical() && this.replace) {
                PsiElement psiElement2 = existing.replace((PsiElement)annotationEntry);
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtAnnotationEntry");
                ktAnnotationEntry = (KtAnnotationEntry)psiElement2;
            } else {
                KtAnnotationEntry ktAnnotationEntry2 = ((KtModifierListOwner)container).addAnnotationEntry(annotationEntry);
                Intrinsics.checkNotNullExpressionValue((Object)ktAnnotationEntry2, (String)"{\n            container.\u2026otationEntry)\n          }");
                ktAnnotationEntry = ktAnnotationEntry2;
            }
            KtAnnotationEntry addedAnnotation = ktAnnotationEntry;
            ShortenReferencesFacility.Companion.getInstance().shorten((KtElement)addedAnnotation);
        }
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        return this.findContainer(startElement) != null;
    }
}

