/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols.ui;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.LocalPathCellEditor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class FolderPathCellEditor
extends LocalPathCellEditor {
    @NotNull
    private final Project myProject;

    public FolderPathCellEditor(@NotNull Project project, @NotNull String originalPath) {
        super(project);
        this.myProject = project;
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false);
        descriptor.setTitle("Debug Symbols");
        descriptor.setDescription("<html>The path:<br/>&nbsp;&nbsp;" + originalPath + "<br/>was not found on this computer.<br/><br/>Please choose a local folder to map this path to.</html>");
        this.fileChooserDescriptor(descriptor);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        super.getTableCellEditorComponent(table, value, isSelected, row, column);
        Color editorBackground = UIUtil.getTableBackground();
        ComponentWithBrowseButton componentWithButton = this.myComponent.getComponentWithButton();
        componentWithButton.setBackground(editorBackground);
        componentWithButton.getButton().setBackground(editorBackground);
        ((JTextField)componentWithButton.getChildComponent()).setName("folderPathCellEditorTextField");
        return this.myComponent;
    }

    @NotNull
    protected ActionListener createActionListener(JTable table) {
        return e -> {
            String initial = (String)this.getCellEditorValue();
            VirtualFile initialFile = StringUtil.isNotEmpty((String)initial) ? LocalFileSystem.getInstance().findFileByPath(initial) : null;
            FileChooserDialogImpl chooser = new FileChooserDialogImpl(this.getFileChooserDescriptor(), this.myProject);
            chooser.choose(initialFile, files -> {
                VirtualFile file = (VirtualFile)files.get(0);
                Object path = file.getPresentableUrl();
                if (SystemInfo.isWindows && ((String)path).length() == 2 && Character.isLetter(((String)path).charAt(0)) && ((String)path).charAt(1) == ':') {
                    path = (String)path + "\\";
                }
                ((JTextField)this.myComponent.getChildComponent()).setText((String)path);
            });
        };
    }
}

