/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.symbols;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.AsyncResult;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.gradle.util.ContentEntries;
import com.android.tools.idea.io.FilePaths;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class SourceFoldersUpdater {
    @NotNull
    public AsyncResult<Void> updateSourceFolders(final @NotNull ApkFacet facet) {
        final AsyncResult<Void> callback = new AsyncResult<Void>();
        new Task.Modal(facet.getModule().getProject(), "Updating Source Folders", false){

            public void run(@NotNull ProgressIndicator indicator) {
                try {
                    indicator.setIndeterminate(true);
                    SourceFoldersUpdater.this.updateSourceFoldersSync(facet);
                    callback.setDone();
                }
                catch (Throwable error) {
                    callback.setRejected(error);
                }
            }
        }.queue();
        return callback;
    }

    public void updateSourceFoldersSync(@NotNull ApkFacet facet) {
        SourceFoldersToUpdate sourceFoldersToUpdate = this.findSourceFoldersToUpdate(facet);
        Module module = facet.getModule();
        ModifiableRootModel moduleModel = SourceFoldersUpdater.getModifiableModuleModel(module);
        try {
            this.updateSourceFolders(sourceFoldersToUpdate, moduleModel);
            SourceFoldersUpdater.commit(moduleModel);
        }
        catch (Throwable error) {
            SourceFoldersUpdater.dispose(moduleModel);
            throw error;
        }
    }

    @VisibleForTesting
    void updateSourceFolders(@NotNull SourceFoldersToUpdate sourceFoldersToUpdate, @NotNull ModifiableRootModel moduleModel) {
        ContentEntry[] contentEntries = moduleModel.getContentEntries();
        Set<String> sourceFolderPathsToAdd = sourceFoldersToUpdate.getSourceFolderPathsToAdd();
        if (!sourceFolderPathsToAdd.isEmpty()) {
            LocalFileSystem fileSystem = LocalFileSystem.getInstance();
            for (String path : sourceFolderPathsToAdd) {
                VirtualFile folder = fileSystem.findFileByPath(path);
                if (folder == null) continue;
                ContentEntry contentEntry = ContentEntries.findParentContentEntry((File)new File(path), Arrays.stream(contentEntries));
                if (contentEntry == null) {
                    contentEntry = moduleModel.addContentEntry(folder);
                }
                contentEntry.addSourceFolder(folder, false);
            }
        }
        SourceFoldersUpdater.removeSourceFolders(sourceFoldersToUpdate.getSourceFolderPathsToRemove(), moduleModel);
    }

    @NotNull
    public AsyncResult<Void> removeSourceFoldersInLibrary(final @NotNull ApkFacet apkFacet, final @NotNull NativeLibrary library) {
        final Module module = apkFacet.getModule();
        final AsyncResult<Void> callback = new AsyncResult<Void>();
        new Task.Backgroundable(module.getProject(), "Removing Source Folders", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                Set<String> existingSourceFolderPaths = SourceFoldersUpdater.getExistingSourceFolderPaths(module);
                ArrayList libraries = Lists.newArrayList((Iterable)((ApkFacetConfiguration)apkFacet.getConfiguration()).NATIVE_LIBRARIES);
                libraries.remove(library);
                Set<String> remainingSourceFolderPaths = SourceFoldersUpdater.getSourceFolderPaths(libraries);
                HashSet<String> sourceFolderPathsToRemove = new HashSet<String>();
                for (String path : existingSourceFolderPaths) {
                    if (remainingSourceFolderPaths.contains(path)) continue;
                    sourceFolderPathsToRemove.add(path);
                }
                if (sourceFolderPathsToRemove.isEmpty()) {
                    callback.setDone();
                    return;
                }
                ModifiableRootModel moduleModel = SourceFoldersUpdater.getModifiableModuleModel(module);
                try {
                    SourceFoldersUpdater.removeSourceFolders(sourceFolderPathsToRemove, moduleModel);
                    SourceFoldersUpdater.commit(moduleModel);
                    callback.setDone();
                }
                catch (RuntimeException error) {
                    SourceFoldersUpdater.dispose(moduleModel);
                    callback.setRejected(error);
                }
            }
        }.queue();
        return callback;
    }

    private static void removeSourceFolders(@NotNull Collection<String> sourceFolderPaths, @NotNull ModifiableRootModel moduleModel) {
        ContentEntry[] contentEntries = moduleModel.getContentEntries();
        HashSet<ContentEntry> contentEntriesToRemove = new HashSet<ContentEntry>();
        for (String sourceFolderPath : sourceFolderPaths) {
            File path = FilePaths.stringToFile((String)sourceFolderPath);
            ContentEntry parent = ContentEntries.findParentContentEntry((File)path, Arrays.stream(contentEntries));
            if (parent == null) continue;
            SourceFolder[] sourceFolders = parent.getSourceFolders();
            if (sourceFolders.length > 1) {
                for (SourceFolder sourceFolder : sourceFolders) {
                    VirtualFile file = sourceFolder.getFile();
                    if (file == null || !FileUtil.filesEqual((File)path, (File)VfsUtilCore.virtualToIoFile((VirtualFile)file))) continue;
                    parent.removeSourceFolder(sourceFolder);
                }
            } else {
                parent.clearSourceFolders();
            }
            if (parent.getSourceFolders().length != 0) continue;
            contentEntriesToRemove.add(parent);
        }
        for (ContentEntry contentEntry : contentEntriesToRemove) {
            moduleModel.removeContentEntry(contentEntry);
        }
    }

    @VisibleForTesting
    @NotNull
    SourceFoldersToUpdate findSourceFoldersToUpdate(@NotNull ApkFacet facet) {
        ApkFacetConfiguration configuration = (ApkFacetConfiguration)facet.getConfiguration();
        Set javaSourceFolderPaths = configuration.JAVA_SOURCE_FOLDER_PATHS;
        Set<String> sourceFolderPathsInLibraries = SourceFoldersUpdater.getSourceFolderPaths(configuration.NATIVE_LIBRARIES);
        Set<String> sourceFolderPathsInModule = SourceFoldersUpdater.getExistingSourceFolderPaths(facet.getModule());
        HashSet<String> sourceFolderPathsToAdd = new HashSet<String>();
        for (String path : sourceFolderPathsInLibraries) {
            if (sourceFolderPathsInModule.contains(path)) continue;
            sourceFolderPathsToAdd.add(path);
        }
        HashSet<String> sourceFolderPathsToRemove = new HashSet<String>();
        for (String path : sourceFolderPathsInModule) {
            if (sourceFolderPathsInLibraries.contains(path) || javaSourceFolderPaths.contains(path)) continue;
            sourceFolderPathsToRemove.add(path);
        }
        return new SourceFoldersToUpdate(sourceFolderPathsToAdd, sourceFolderPathsToRemove);
    }

    @NotNull
    private static Set<String> getSourceFolderPaths(@NotNull List<NativeLibrary> libraries) {
        HashSet<String> sourceFolderPaths = new HashSet<String>();
        for (NativeLibrary library : libraries) {
            sourceFolderPaths.addAll(library.getSourceFolderPaths());
        }
        return sourceFolderPaths;
    }

    @NotNull
    private static Set<String> getExistingSourceFolderPaths(@NotNull Module module) {
        HashSet<String> sourceFolderPaths = new HashSet<String>();
        for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module).getContentEntries()) {
            for (VirtualFile file : contentEntry.getSourceFolderFiles()) {
                File path = VfsUtilCore.virtualToIoFile((VirtualFile)file);
                sourceFolderPaths.add(path.getPath());
            }
        }
        return sourceFolderPaths;
    }

    @NotNull
    private static ModifiableRootModel getModifiableModuleModel(@NotNull Module module) {
        return (ModifiableRootModel)ApplicationManager.getApplication().runReadAction(() -> ModuleRootManager.getInstance((Module)module).getModifiableModel());
    }

    private static void commit(@NotNull ModifiableRootModel moduleModel) {
        WriteAction.runAndWait(() -> ((ModifiableRootModel)moduleModel).commit());
    }

    private static void dispose(@NotNull ModifiableRootModel moduleModel) {
        WriteAction.runAndWait(() -> ((ModifiableRootModel)moduleModel).dispose());
    }

    @VisibleForTesting
    static class SourceFoldersToUpdate {
        @NotNull
        private final Set<String> mySourceFolderPathsToAdd;
        @NotNull
        private final Set<String> mySourceFolderPathsToRemove;

        SourceFoldersToUpdate(@NotNull Set<String> sourceFolderPathsToAdd, @NotNull Set<String> sourceFolderPathsToRemove) {
            this.mySourceFolderPathsToAdd = sourceFolderPathsToAdd;
            this.mySourceFolderPathsToRemove = sourceFolderPathsToRemove;
        }

        @NotNull
        Set<String> getSourceFolderPathsToAdd() {
            return this.mySourceFolderPathsToAdd;
        }

        @NotNull
        Set<String> getSourceFolderPathsToRemove() {
            return this.mySourceFolderPathsToRemove;
        }
    }
}

