/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.editor;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.apk.debugging.DebuggableSharedObjectFile;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.editor.AbiAndSharedObjectFile;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.ui.table.TableView;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.JTableHeader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DebugSymbolTableView
extends TableView<AbiAndSharedObjectFile> {
    @NotNull
    private final NativeLibrary myLibrary;

    DebugSymbolTableView(@NotNull NativeLibrary library) {
        super(new ListTableModel(new ColumnInfo[]{new AbiColumnInfo(), new SharedObjectFileColumnInfo()}));
        this.myLibrary = library;
        this.updateContents();
        this.setRowHeight(new TextFieldWithBrowseButton().getButton().getPreferredSize().height);
        JTableHeader tableHeader = this.getTableHeader();
        tableHeader.setReorderingAllowed(false);
    }

    void updateContents() {
        this.getListTableModel().setItems(this.extractAbiAndSharedObjectFiles());
    }

    @NotNull
    private List<AbiAndSharedObjectFile> extractAbiAndSharedObjectFiles() {
        ArrayList<AbiAndSharedObjectFile> abiAndFiles = new ArrayList<AbiAndSharedObjectFile>();
        for (Abi abi : this.myLibrary.abis) {
            DebuggableSharedObjectFile file = (DebuggableSharedObjectFile)this.myLibrary.debuggableSharedObjectFilesByAbi.get(abi);
            abiAndFiles.add(new AbiAndSharedObjectFile(abi, file));
        }
        return abiAndFiles;
    }

    private static class AbiColumnInfo
    extends ColumnInfo<AbiAndSharedObjectFile, String> {
        AbiColumnInfo() {
            super("ABI");
        }

        @Nullable
        public String valueOf(@NotNull AbiAndSharedObjectFile item) {
            return item.getAbi().toString();
        }

        @NotNull
        public String getMaxStringValue() {
            return "armeabi-v7a";
        }

        public int getAdditionalWidth() {
            return 10;
        }
    }

    private static class SharedObjectFileColumnInfo
    extends ColumnInfo<AbiAndSharedObjectFile, String> {
        SharedObjectFileColumnInfo() {
            super("Debuggable Library");
        }

        @Nullable
        public String valueOf(@NotNull AbiAndSharedObjectFile item) {
            DebuggableSharedObjectFile file = item.getSharedObjectFile();
            return file != null ? file.path : "";
        }
    }
}

