/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeInspection.ExternalAnnotatorInspectionVisitor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ex.ExternalAnnotatorBatchInspection;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.annotation.ExternalAnnotator;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyAnnotator;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyConfigurable;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidyInspectionDescriptionProvider;
import com.jetbrains.cidr.lang.daemon.clang.tidy.ClangTidySettings;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionChecksDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOptionsButton;
import com.jetbrains.cidr.lang.inspections.ClangTidyChecksOptionsDialog;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyInspection
extends ClangTidyInspectionBase
implements ExternalAnnotatorBatchInspection {
    @NotNull
    private String myClangTidyChecks = ClangTidyInspection.getDefaultChecks();
    private boolean myPreferClangTidyFilesOverIDESettings = true;
    @NotNull
    private static final List<String> DEFAULT_CHECKS_CONFIGURATION = ClangTidyInspection.getDefaultChecksConfiguration();

    public boolean isEnabledByDefault() {
        return ClangTidyAnnotator.isAvailable();
    }

    @NotNull
    public static String getInspectionShortName() {
        return new ClangTidyInspection().getShortName();
    }

    @Override
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        return ClangdBundle.message("inspection.static.analysis", new Object[0]);
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        return ClangdBundle.message("inspection.clangTidy.name", new Object[0]);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        FormBuilder builder = FormBuilder.createFormBuilder();
        JPanel childPanel = new JPanel(new GridBagLayout());
        ClangTidyInspection.addComponent((Component)this.createClangTidyFilesCheckbox(), childPanel, 0, 2, 0, 1, 0, (Insets)JBUI.insetsBottom((int)10));
        ClangTidyInspection.addComponent(this.createChecksComponent(), childPanel, 0, 2, 1, 1, 0, (Insets)JBInsets.emptyInsets());
        ClangTidyInspection.addComponent((Component)ClangTidyInspection.createChecksExampleLink(), childPanel, 1, 2, 3, 1, 0, (Insets)JBInsets.emptyInsets());
        builder.addComponent((JComponent)childPanel);
        builder.addComponent(this.createOptionsButton(childPanel), 10);
        builder.addComponent((JComponent)CidrLangUtil.createLinkToConfigurable((String)ClangdBundle.message("configurable.clangTidy.executable", new Object[0]), ClangTidyConfigurable.class, null, null), 10);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)builder.getPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, (Insets)JBInsets.emptyInsets(), 0, 0));
        return panel;
    }

    @NotNull
    private JBCheckBox createClangTidyFilesCheckbox() {
        final JBCheckBox checkBox2 = new JBCheckBox(ClangdBundle.message("configurable.clangTidy.prefer.files.over.ide.settings", new Object[0]), this.myPreferClangTidyFilesOverIDESettings);
        checkBox2.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ClangTidyInspection.this.myPreferClangTidyFilesOverIDESettings = checkBox2.isSelected();
            }
        });
        return checkBox2;
    }

    @Override
    @NotNull
    public String getMessage(@NotNull String clangTidyMessage, boolean isBatchMode) {
        return isBatchMode ? clangTidyMessage : ClangdBundle.message("inspection.clangTidy.message", clangTidyMessage);
    }

    @Override
    public boolean canBeDisabledByClangTidyCheckName(@NotNull VirtualFile file, @NotNull Project project) {
        ClangTidyFilesState clangTidyFilesState = (ClangTidyFilesState)project.getService(ClangTidyFilesState.class);
        return !this.myPreferClangTidyFilesOverIDESettings || !clangTidyFilesState.hasClangTidyFilesInPath(new File(file.getPath()));
    }

    @Override
    @NotNull
    public String getSuppressName(@NotNull String clangTidyCheckName) {
        return clangTidyCheckName;
    }

    @Override
    public void disableGroups(@NotNull List<String> groups) {
        if (groups.size() == ClangTidyInspection.getAllAvailableGroups().size()) {
            this.setClangTidyChecks("-*");
            return;
        }
        super.disableGroups(groups);
    }

    @Override
    public void enableGroups(@NotNull List<String> groups) {
        if (groups.size() == ClangTidyInspection.getAllAvailableGroups().size()) {
            this.setClangTidyChecks("*");
            return;
        }
        super.enableGroups(groups);
    }

    @Override
    public void disableAllChecksInGroup(@NotNull String group) {
        this.setClangTidyChecks(CommonClangTidyUtil.disableGroup(this.getClangTidyChecks(), group));
    }

    @Override
    public void enableAllChecksInGroup(@NotNull String group) {
        this.setClangTidyChecks(CommonClangTidyUtil.enableGroup(this.getClangTidyChecks(), group));
    }

    @Override
    public void enableCheck(@NotNull String check) {
        this.setClangTidyChecks(CommonClangTidyUtil.enableCheck(this.getClangTidyChecks(), check));
    }

    @Override
    public void disableCheck(@NotNull String check) {
        this.setClangTidyChecks(CommonClangTidyUtil.disableCheck(this.getClangTidyChecks(), check));
    }

    private static void addComponent(@NotNull Component component, @NotNull JPanel panel, int gridX, int gridWidth, int gridY, int weightX, int weightY, @NotNull Insets insets) {
        panel.add(component, new GridBagConstraints(gridX, gridY, gridWidth, 1, weightX, weightY, 18, 2, insets, 0, 0));
    }

    @NotNull
    private JComponent createOptionsButton(final @NotNull Component component) {
        final ClangTidyCheckOptionsButton checkOptionsButton = new ClangTidyCheckOptionsButton(ClangdBundle.message("configurable.clangTidy.checks.options.button", new Object[0]));
        checkOptionsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                List checkOptions = ClangTidyInspection.this.myClangTidyCheckOptions;
                ClangTidyChecksOptionsDialog optionsDialog = new ClangTidyChecksOptionsDialog(component, checkOptions);
                optionsDialog.showAndGet();
                if (!ClangTidyInspection.this.myClangTidyCheckOptions.equals(checkOptions)) {
                    ClangTidyInspection.this.myClangTidyCheckOptions = checkOptions;
                    checkOptionsButton.fireStateChanged();
                }
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)checkOptionsButton, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 0, (Insets)JBInsets.emptyInsets(), 0, 0));
        return panel;
    }

    @NotNull
    private JComponent createChecksComponent() {
        final RawCommandLineEditor checksField = this.createChecksField();
        final ClangTidySettings settings = ClangTidySettings.getInstance();
        final Set<String> allChecks = settings.getPreviousClangTidyChecks();
        ActionListener browseButtonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (settings.getUseExternalClangTidy()) {
                    ((MessageDialogBuilder.Message)new MessageDialogBuilder.Message(ClangdBundle.message("clang.tidy.checks.dialog.title", new Object[0]), ClangdBundle.message("configurable.clangTidy.checks.button.not.available", new Object[0])).buttons(new String[]{IdeBundle.message((String)"button.ok", (Object[])new Object[0])}).icon(UIUtil.getInformationIcon())).show(null, null);
                } else {
                    InspectionChecksDialog dialog = new InspectionChecksDialog(ContainerUtil.notNullize((Set)allChecks), ClangTidyInspection.this.getClangTidyChecks(), ClangdBundle.message("clang.tidy.checks.dialog.title", new Object[0]), ClangTidyInspection.this, new ClangTidyInspectionDescriptionProvider(), null);
                    dialog.showAndGet();
                    checksField.setText(ClangTidyInspection.this.myClangTidyChecks);
                }
            }
        };
        ComponentWithBrowseButton component = new ComponentWithBrowseButton((JComponent)checksField, browseButtonListener);
        component.setButtonIcon(AllIcons.Actions.Edit);
        component.getButton().setToolTipText(ClangdBundle.message("configurable.clangTidy.checks.button", new Object[0]) + " (" + KeymapUtil.getKeystrokeText((KeyStroke)KeyStroke.getKeyStroke(10, 64)) + ")");
        return component;
    }

    @NotNull
    private RawCommandLineEditor createChecksField() {
        final RawCommandLineEditor checksEditor = new RawCommandLineEditor(text -> StringUtil.split((String)text, (String)","), checks -> StringUtil.join((Collection)checks, (String)","));
        checksEditor.getTextField().setFont(EditorUtil.getEditorFont((int)JBUI.Fonts.label().getSize()));
        checksEditor.setText(StringUtil.trim((String)this.myClangTidyChecks));
        checksEditor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                ClangTidyInspection.this.myClangTidyChecks = StringUtil.trim((String)checksEditor.getText());
            }
        });
        return checksEditor;
    }

    @NotNull
    private static HyperlinkLabel createChecksExampleLink() {
        HyperlinkLabel hint = new HyperlinkLabel();
        hint.setFontSize(UIUtil.FontSize.SMALL);
        hint.setTextWithHyperlink(ClangdBundle.message("configurable.clangTidy.checks.hint", new Object[0]));
        hint.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://clang.llvm.org/extra/clang-tidy/#using-clang-tidy"));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        return hint;
    }

    public ProblemDescriptor @Nullable [] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        return ProblemDescriptor.EMPTY_ARRAY;
    }

    public ProblemDescriptor @NotNull [] checkFile(@NotNull PsiFile file, @NotNull GlobalInspectionContext context, @NotNull InspectionManager manager) {
        ClangTidyAnnotator annotator = new ClangTidyAnnotator(this);
        return ExternalAnnotatorInspectionVisitor.checkFileWithExternalAnnotator((PsiFile)file, (InspectionManager)manager, (boolean)false, (ExternalAnnotator)annotator);
    }

    @Override
    public boolean isPreferClangTidyFilesOverIDESettings() {
        return this.myPreferClangTidyFilesOverIDESettings;
    }

    public void setPreferClangTidyFilesOverIDESettings(boolean preferClangTidyFilesOverIDESettings) {
        this.myPreferClangTidyFilesOverIDESettings = preferClangTidyFilesOverIDESettings;
    }

    @NotNull
    public String getClangTidyChecks() {
        return !this.myClangTidyChecks.isEmpty() ? this.myClangTidyChecks : ClangTidyInspection.getAllDisabledChecks();
    }

    public void setClangTidyChecks(@NotNull String clangTidyChecks) {
        this.myClangTidyChecks = clangTidyChecks;
    }

    @NotNull
    public static String getDefaultChecks() {
        return StringUtil.join(DEFAULT_CHECKS_CONFIGURATION, (String)",");
    }

    @NotNull
    public static String getAllEnabledChecks() {
        return "*";
    }

    @NotNull
    public static String getAllEnabledChecksExceptClangAnalyzer() {
        return "*,-clang-analyzer-*";
    }

    @NotNull
    public static String getAllDisabledChecks() {
        return "-*";
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static List<String> getDefaultChecksConfiguration() {
        @NonNls ArrayList enabledChecks = ContainerUtil.newArrayList((Object[])new String[]{"bugprone-argument-comment", "bugprone-assert-side-effect", "bugprone-bad-signal-to-kill-thread", "bugprone-branch-clone", "bugprone-copy-constructor-init", "bugprone-dangling-handle", "bugprone-dynamic-static-initializers", "bugprone-fold-init-type", "bugprone-forward-declaration-namespace", "bugprone-forwarding-reference-overload", "bugprone-inaccurate-erase", "bugprone-incorrect-roundings", "bugprone-integer-division", "bugprone-lambda-function-name", "bugprone-macro-parentheses", "bugprone-macro-repeated-side-effects", "bugprone-misplaced-operator-in-strlen-in-alloc", "bugprone-misplaced-pointer-arithmetic-in-alloc", "bugprone-misplaced-widening-cast", "bugprone-move-forwarding-reference", "bugprone-multiple-statement-macro", "bugprone-no-escape", "bugprone-not-null-terminated-result", "bugprone-parent-virtual-call", "bugprone-posix-return", "bugprone-reserved-identifier", "bugprone-sizeof-container", "bugprone-sizeof-expression", "bugprone-spuriously-wake-up-functions", "bugprone-string-constructor", "bugprone-string-integer-assignment", "bugprone-string-literal-with-embedded-nul", "bugprone-suspicious-enum-usage", "bugprone-suspicious-include", "bugprone-suspicious-memset-usage", "bugprone-suspicious-missing-comma", "bugprone-suspicious-semicolon", "bugprone-suspicious-string-compare", "bugprone-suspicious-memory-comparison", "bugprone-swapped-arguments", "bugprone-terminating-continue", "bugprone-throw-keyword-missing", "bugprone-too-small-loop-variable", "bugprone-undefined-memory-manipulation", "bugprone-undelegated-constructor", "bugprone-unhandled-self-assignment", "bugprone-unused-raii", "bugprone-unused-return-value", "bugprone-use-after-move", "bugprone-virtual-near-miss", "cert-dcl21-cpp", "cert-dcl58-cpp", "cert-err34-c", "cert-err52-cpp", "cert-err60-cpp", "cert-flp30-c", "cert-msc50-cpp", "cert-msc51-cpp", "cert-str34-c", "cppcoreguidelines-interfaces-global-init", "cppcoreguidelines-narrowing-conversions", "cppcoreguidelines-pro-type-member-init", "cppcoreguidelines-pro-type-static-cast-downcast", "cppcoreguidelines-slicing", "google-default-arguments", "google-explicit-constructor", "google-runtime-operator", "hicpp-exception-baseclass", "hicpp-multiway-paths-covered", "misc-misplaced-const", "misc-new-delete-overloads", "misc-no-recursion", "misc-non-copyable-objects", "misc-throw-by-value-catch-by-reference", "misc-unconventional-assign-operator", "misc-uniqueptr-reset-release", "modernize-avoid-bind", "modernize-concat-nested-namespaces", "modernize-deprecated-headers", "modernize-deprecated-ios-base-aliases", "modernize-loop-convert", "modernize-make-shared", "modernize-make-unique", "modernize-pass-by-value", "modernize-raw-string-literal", "modernize-redundant-void-arg", "modernize-replace-auto-ptr", "modernize-replace-disallow-copy-and-assign-macro", "modernize-replace-random-shuffle", "modernize-return-braced-init-list", "modernize-shrink-to-fit", "modernize-unary-static-assert", "modernize-use-auto", "modernize-use-bool-literals", "modernize-use-emplace", "modernize-use-equals-default", "modernize-use-equals-delete", "modernize-use-nodiscard", "modernize-use-noexcept", "modernize-use-nullptr", "modernize-use-override", "modernize-use-transparent-functors", "modernize-use-uncaught-exceptions", "mpi-buffer-deref", "mpi-type-mismatch", "openmp-use-default-none", "performance-faster-string-find", "performance-for-range-copy", "performance-implicit-conversion-in-loop", "performance-inefficient-algorithm", "performance-inefficient-string-concatenation", "performance-inefficient-vector-operation", "performance-move-const-arg", "performance-move-constructor-init", "performance-no-automatic-move", "performance-noexcept-move-constructor", "performance-trivially-destructible", "performance-type-promotion-in-math-fn", "performance-unnecessary-copy-initialization", "performance-unnecessary-value-param", "portability-simd-intrinsics", "readability-avoid-const-params-in-decls", "readability-const-return-type", "readability-container-size-empty", "readability-convert-member-functions-to-static", "readability-delete-null-pointer", "readability-deleted-default", "readability-inconsistent-declaration-parameter-name", "readability-make-member-function-const", "readability-misleading-indentation", "readability-misplaced-array-index", "readability-non-const-parameter", "readability-redundant-control-flow", "readability-redundant-declaration", "readability-redundant-function-ptr-dereference", "readability-redundant-smartptr-get", "readability-redundant-string-cstr", "readability-redundant-string-init", "readability-simplify-subscript-expr", "readability-static-accessed-through-instance", "readability-static-definition-in-anonymous-namespace", "readability-string-compare", "readability-uniqueptr-delete-release", "readability-use-anyofallof"});
        enabledChecks.sort(String::compareTo);
        ArrayList<String> configuration = new ArrayList<String>();
        configuration.add("-*");
        configuration.addAll(enabledChecks);
        return ContainerUtil.newUnmodifiableList(configuration);
    }

    private static Collection<String> getAllAvailableGroups() {
        ClangTidySettings settings = ClangTidySettings.getInstance();
        Set<String> allChecks = settings.getPreviousClangTidyChecks();
        HashSet<String> groups = new HashSet<String>();
        for (String check : allChecks) {
            groups.add(CommonClangTidyUtil.getGroupName(check));
        }
        return groups;
    }
}

