/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.AddEditRemovePanel;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.InplaceAddEditRemovePanel;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.inspections.ClangTidyCheckOption;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangTidyChecksOptionsDialog
extends DialogWrapper {
    @NotNull
    private final List<ClangTidyCheckOption> myCheckOptions;

    public ClangTidyChecksOptionsDialog(@NotNull Component parent, @NotNull List<ClangTidyCheckOption> checkOptions) {
        super(parent, false);
        this.myCheckOptions = checkOptions;
        this.setTitle(ClangdBundle.message("configurable.clangTidy.checks.options.dialog.title", new Object[0]));
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        FormBuilder builder = new FormBuilder();
        builder.addComponent(this.createTable());
        builder.addComponent((JComponent)new JBLabel(ClangdBundle.message("configurable.clangTidy.checks.options.example.hint", new Object[0]), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER));
        builder.addComponent((JComponent)ClangTidyChecksOptionsDialog.createHelpLink());
        return builder.getPanel();
    }

    @NotNull
    private JComponent createTable() {
        AddEditRemovePanel.TableModel<ClangTidyCheckOption> model = new AddEditRemovePanel.TableModel<ClangTidyCheckOption>(){

            public int getColumnCount() {
                return 2;
            }

            @NotNull
            public String getColumnName(int columnIndex) {
                return columnIndex == 0 ? ClangdBundle.message("configurable.clangTidy.checks.options.option.column", new Object[0]) : ClangdBundle.message("configurable.clangTidy.checks.options.value.column", new Object[0]);
            }

            public Object getField(ClangTidyCheckOption o, int columnIndex) {
                return columnIndex == 0 ? o.getOptionName() : o.getOptionValue();
            }

            public void setValue(Object aValue, ClangTidyCheckOption data, int columnIndex) {
                if (columnIndex == 0) {
                    data.setOptionName(aValue.toString());
                } else {
                    data.setOptionValue(aValue.toString());
                }
            }

            public boolean isEditable(int column) {
                return true;
            }
        };
        InplaceAddEditRemovePanel<ClangTidyCheckOption> panel = new InplaceAddEditRemovePanel<ClangTidyCheckOption>((AddEditRemovePanel.TableModel)model, this.myCheckOptions){

            @NotNull
            protected ClangTidyCheckOption addItem() {
                return new ClangTidyCheckOption();
            }

            protected boolean removeItem(ClangTidyCheckOption o) {
                return true;
            }

            public boolean isUpDownSupported() {
                return true;
            }
        };
        panel.getTable().setShowColumns(true);
        DefaultTableCellRenderer renderer = new DefaultTableCellRenderer();
        renderer.setHorizontalAlignment(0);
        TableColumnModel columnModel = panel.getTable().getColumnModel();
        columnModel.getColumn(0).setCellRenderer(renderer);
        columnModel.getColumn(1).setCellRenderer(renderer);
        return panel;
    }

    @NotNull
    private static HyperlinkLabel createHelpLink() {
        HyperlinkLabel hyperlink = new HyperlinkLabel(ClangdBundle.message("configurable.clangTidy.checks.options.learnMore.button", new Object[0]));
        hyperlink.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                HelpManager.getInstance().invokeHelp("clangtidy.checkoptions");
            }
        });
        return hyperlink;
    }
}

