/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.highlighting;

import com.intellij.codeInsight.highlighting.HeavyBraceHighlighter;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageService;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangLanguageServiceProvider;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangResult;
import com.jetbrains.cidr.lang.daemon.clang.clangd.ClangdBridge;
import com.jetbrains.cidr.lang.highlighting.ClangBracketMatchResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Ref;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0018\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0004H\u0014\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/lang/highlighting/ClangAngleBracketsMatcher;", "Lcom/intellij/codeInsight/highlighting/HeavyBraceHighlighter;", "()V", "findPositionWithAngle", "", "chars", "", "startOffset", "isAngle", "", "c", "", "isAvailable", "file", "Lcom/intellij/psi/PsiFile;", "offset", "matchBrace", "Lcom/intellij/openapi/util/Pair;", "Lcom/intellij/openapi/util/TextRange;", "intellij.c.clangd"})
public final class ClangAngleBracketsMatcher
extends HeavyBraceHighlighter {
    private final boolean isAngle(char c) {
        return c == '<' || c == '>';
    }

    private final int findPositionWithAngle(CharSequence chars, int startOffset) {
        int currentPos;
        for (currentPos = startOffset - 1; currentPos >= 0 && CharsKt.isWhitespace((char)chars.charAt(currentPos)); --currentPos) {
        }
        if (currentPos >= 0 && this.isAngle(chars.charAt(currentPos))) {
            return currentPos + 1;
        }
        int length = chars.length();
        for (currentPos = startOffset; currentPos < length && CharsKt.isWhitespace((char)chars.charAt(currentPos)); ++currentPos) {
        }
        if (currentPos < length && this.isAngle(chars.charAt(currentPos))) {
            return currentPos;
        }
        return -1;
    }

    protected boolean isAvailable(@NotNull PsiFile file, int offset) {
        if (!file.isValid()) {
            return false;
        }
        if (!ClangdBridge.isSupported(file.getProject(), file.getVirtualFile())) {
            return false;
        }
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return false;
        }
        Document document2 = document;
        CharSequence chars = document2.getCharsSequence();
        return this.findPositionWithAngle(chars, offset) >= 0;
    }

    @Nullable
    protected Pair<TextRange, TextRange> matchBrace(@NotNull PsiFile file, int offset) {
        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        ClangLanguageService service = ClangLanguageServiceProvider.getIfStarted(file.getProject());
        Ref.ObjectRef result = new Ref.ObjectRef();
        int angleOffset = this.findPositionWithAngle(document2.getCharsSequence(), offset);
        if (angleOffset < 0) {
            return null;
        }
        service.matchAngleBracket(file.getVirtualFile(), angleOffset, arg_0 -> ClangAngleBracketsMatcher.matchBrace$lambda$0(document2, result, arg_0));
        return (Pair)result.element;
    }

    private static final void matchBrace$lambda$0(Document $document, Ref.ObjectRef $result, ClangResult it) {
        ClangBracketMatchResult clangBracketMatchResult = (ClangBracketMatchResult)it.waitForResult();
        if (clangBracketMatchResult == null || (clangBracketMatchResult = clangBracketMatchResult.getRange()) == null) {
            return;
        }
        ClangBracketMatchResult rng = clangBracketMatchResult;
        if ($document.getLineCount() < rng.getEnd().getLine()) {
            return;
        }
        int lAngleOffset = $document.getLineStartOffset(rng.getStart().getLine() - 1) + rng.getStart().getCharacter() - 1;
        int rAngleOffset = $document.getLineStartOffset(rng.getEnd().getLine() - 1) + rng.getEnd().getCharacter() - 1;
        $result.element = new Pair((Object)new TextRange(lAngleOffset, lAngleOffset + 1), (Object)new TextRange(rAngleOffset, rAngleOffset + 1));
    }
}

