/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.usages;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import com.jetbrains.cidr.lang.daemon.clang.usages.ClangFoundUsage;
import org.eclipse.lsp4j.Position;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClangVirtualPsiElementStubForUsages
extends FakePsiElement {
    @NotNull
    private final PsiFile myFile;
    private final String myPresentation;
    @NotNull
    private final RangeMarker myRange;

    public ClangVirtualPsiElementStubForUsages(@NotNull ClangFoundUsage usage, @NotNull PsiFile file, @NotNull Document doc, String presentation) {
        this.myFile = file;
        this.myPresentation = presentation;
        Position start = usage.getLocation().getRange().getStart();
        Position end = usage.getLocation().getRange().getEnd();
        this.myRange = doc.createRangeMarker(doc.getLineStartOffset(start.getLine()) + start.getCharacter(), doc.getLineStartOffset(end.getLine()) + end.getCharacter());
    }

    @NotNull
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    @Nullable
    public PsiElement getParent() {
        return null;
    }

    private int getStartOffset() {
        return this.myRange.getStartOffset();
    }

    private int getEndOffset() {
        return this.myRange.getEndOffset();
    }

    @NotNull
    public Project getProject() {
        return this.myFile.getProject();
    }

    public int getTextOffset() {
        return this.getStartOffset();
    }

    @Nullable
    public TextRange getTextRange() {
        return new TextRange(this.getStartOffset(), this.getEndOffset());
    }

    @Nullable
    public String getPresentableText() {
        return this.myPresentation;
    }

    public boolean isValid() {
        return this.myFile.isValid() && this.myRange.isValid();
    }
}

