/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.google.common.html.HtmlEscapers;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckboxTreeListener;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.DumbAwareActionButton;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.jcef.JBCefBrowser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.clangd.settings.ClangTidyFilesState;
import com.jetbrains.cidr.lang.daemon.clang.tidy.CommonClangTidyUtil;
import com.jetbrains.cidr.lang.daemon.clang.tidy.InspectionDescriptionProvider;
import com.jetbrains.cidr.lang.inspections.ClangTidyInspectionBase;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.handler.CefRequestHandler;
import org.cef.handler.CefRequestHandlerAdapter;
import org.cef.network.CefRequest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionChecksDialog
extends DialogWrapper {
    private static final Logger LOG = Logger.getInstance(InspectionChecksDialog.class);
    @NotNull
    private final List<String> myChecks;
    @NotNull
    private final String myAvailableChecks;
    @NotNull
    private final ClangTidyInspectionBase myInspection;
    @NotNull
    private final Set<String> myInitialEnabledChecks;
    @NotNull
    private final InspectionDescriptionProvider myDescriptionProvider;
    @NotNull
    private final Set<CheckGroupTreeNode> myChangedGroupNodes = new HashSet<CheckGroupTreeNode>();
    @NotNull
    private final List<CheckGroupTreeNode> myAllGroupNodes = new ArrayList<CheckGroupTreeNode>();
    @Nullable
    private JBCefBrowser myHtmlDescriptionEditorPane = null;
    @Nullable
    private JBLabel myDescriptionPlaceholder = null;
    @Nullable
    private JBSplitter mySplitter = null;
    @Nullable
    private CheckboxTree myTree;
    @Nullable
    private final Project myProject;
    @NotNull
    private final MergingUpdateQueue myHtmlUpdateQueue = new MergingUpdateQueue("HTML Update", 500, true, null, null, null, false);

    public InspectionChecksDialog(@NotNull Collection<String> checks, @NotNull String availableChecks, @NlsContexts.DialogTitle String title, @NotNull ClangTidyInspectionBase inspection, @NotNull InspectionDescriptionProvider descriptionProvider, @Nullable Project project) {
        super(project, false);
        this.myChecks = new ArrayList<String>(checks);
        this.myAvailableChecks = availableChecks;
        this.myChecks.sort(NaturalComparator.INSTANCE);
        this.myInspection = inspection;
        this.myInitialEnabledChecks = this.getEnabledChecks();
        this.myDescriptionProvider = descriptionProvider;
        this.myProject = project != null ? project : (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        this.init();
        this.setTitle(title);
    }

    public void selectInspection(@NotNull String checkName) {
        if (this.myTree == null) {
            return;
        }
        String groupName = CommonClangTidyUtil.getGroupName(checkName);
        for (CheckGroupTreeNode groupNode : this.myAllGroupNodes) {
            if (!groupNode.toString().equals(groupName)) continue;
            for (int i = 0; i < groupNode.getChildCount(); ++i) {
                TreeModel model;
                TreeNode checkNode = groupNode.getChildAt(i);
                if (!checkNode.toString().equals(checkName) || !((model = this.myTree.getModel()) instanceof DefaultTreeModel)) continue;
                Object[] pathToRoot = ((DefaultTreeModel)model).getPathToRoot(checkNode);
                TreePath treePath = new TreePath(pathToRoot);
                this.myTree.setSelectionPaths(new TreePath[]{treePath});
                this.myTree.scrollPathToVisible(treePath);
            }
        }
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JComponent centerComponent = null;
        JPanel panel = new JPanel(new BorderLayout());
        this.myTree = this.createChecksTree();
        JComponent decorator = InspectionChecksDialog.createToolbarDecorator((CheckboxTreeBase)this.myTree);
        if (this.myDescriptionProvider.hasAnyHtmlDescription()) {
            this.createHtmlDescriptionPreviewPane();
            this.myDescriptionPlaceholder = this.createDescriptionPlaceholder();
            this.mySplitter = new JBSplitter(false, 0.6f);
            this.mySplitter.setFirstComponent((JComponent)this.myDescriptionPlaceholder);
            this.mySplitter.setSecondComponent(decorator);
            centerComponent = this.mySplitter;
        } else {
            centerComponent = decorator;
        }
        panel.add((Component)centerComponent, "Center");
        if (this.isClangTidyFilesCanOverrideDefaultSettings()) {
            panel.add((Component)InspectionChecksDialog.createClangTidyFilesOverrideHint(), "South");
        }
        panel.setPreferredSize(this.getPreferredDialogDimension());
        return panel;
    }

    private void createHtmlDescriptionPreviewPane() {
        try {
            this.myHtmlDescriptionEditorPane = JBCefBrowser.createBuilder().setEnableOpenDevToolsMenuItem(false).build();
            this.myHtmlDescriptionEditorPane.setProperty("JBCefBrowserBase.noContextMenu", (Object)true);
            this.myHtmlDescriptionEditorPane.getJBCefClient().addRequestHandler((CefRequestHandler)new CefRequestHandlerAdapter(){

                public boolean onBeforeBrowse(CefBrowser browser, CefFrame frame, CefRequest request, boolean user_gesture, boolean is_redirect) {
                    if (!user_gesture) {
                        return false;
                    }
                    if (!InspectionChecksDialog.this.tryNavigateToAnotherCheckDescription(request.getURL())) {
                        BrowserUtil.browse((String)request.getURL());
                    }
                    return true;
                }
            }, this.myHtmlDescriptionEditorPane.getCefBrowser());
        }
        catch (Exception e) {
            LOG.warn("Failed to create JBCefBrowser", (Throwable)e);
            this.myHtmlDescriptionEditorPane = null;
        }
    }

    private boolean tryNavigateToAnotherCheckDescription(@NotNull String url) {
        try {
            if (!new URL(url).getProtocol().startsWith("file")) {
                return false;
            }
            List urlParts = StringUtil.split((String)url, (String)"/", (boolean)true, (boolean)true);
            if (urlParts.size() < 2) {
                return false;
            }
            String checkNameWithoutGroup = FileUtil.getNameWithoutExtension((String)((String)urlParts.get(urlParts.size() - 1)));
            String groupName = (String)urlParts.get(urlParts.size() - 2);
            String checkName = groupName + "-" + checkNameWithoutGroup;
            if (!this.myDescriptionProvider.hasHtmlDescription(checkName)) {
                return false;
            }
            SwingUtilities.invokeLater(() -> this.selectInspection(checkName));
            return true;
        }
        catch (Exception e) {
            LOG.warn("Cannot navigate to bundled check-name page", (Throwable)e);
            return false;
        }
    }

    @NotNull
    private JBLabel createDescriptionPlaceholder() {
        JBLabel placeholder = new JBLabel(ClangdBundle.message(this.myHtmlDescriptionEditorPane != null ? "clang.tidy.check.description.placeholder" : "clang.tidy.check.preview.not.supported", new Object[0]));
        placeholder.setHorizontalAlignment(0);
        placeholder.setVerticalAlignment(0);
        placeholder.setForeground((Color)JBColor.GRAY);
        placeholder.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        return placeholder;
    }

    protected void doOKAction() {
        this.updateClangTidyConfiguration();
        super.doOKAction();
    }

    @NotNull
    private Set<String> getEnabledChecks() {
        List<String> options = CommonClangTidyUtil.getTrimmedOptions(this.myAvailableChecks);
        HashSet<String> enabledNewChecks = new HashSet<String>();
        for (String check : this.myChecks) {
            if (CommonClangTidyUtil.isDisabled(options, check)) continue;
            enabledNewChecks.add(check);
        }
        return enabledNewChecks;
    }

    private void updateClangTidyConfiguration() {
        List<String> disabledGroupNames = this.getDisabledGroupNames();
        if (disabledGroupNames.size() == this.myAllGroupNodes.size()) {
            this.myInspection.disableGroups(disabledGroupNames);
            return;
        }
        List<String> enabledGroupNames = this.getEnabledGroupNames();
        if (enabledGroupNames.size() == this.myAllGroupNodes.size()) {
            this.myInspection.enableGroups(enabledGroupNames);
            return;
        }
        List<CheckGroupTreeNode> groupNodesWithPartialState = this.getGroupNodesWithPartialState();
        if (disabledGroupNames.size() >= this.myAllGroupNodes.size() / 2) {
            this.myInspection.disableGroups(this.getAllGroupNames());
            this.myInspection.enableGroups(enabledGroupNames);
            this.updateParticularGroupNodes(groupNodesWithPartialState);
            return;
        }
        if (enabledGroupNames.size() >= this.myAllGroupNodes.size() / 2) {
            this.myInspection.enableGroups(this.getAllGroupNames());
            this.myInspection.disableGroups(disabledGroupNames);
            this.updateParticularGroupNodes(groupNodesWithPartialState);
            return;
        }
        this.updateParticularGroupNodes(this.myChangedGroupNodes);
    }

    private void updateParticularGroupNodes(@NotNull Collection<CheckGroupTreeNode> groupNodes) {
        for (CheckGroupTreeNode groupNode : groupNodes) {
            if (groupNode.allChecksDisabled()) {
                this.myInspection.disableAllChecksInGroup(groupNode.toString());
                continue;
            }
            if (groupNode.allChecksEnabled()) {
                this.myInspection.enableAllChecksInGroup(groupNode.toString());
                continue;
            }
            CommonClangTidyUtil.modifyAllChecksWithSingleGroup(groupNode.getAllChecks(), this.myInspection);
        }
    }

    @NotNull
    private List<String> getAllGroupNames() {
        return ContainerUtil.map(this.myAllGroupNodes, n -> n.toString());
    }

    @NotNull
    private List<String> getDisabledGroupNames() {
        return ContainerUtil.map((Collection)ContainerUtil.filter(this.myAllGroupNodes, n -> n.allChecksDisabled()), n -> n.toString());
    }

    @NotNull
    private List<String> getEnabledGroupNames() {
        return ContainerUtil.map((Collection)ContainerUtil.filter(this.myAllGroupNodes, n -> n.allChecksEnabled()), n -> n.toString());
    }

    @NotNull
    private List<CheckGroupTreeNode> getGroupNodesWithPartialState() {
        return ContainerUtil.filter(this.myAllGroupNodes, n -> n.isPartialState());
    }

    private CheckboxTree createChecksTree() {
        CheckedTreeNode rootNode = new CheckedTreeNode();
        final CheckboxTree tree = new CheckboxTree(this.createTreeCellRenderer(), rootNode, new CheckboxTreeBase.CheckPolicy(true, true, true, true));
        tree.addCheckboxTreeListener(new CheckboxTreeListener(){

            public void nodeStateChanged(@NotNull CheckedTreeNode node) {
                if (node instanceof CheckTreeNode && node.getParent() instanceof CheckGroupTreeNode) {
                    InspectionChecksDialog.this.myChangedGroupNodes.add((CheckGroupTreeNode)((Object)node.getParent()));
                } else if (node instanceof CheckGroupTreeNode) {
                    InspectionChecksDialog.this.myChangedGroupNodes.add((CheckGroupTreeNode)node);
                }
            }
        });
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                InspectionChecksDialog.this.updateHtmlDescriptionPane(tree);
            }
        });
        tree.setRootVisible(false);
        this.fillTreeWithData(rootNode);
        ((DefaultTreeModel)tree.getModel()).reload();
        new TreeSpeedSearch((JTree)tree, true, path -> path.getLastPathComponent().toString());
        TreeUtil.expandAll((JTree)tree);
        return tree;
    }

    private void updateHtmlDescriptionPane(@NotNull CheckboxTree tree) {
        if (this.mySplitter == null || this.myDescriptionPlaceholder == null || this.myHtmlDescriptionEditorPane == null) {
            return;
        }
        if (tree.getSelectionPaths() == null || tree.getSelectionPaths().length != 1) {
            this.myHtmlUpdateQueue.queue((Update)new InspectionDescriptionUpdate(null));
            return;
        }
        if (!(tree.getSelectionPaths()[0].getLastPathComponent() instanceof CheckTreeNode)) {
            this.myHtmlUpdateQueue.queue((Update)new InspectionDescriptionUpdate(null));
            return;
        }
        CheckTreeNode node = (CheckTreeNode)((Object)tree.getSelectionPaths()[0].getLastPathComponent());
        this.myHtmlUpdateQueue.queue((Update)new InspectionDescriptionUpdate(node.toString()));
    }

    private void showHtmlDescription(@NlsSafe String output, @NotNull String checkName) {
        assert (this.myHtmlDescriptionEditorPane != null && this.mySplitter != null);
        this.myHtmlDescriptionEditorPane.loadHTML(output, checkName);
        this.mySplitter.setFirstComponent(this.myHtmlDescriptionEditorPane.getComponent());
    }

    private void showPlaceholder(@NotNull @NlsContexts.Label String placeholderText) {
        assert (this.myDescriptionPlaceholder != null && this.mySplitter != null);
        this.myDescriptionPlaceholder.setText(placeholderText);
        this.mySplitter.setFirstComponent((JComponent)this.myDescriptionPlaceholder);
    }

    private void fillTreeWithData(@NotNull CheckedTreeNode rootNode) {
        String group;
        TreeMap<String, ArrayList> myCheckGroups = new TreeMap<String, ArrayList>();
        for (String string : this.myChecks) {
            group = CommonClangTidyUtil.getGroupName(string);
            if (myCheckGroups.containsKey(group)) {
                ((List)myCheckGroups.get(group)).add(string);
                continue;
            }
            myCheckGroups.put(group, ContainerUtil.newArrayList((Object[])new String[]{string}));
        }
        for (Map.Entry entry : myCheckGroups.entrySet()) {
            group = (String)entry.getKey();
            Collection checks = (Collection)entry.getValue();
            CheckGroupTreeNode groupNode = new CheckGroupTreeNode(group);
            for (String check : checks) {
                groupNode.add((MutableTreeNode)((Object)new CheckTreeNode(this.myInitialEnabledChecks.contains(check), check)));
            }
            rootNode.add((MutableTreeNode)((Object)groupNode));
            this.myAllGroupNodes.add(groupNode);
        }
    }

    @NotNull
    private CheckboxTree.CheckboxTreeCellRenderer createTreeCellRenderer() {
        return new CheckboxTree.CheckboxTreeCellRenderer(){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                Object userObject = ((CheckedTreeNode)value).getUserObject();
                if (userObject == null) {
                    return;
                }
                String text = (String)userObject;
                this.setToolTipText(InspectionChecksDialog.this.getTooltipText(text));
                this.getTextRenderer().append(text);
            }
        };
    }

    @Nullable
    @NlsSafe
    private String getTooltipText(@NotNull String checkName) {
        if (this.myDescriptionProvider.hasAnyHtmlDescription()) {
            return null;
        }
        try {
            String tooltip = this.myDescriptionProvider.getTooltip(checkName);
            if (StringUtil.isEmpty((String)tooltip)) {
                return null;
            }
            return HtmlEscapers.htmlEscaper().escape(tooltip);
        }
        catch (Exception e) {
            LOG.warn("Failed to get tooltip", (Throwable)e);
            return null;
        }
    }

    @NotNull
    private Dimension getPreferredDialogDimension() {
        return this.myDescriptionProvider.hasAnyHtmlDescription() ? new Dimension(1200, 500) : new Dimension(450, 500);
    }

    private boolean isClangTidyFilesCanOverrideDefaultSettings() {
        if (!this.myInspection.isPreferClangTidyFilesOverIDESettings()) {
            return false;
        }
        if (this.myProject == null) {
            return true;
        }
        ClangTidyFilesState state = (ClangTidyFilesState)this.myProject.getService(ClangTidyFilesState.class);
        return state != null && !state.getClangTidyFiles().isEmpty();
    }

    @NotNull
    private static JComponent createClangTidyFilesOverrideHint() {
        JBLabel hint = new JBLabel(AllIcons.General.Warning, 2);
        hint.setText(ClangdBundle.message("clang.tidy.update.settings.override", new Object[0]));
        return hint;
    }

    @NotNull
    private static JComponent createToolbarDecorator(final @NotNull CheckboxTreeBase tree) {
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JTree)tree).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"action.expand.all", (Object[])new Object[0]), AllIcons.Actions.Expandall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreeUtil.expandAll((JTree)tree);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"action.collapse.all", (Object[])new Object[0]), AllIcons.Actions.Collapseall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreeUtil.collapseAll((JTree)tree, (boolean)true, (int)0);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"command.select.all", (Object[])new Object[0]), AllIcons.Actions.Selectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InspectionChecksDialog.checkTree(tree, true);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        }).addExtraAction((AnActionButton)new DumbAwareActionButton(IdeBundle.message((String)"command.unselect.all", (Object[])new Object[0]), AllIcons.Actions.Unselectall){

            public void actionPerformed(@NotNull AnActionEvent e) {
                InspectionChecksDialog.checkTree(tree, false);
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                return ActionUpdateThread.EDT;
            }
        });
        return toolbarDecorator.setToolbarPosition(ActionToolbarPosition.RIGHT).createPanel();
    }

    private static void checkTree(CheckboxTreeBase tree, boolean checked) {
        CheckedTreeNode rootNode = (CheckedTreeNode)tree.getModel().getRoot();
        tree.setNodeState(rootNode, checked);
        tree.repaint();
    }

    private static class CheckGroupTreeNode
    extends CheckedTreeNode {
        CheckGroupTreeNode(@NotNull Object userObject) {
            super(userObject);
        }

        @NotNull
        Map<String, Boolean> getAllChecks() {
            HashMap<String, Boolean> checks = new HashMap<String, Boolean>();
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode)) continue;
                CheckTreeNode checkNode = (CheckTreeNode)((Object)node);
                checks.put(checkNode.toString(), checkNode.isChecked());
            }
            return checks;
        }

        boolean isPartialState() {
            Set childrenValues = Collections.list(this.children()).stream().filter(n -> n instanceof CheckTreeNode).map(n -> ((CheckTreeNode)((Object)((Object)n))).isChecked()).collect(Collectors.toSet());
            return childrenValues.size() == 2;
        }

        boolean allChecksEnabled() {
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode) || ((CheckTreeNode)((Object)node)).isChecked()) continue;
                return false;
            }
            return true;
        }

        boolean allChecksDisabled() {
            Enumeration children = this.children();
            while (children.hasMoreElements()) {
                TreeNode node = (TreeNode)children.nextElement();
                if (!(node instanceof CheckTreeNode) || !((CheckTreeNode)((Object)node)).isChecked()) continue;
                return false;
            }
            return true;
        }
    }

    private class InspectionDescriptionUpdate
    extends Update {
        private final long timeStamp;
        @Nullable
        private final String myCheckName;

        InspectionDescriptionUpdate(String checkName) {
            super((Object)checkName);
            this.timeStamp = System.currentTimeMillis();
            this.myCheckName = checkName;
        }

        public boolean canEat(Update update) {
            return update instanceof InspectionDescriptionUpdate && this.timeStamp > ((InspectionDescriptionUpdate)update).timeStamp;
        }

        public void run() {
            if (StringUtil.isEmpty((String)this.myCheckName)) {
                SwingUtilities.invokeLater(() -> InspectionChecksDialog.this.showPlaceholder(ClangdBundle.message("clang.tidy.check.description.placeholder", new Object[0])));
                return;
            }
            try {
                SwingUtilities.invokeLater(() -> InspectionChecksDialog.this.showPlaceholder(ClangdBundle.message("clang.tidy.check.description.loading", new Object[0])));
                String description = InspectionChecksDialog.this.myDescriptionProvider.getHtmlDescription(this.myCheckName);
                SwingUtilities.invokeLater(() -> {
                    if (StringUtil.isNotEmpty((String)description)) {
                        InspectionChecksDialog.this.showHtmlDescription(description, this.myCheckName);
                    } else {
                        InspectionChecksDialog.this.showPlaceholder(ClangdBundle.message("clang.tidy.check.description.not.available", new Object[0]));
                    }
                });
            }
            catch (Exception e) {
                LOG.warn("Failed to update HTML description", (Throwable)e);
                SwingUtilities.invokeLater(() -> InspectionChecksDialog.this.showPlaceholder(ClangdBundle.message("clang.tidy.check.description.not.available", new Object[0])));
            }
        }
    }

    private static class CheckTreeNode
    extends CheckedTreeNode {
        CheckTreeNode(boolean isChecked, @NotNull Object userObject) {
            super(userObject);
            this.setChecked(isChecked);
        }
    }
}

