/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.tidy;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import java.io.File;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class EditClangTidyOptionsAction
extends DumbAwareAction {
    private final File mySourceFile;
    private final Project myProject;
    private final File myClangTidyFile;

    public EditClangTidyOptionsAction(@NotNull File sourceFile, @NotNull Project project, File clangTidyFile) {
        super(ClangdBundle.message("clang.tidy.view.file.options.action", sourceFile.getName()));
        this.mySourceFile = sourceFile;
        this.myProject = project;
        this.myClangTidyFile = clangTidyFile;
    }

    public void update(@NotNull AnActionEvent e) {
        if (this.myClangTidyFile != null) {
            e.getPresentation().setText(ClangdBundle.message("clang.tidy.view.file.options.action", this.getFileName()));
            e.getPresentation().setEnabledAndVisible(true);
        } else {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (this.myClangTidyFile == null) {
            return;
        }
        VirtualFile file = VfsUtil.findFile((Path)Path.of(this.myClangTidyFile.getPath(), new String[0]), (boolean)true);
        if (file != null) {
            FileEditorManager.getInstance((Project)this.myProject).openFile(file, true);
        }
    }

    @NotNull
    private String getFileName() {
        return StringUtil.escapeMnemonics((String)this.mySourceFile.getName());
    }
}

